/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.impl.RepertoireHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class ConfigureMMIRepertoiresAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "14/109 26-CRH 109 042/1-1";
    private static final int LOW_VERSION = 8000000;
    private static final int HIGH_VERSION = 13030799;
    private static final ConfigureMMIRepertoiresAue INSTANCE = new ConfigureMMIRepertoiresAue();
    private static final String CPP_EMAS_Views = "CPP_EMAS_Views";
    private static final String CPP_SYS_PAR = "CPP_SYS_PAR";
    private static final String Cello_OAM_Other = "Cello_OAM_Other";
    private static final String RBS_SEC = "RBS_SEC";
    private static final String RBS_APC_AUE1 = "RBS_APC_AUE1";
    private static final String RBS_OAM_AUE1 = "RBS_OAM_AUE1";
    private static final String RBS_OAM_Other = "RBS_OAM_Other";
    private static final String RBS_AUE = "RBS_AUE";
    private static final String RBS_SYS_PAR = "RBS_SYS_PAR";
    private static final String RBS_SYS_PAR_RBS6000 = "RBS_SYS_PAR_RBS6000";
    private static final String RBS_OTHER = "RBS_OTHER";
    private static final String SW_ALLOCATION = "SwAllocation";
    private static final String PRODUCT_NAME = "productName";
    private static final String NODES_TYPE_6K = "RBS6";

    private ConfigureMMIRepertoiresAue() {
        super(ConfigureMMIRepertoiresAue.class);
    }

    public int getLowVersion() {
        return 8000000;
    }

    public int getHighVersion() {
        return 13030799;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    public static ConfigureMMIRepertoiresAue instance() {
        return INSTANCE;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        this.traceEnter("triggerRbsInitiate(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("doExecute");
        Coordinator context = tw.getCoordinator();
        SwAllocationMo swAllocation = (SwAllocationMo)RepertoireHelper.getMo(SW_ALLOCATION, RBS_OTHER);
        if (swAllocation == null) {
            this.trace("the SwAllocation does not exist and need be created");
            swAllocation = this.createSwAllocatio_RBS_OTHER(context);
        } else {
            this.trace("the SwAllocation has exist and need not be created");
        }
        if (this.checkRbsType6k(context)) {
            RepertoireHelper.addRepertoire(swAllocation, RBS_SYS_PAR_RBS6000, context, false);
        }
        return true;
    }

    private boolean checkRbsType6k(Coordinator context) throws NoSuchAttributeException, MoAccessException {
        this.traceEnter("check if the node is 6k or not");
        ManagedObject rootMo = MibMgr.instance().getMib().getRootMo();
        String productName = (String)rootMo.getAttribute(PRODUCT_NAME, context);
        if (productName.startsWith(NODES_TYPE_6K)) {
            this.trace("this node is " + productName + ",and the node is 6K node");
            return true;
        }
        this.trace("this node is " + productName + ", and the node is not 6K node");
        return false;
    }

    private SwAllocationMo createSwAllocatio_RBS_OTHER(Coordinator context) throws Exception {
        this.traceEnter("createSwAllocatio_RBS_OTHER()");
        SwAllocationMo swAllocation = RepertoireHelper.createSwAllocationIfNeeded(context, RBS_OTHER);
        ManagedObject activeOtherLMs = RepertoireHelper.getMo("ActiveOtherLMs");
        if (activeOtherLMs == null) {
            throw new Exception("Can't find rbs_other MO");
        }
        swAllocation.actionAddSlot(activeOtherLMs, context);
        RepertoireHelper.addRepertoire(swAllocation, CPP_EMAS_Views, context, false);
        RepertoireHelper.addRepertoire(swAllocation, CPP_SYS_PAR, context, false);
        RepertoireHelper.addRepertoire(swAllocation, Cello_OAM_Other, context, false);
        RepertoireHelper.addRepertoire(swAllocation, RBS_SEC, context, false);
        RepertoireHelper.addRepertoire(swAllocation, RBS_APC_AUE1, context, false);
        RepertoireHelper.addRepertoire(swAllocation, RBS_OAM_AUE1, context, false);
        RepertoireHelper.addRepertoire(swAllocation, RBS_OAM_Other, context, false);
        RepertoireHelper.addRepertoire(swAllocation, RBS_AUE, context, false);
        RepertoireHelper.addRepertoire(swAllocation, RBS_SYS_PAR, context, false);
        return swAllocation;
    }
}

