/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.impl.RepertoireHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NodeBFunctionMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Database;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DbAccessException;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Sql;

public final class ConfigureRepertoiresWRNae71614Aue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "14/109 26-CRH 109 042/1-1";
    public static final int LOW_VERSION = 8051800;
    private static final int HIGH_VERSION = 13030699;
    private static final ConfigureRepertoiresWRNae71614Aue INSTANCE = new ConfigureRepertoiresWRNae71614Aue();
    private static final String CELLO_OAM = "Cello_OAM";
    private static final String RBS_OAM = "RBS_OAM";
    private static final String RBS_COMMON6K_OAM = "RBS_Common6K_OAM";
    private static final String RBS_COMMON6K = "RBS_Common6K";
    private static final String RBS_APC_MAIN1 = "RBS_APC_MAIN1";
    private static final String RBS_APC_MAIN2 = "RBS_APC_MAIN2";
    private static final String RBS_OAM_MAIN1 = "RBS_OAM_MAIN1";
    private static final String RBS_GPB_MAIN_ROLE = "RBS_GPB_Main";
    private static final String RBS_CBU_MAIN_ROLE = "RBS_CBU_Main";
    private static final String RBS_DU_MAIN_ROLE = "RBS_DU_Main";
    private static final String RBS_DUW_MAIN_ROLE = "Main_DUW";
    private static final String RBS_JVM = "RBS_JVM";
    private static final String SW_ALLOCATION = "SwAllocation";
    private static final String REPERTOIRE = "Repertoire";
    private static final String JVM = "Jvm";
    private static final String APC_FRO_VERSIONS = "apc_fro_versions";
    private static final String APC_FRO_ATTRIBUTES = "apc_fro_attributes";
    private static final String PRODUCT_NAME = "productName";
    private static final String[] NODES_WITH_APC = new String[]{"RBS3018", "RBS6"};
    private static final String SUPPORT_SYSTEM_AVAILABLE = "supportsystemAvailable";

    private ConfigureRepertoiresWRNae71614Aue() {
        super(ConfigureRepertoiresWRNae71614Aue.class);
    }

    public int getLowVersion() {
        return 8051800;
    }

    public int getHighVersion() {
        return 13030699;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    public static ConfigureRepertoiresWRNae71614Aue instance() {
        return INSTANCE;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        this.traceEnter("triggerRbsInitiate(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("doExecute");
        Coordinator context = tw.getCoordinator();
        if (this.isValidateConfiguration(context)) {
            this.createRbsJvmConfiguration(context);
            if (this.getMo("Cabinet") != null) {
                this.addSoamRepertoire(context);
            } else {
                this.removeApcRepertoire(RBS_GPB_MAIN_ROLE, context);
                this.removeApcRepertoire(RBS_CBU_MAIN_ROLE, context);
                this.removeApcRepertoire(RBS_DU_MAIN_ROLE, context);
                this.removeApcRepertoire(RBS_DUW_MAIN_ROLE, context);
            }
        } else {
            this.fixRbsJvmConfiguration(context);
            this.removeApcRepertoire(RBS_GPB_MAIN_ROLE, context);
            this.removeApcRepertoire(RBS_CBU_MAIN_ROLE, context);
            this.removeApcRepertoire(RBS_DU_MAIN_ROLE, context);
            this.removeApcRepertoire(RBS_DUW_MAIN_ROLE, context);
            this.fixDB(context);
        }
        return true;
    }

    private void removeApcRepertoire(String swAllocationRole, Coordinator context) throws Exception {
        this.traceEnter("removeApcRepertoire()");
        SwAllocationMo swAllocation = (SwAllocationMo)this.getSwAllocationMo(SW_ALLOCATION, swAllocationRole, context);
        String apcRepertoireName = this.getApcRepertoireName(context);
        if (swAllocation != null && apcRepertoireName != null) {
            ManagedObject[] reps = swAllocation.getRepertoireList(context);
            for (int i = 0; i < reps.length; ++i) {
                if (!((RepertoireMo)reps[i]).getName(context).equals(apcRepertoireName)) continue;
                ManagedObject apcRepertoire = RepertoireHelper.getMo(REPERTOIRE, apcRepertoireName);
                if (apcRepertoire == null) {
                    this.trace("Can't find MO Repertoire=" + apcRepertoireName + ", nothing to do");
                    continue;
                }
                this.trace("Found Repertoire :" + apcRepertoire.getFullDistinguishedName() + " from " + swAllocation.getFullDistinguishedName());
                swAllocation.actionDeleteRepertoire(apcRepertoire, context);
                this.trace("Removed " + apcRepertoire.getFullDistinguishedName() + " from " + swAllocation.getFullDistinguishedName());
            }
        } else {
            if (swAllocation == null) {
                this.trace("Can't find MO SwAllocationrole =" + swAllocationRole);
            }
            if (apcRepertoireName == null) {
                this.trace("Can't find APC Repertoire");
            }
        }
    }

    private ManagedObject getMo(String name) {
        this.trace("getMo(" + name + ")");
        MoIterator moList = BoamHelper.findMOs((String)name);
        if (moList.hasMoreElements()) {
            return (ManagedObject)moList.nextElement();
        }
        return null;
    }

    private ManagedObject getSwAllocationMo(String typeName, String role, Coordinator context) throws MoAccessException {
        this.trace("getMo(" + typeName + ", " + role + ")");
        MoIterator moList = BoamHelper.findMOs((String)typeName);
        while (moList.hasMoreElements()) {
            SwAllocationMo swAlloc = (SwAllocationMo)moList.nextElement();
            if (!swAlloc.getRole(context).equalsIgnoreCase(role)) continue;
            return swAlloc;
        }
        return null;
    }

    private void createRbsJvmConfiguration(Coordinator context) throws Exception {
        this.traceEnter("createRbsJvmConfiguration()");
        SwAllocationMo swAllocation = RepertoireHelper.createSwAllocationIfNeeded(context, RBS_JVM);
        ManagedObject jvm = this.getMo(JVM);
        if (jvm == null) {
            throw new Exception("Can't find Jvm MO");
        }
        swAllocation.actionAddSlot(jvm, context);
        RepertoireHelper.addRepertoire(swAllocation, CELLO_OAM, context, true);
        RepertoireHelper.addRepertoire(swAllocation, RBS_OAM, context, true);
    }

    private void fixRbsJvmConfiguration(Coordinator context) throws Exception {
        this.traceEnter("fixRbsJvmConfiguration()");
        boolean checkedCelloOAM = false;
        boolean checkedRbsOAM = false;
        SwAllocationMo rbsJvmswAllocation = RepertoireHelper.createSwAllocationIfNeeded(context, RBS_JVM);
        ManagedObject[] slotList = rbsJvmswAllocation.getSlotList(context);
        if (slotList != null && slotList.length == 0) {
            ManagedObject jvm = this.getMo(JVM);
            if (jvm == null) {
                throw new Exception("Can't find Jvm MO");
            }
            rbsJvmswAllocation.actionAddSlot(jvm, context);
        }
        ManagedObject[] reps = rbsJvmswAllocation.getRepertoireList(context);
        for (int j = 0; j < reps.length; ++j) {
            if (((RepertoireMo)reps[j]).getName(context).equals(CELLO_OAM)) {
                checkedCelloOAM = true;
                continue;
            }
            if (!((RepertoireMo)reps[j]).getName(context).equals(RBS_OAM)) continue;
            checkedRbsOAM = true;
        }
        if (!checkedCelloOAM) {
            RepertoireHelper.addRepertoire(rbsJvmswAllocation, CELLO_OAM, context, true);
        }
        if (!checkedRbsOAM) {
            RepertoireHelper.addRepertoire(rbsJvmswAllocation, RBS_OAM, context, true);
        }
    }

    boolean isValidateConfiguration(Coordinator context) throws DbAccessException, MoAccessException {
        this.traceEnter("isValidateConfiguration()");
        Database db = DatabaseMgr.getDatabase();
        return this.getMo("Cabinet") != null || !db.tableExists(APC_FRO_VERSIONS) && !db.tableExists(APC_FRO_ATTRIBUTES);
    }

    private void fixDB(Coordinator context) throws NoSuchAttributeException, MoAccessException, DbAccessException {
        if (!this.shouldApcExist(context)) {
            Sql sql;
            Database db = DatabaseMgr.getDatabase();
            this.trace(ConfigureRepertoiresWRNae71614Aue.class.getName() + " DropTable APC_FRO_VERSIONS");
            if (db.tableExists(APC_FRO_VERSIONS)) {
                sql = DatabaseMgr.getSql();
                db.executeSql(sql.dropTable(APC_FRO_VERSIONS));
            }
            this.trace(ConfigureRepertoiresWRNae71614Aue.class.getName() + " DropTable APC_FRO_ATTRIBUTES");
            if (db.tableExists(APC_FRO_ATTRIBUTES)) {
                sql = DatabaseMgr.getSql();
                db.executeSql(sql.dropTable(APC_FRO_ATTRIBUTES));
            }
        }
    }

    private boolean shouldApcExist(Coordinator context) throws NoSuchAttributeException, MoAccessException {
        ManagedObject rootMo = MibMgr.instance().getMib().getRootMo();
        String productName = (String)rootMo.getAttribute(PRODUCT_NAME, context);
        for (int i = 0; i < NODES_WITH_APC.length; ++i) {
            NodeBFunctionMo nodeB;
            Boolean isSupportSystemAvailable;
            if (!productName.startsWith(NODES_WITH_APC[i]) || !(isSupportSystemAvailable = (Boolean)(nodeB = (NodeBFunctionMo)this.getMo("NodeBFunction")).getAttribute(SUPPORT_SYSTEM_AVAILABLE, context)).booleanValue()) continue;
            this.trace("APC should exist on this node (" + productName + ")");
            return true;
        }
        this.trace("APC should not exist on this node ( " + productName + " )");
        return false;
    }

    private void addSoamRepertoire(Coordinator context) throws Exception {
        this.traceEnter("addSoamRepertoire()");
        SwAllocationMo rbsJvmswAllocation = RepertoireHelper.createSwAllocationIfNeeded(context, RBS_JVM);
        String[] soamRepertoireNames = this.getSoamRepertoireNames(context);
        if (soamRepertoireNames != null) {
            for (int i = 0; i < soamRepertoireNames.length; ++i) {
                ManagedObject soamRepertoire = RepertoireHelper.getMo(REPERTOIRE, soamRepertoireNames[i]);
                if (soamRepertoire == null) {
                    throw new Exception("Can't find MO Repertoire=" + soamRepertoireNames[i]);
                }
                RepertoireHelper.addRepertoire(rbsJvmswAllocation, soamRepertoire, context);
            }
        } else {
            throw new Exception("Can't find Soam Repertoire.");
        }
    }

    private String[] getSoamRepertoireNames(Coordinator context) throws Exception {
        this.traceEnter("getSoamRepertoireNames()");
        ManagedObject rbsCommon6KOam = RepertoireHelper.getMo(REPERTOIRE, RBS_COMMON6K_OAM);
        ManagedObject rbsApcMain2 = RepertoireHelper.getMo(REPERTOIRE, RBS_APC_MAIN2);
        ManagedObject rbsOamMain1 = RepertoireHelper.getMo(REPERTOIRE, RBS_OAM_MAIN1);
        if (rbsCommon6KOam != null && rbsApcMain2 == null && rbsOamMain1 == null) {
            return new String[]{RBS_COMMON6K_OAM};
        }
        if (rbsCommon6KOam == null && rbsApcMain2 != null && rbsOamMain1 != null) {
            return new String[]{RBS_APC_MAIN2, RBS_OAM_MAIN1};
        }
        if (rbsCommon6KOam == null && rbsApcMain2 == null && rbsOamMain1 == null) {
            return null;
        }
        throw new Exception("Wrong configuration!RBS_Common6K_OAM and (RBS_APC_MAIN2//RBS_OAM_MAIN1) can't co-exist");
    }

    private String getApcRepertoireName(Coordinator context) throws Exception {
        this.traceEnter("getApcRepertoireName()");
        ManagedObject rbsCommon6K = RepertoireHelper.getMo(REPERTOIRE, RBS_COMMON6K);
        ManagedObject rbsApcMain1 = RepertoireHelper.getMo(REPERTOIRE, RBS_APC_MAIN1);
        if (rbsCommon6K != null && rbsApcMain1 == null) {
            return RBS_COMMON6K;
        }
        if (rbsCommon6K == null && rbsApcMain1 != null) {
            return RBS_APC_MAIN1;
        }
        if (rbsCommon6K == null && rbsApcMain1 == null) {
            return null;
        }
        throw new Exception("Wrong configuration!RBS_Common6K and RBS_APC_MAIN1 can't co-exist");
    }
}

