/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public class DuwIn3KToW18RestrictionAue
extends BoamSubAueBase {
    private static final Class SELF = DuwIn3KToW18RestrictionAue.class;
    private static final String DCI_REFERENCE = "16/109 26-CRH 109 042/1-1";
    private static final int LOW_VERSION = 27010000;
    private static final int HIGH_VERSION = 40000000;
    private static final String NODES_TYPE_3K = "RBS3";
    private static final DuwIn3KToW18RestrictionAue INSTANCE = new DuwIn3KToW18RestrictionAue();

    private DuwIn3KToW18RestrictionAue() {
        super(SELF);
    }

    public static DuwIn3KToW18RestrictionAue instance() {
        MessageLog.traceEnter((Class)SELF, (String)("instance() " + SELF.getName()));
        return INSTANCE;
    }

    public int getLowVersion() {
        return 27010000;
    }

    public int getHighVersion() {
        return 40000000;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)("triggerRbsInitiate() in " + SELF.getName()));
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        try {
            return !this.checkIfXcuExistForDuwIn3K(tw.getCoordinator());
        }
        catch (Exception e) {
            this.traceError("Exception caught, can not upgrage to W18 for DUW in 3k", e);
            return false;
        }
    }

    private boolean checkIfXcuExistForDuwIn3K(Coordinator context) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"checkIfXcuExistForDuwIn3K()");
        boolean isRbs3k = false;
        AuxPlugInUnitMo auxMo = null;
        MoIterator moIter = BoamHelper.findMOs((String)"AuxPlugInUnit");
        while (moIter.hasMoreElements()) {
            auxMo = (AuxPlugInUnitMo)moIter.nextMo();
            MessageLog.traceEnter((Class)SELF, (String)("The auxPlugInUnit type is " + auxMo.getAuType(context)));
            if (auxMo.getAuType(context) != 24 || !this.checkRbsType3k(context)) continue;
            MessageLog.traceError((Class)SELF, (String)"Warning!!!,RBS type belongs to  DUW in 3k ,can not upgrade to W18 and afterwards software");
            isRbs3k = true;
        }
        return isRbs3k;
    }

    private boolean checkRbsType3k(Coordinator context) throws NoSuchAttributeException, MoAccessException {
        this.traceEnter("Check if the node is 3k or not");
        ManagedObject rootMo = MibMgr.instance().getMib().getRootMo();
        String productName = (String)rootMo.getAttribute("productName", context);
        if (productName.startsWith(NODES_TYPE_3K)) {
            this.trace("This node is " + productName + ",and the node is 3K node");
            return true;
        }
        this.trace("This node is " + productName + ", and the node is not 3K node");
        return false;
    }
}

