/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.conv.operations.AddBaseBandReferenceAttributeOp;
import se.ericsson.wcdma.rbs.boam.conv.operations.AddExistReserveAttributeOp;
import se.ericsson.wcdma.rbs.boam.conv.operations.CreateDeviceOp;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Macro;
import se.ericsson.wcdma.rbs.boam.upfwk.common.AttributeHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoConverterUtility;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.operations.CreateMoDataOp;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;

public class DC18020299To18020300
extends DataConverterBase {
    public static final int FROM_CONVERTER_REV = 18020299;
    public static final int TO_CONVERTER_REV = 18020300;
    private static final String CARRIER = "Carrier";
    private static final String DOWNLINK_BASE_BAND_POOL_REF = "downlinkBaseBandPoolRef";
    private static final String RADIO_INTERFACE_BOARD_REF = "radioInterfaceBoardRef";
    private static final DC18020299To18020300 INSTANCE = new DC18020299To18020300();
    private final Macro macro = new Macro();

    private DC18020299To18020300() {
        super(18020299, 18020300);
    }

    public static DC18020299To18020300 instance() {
        return INSTANCE;
    }

    protected void initDC(Coordinator context) throws Exception {
        Attribute[] attributes;
        String cModataLdn;
        int i;
        this.traceEnter("initDC()");
        this.context = context;
        this.trace("Init DC for downlinkBaseBandPoolRef of Carrier");
        this.macro.add(new AddBaseBandReferenceAttributeOp(this.workingMoData, CARRIER, 18020300, DOWNLINK_BASE_BAND_POOL_REF, false, context));
        this.trace("Init DC for DbccDeviceFor12ccAue");
        this.macro.add(new CreateDeviceOp(this.workingMoData, context, "DbccDevice", "DbccDeviceSet", "TxDeviceGroup", 18020300, 12, false));
        this.trace("Init DC for IncreaseBasebandPoolAue");
        CMoData[] cModata = MoConverterUtility.getCMoDataByType("UplinkBaseBandPool", context);
        if (cModata != null && cModata.length > 0) {
            for (i = 0; i < cModata.length; ++i) {
                cModataLdn = cModata[i].getLocalDistinguishedName();
                attributes = new Attribute[]{AttributeHelper.convertCMoDataAttributeToMoDataAttrbute(cModata[i].getAttribute("userLabel")), this.getRadioRef(cModataLdn), AttributeHelper.convertCMoDataAttributeToMoDataAttrbute(cModata[i].getAttribute("alarmStatus")), AttributeHelper.convertCMoDataAttributeToMoDataAttrbute(cModata[i].getAttribute("froId"))};
                this.macro.add(new CreateMoDataOp(this.workingMoData, context, cModataLdn, attributes, 5020000));
                this.macro.add(new AddExistReserveAttributeOp(this.workingMoData, context, this.getRadioRefString(cModataLdn), "DeviceGroup", cModataLdn));
            }
        } else {
            this.traceEnter("The CMoData is empty for UplinkBaseBandPool");
        }
        cModata = MoConverterUtility.getCMoDataByType("DownlinkBaseBandPool", context);
        if (cModata != null && cModata.length > 0) {
            for (i = 0; i < cModata.length; ++i) {
                cModataLdn = cModata[i].getLocalDistinguishedName();
                attributes = new Attribute[]{AttributeHelper.convertCMoDataAttributeToMoDataAttrbute(cModata[i].getAttribute("userLabel")), this.getRadioRef(cModataLdn), AttributeHelper.convertCMoDataAttributeToMoDataAttrbute(cModata[i].getAttribute("alarmStatus")), AttributeHelper.convertCMoDataAttributeToMoDataAttrbute(cModata[i].getAttribute("froId"))};
                this.macro.add(new CreateMoDataOp(this.workingMoData, context, cModataLdn, attributes, 5020000));
                this.macro.add(new AddExistReserveAttributeOp(this.workingMoData, context, this.getRadioRefString(cModataLdn), "DeviceGroup", cModataLdn));
            }
        } else {
            this.traceEnter("The CMoData is empty for DownlinkBaseBandPool");
        }
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        CommandHandler.execute(this.macro, 1);
    }

    private SequenceAttribute getRadioRef(String bbpLdn) {
        MessageLog.traceEnter((Class)DC18020299To18020300.class, (String)("--> getRadioRef() with bbpLdn=" + bbpLdn));
        SequenceAttribute sa = new SequenceAttribute(RADIO_INTERFACE_BOARD_REF, false);
        ReferenceAttribute ra = new ReferenceAttribute(RADIO_INTERFACE_BOARD_REF, this.getRadioRefString(bbpLdn), false);
        sa.addElement((Attribute)ra);
        return sa;
    }

    private String getRadioRefString(String bbpLdn) {
        MessageLog.traceEnter((Class)DC18020299To18020300.class, (String)("--> getRadioRefString() with bbpLdn=" + bbpLdn));
        String newMoIdentity = LDNHelper.getNamingAttributeValue(bbpLdn);
        int slotId = Integer.parseInt(newMoIdentity) - 2;
        MessageLog.traceParam((Class)DC18020299To18020300.class, (String)("--> radioInterfaceBoardRef with slotId=" + slotId));
        String subrackLdn = bbpLdn.substring(0, bbpLdn.lastIndexOf(","));
        String duiRef = subrackLdn + ",Slot=" + slotId + ",PlugInUnit=1,PiuDevice=1,DeviceGroup=DUI";
        return duiRef;
    }
}

