/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.helper.TopologyMgr;

public class DC8050598To8050599
extends DataConverterBase {
    private static final DC8050598To8050599 INSTANCE = new DC8050598To8050599();
    protected static final int fromConverterRev = 8050598;
    protected static final int toConverterRev = 0x7AD7A7;
    private static final String RF_CABLE_TYPE_NAME = "RfCable";
    private static final String VALUE_SEPARATOR = "=";
    private static final String PM_SERVICE_TYPE_NAME = "PmService";
    private static final String MAX_NO_OF_MONITORS = "maxNoOfMonitors";
    private static final String MAX_NO_OF_COUNTERS = "maxNoOfCounters";
    private static final String RRUW = "RRUW";
    private static final char UNDERSCORE = '_';
    private Coordinator context;

    private DC8050598To8050599() {
        super(8050598, 0x7AD7A7);
    }

    public static DC8050598To8050599 instance() {
        return INSTANCE;
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
        this.context = context;
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        List updateCandidates = this.findUpdateCandidates();
        if (updateCandidates.isEmpty()) {
            this.trace("No upgrade is necessary.");
        } else {
            this.updateNamingAttributeValues(updateCandidates);
        }
        this.updatePmServiceData();
    }

    private void updatePmServiceData() throws Exception {
        this.traceEnter("updatePmServiceData()");
        Iterator pmServiceIter = this.workingMoData.getMoData(PM_SERVICE_TYPE_NAME).iterator();
        while (pmServiceIter.hasNext()) {
            MoData pmServiceMoData = (MoData)pmServiceIter.next();
            IntegerAttribute maxNoOfCounters = (IntegerAttribute)pmServiceMoData.getAttribute(MAX_NO_OF_COUNTERS);
            IntegerAttribute maxNoOfMonitors = (IntegerAttribute)pmServiceMoData.getAttribute(MAX_NO_OF_MONITORS);
            pmServiceMoData.handleTransaction(this.context, MoData.WRITE_ACCESS);
            maxNoOfCounters.setValue(65000);
            maxNoOfMonitors.setValue(10);
        }
    }

    private List findUpdateCandidates() {
        this.traceEnter("findUpdateCandidates()");
        ArrayList<MoData> result = new ArrayList<MoData>();
        Iterator rfCableIter = this.workingMoData.getMoData(RF_CABLE_TYPE_NAME).iterator();
        while (rfCableIter.hasNext()) {
            MoData rfCableMoData = (MoData)rfCableIter.next();
            String rfCableLdn = rfCableMoData.getLocalDistinguishedName();
            if (!this.isIdAlreadyConverted(rfCableLdn)) {
                if (!this.isRfCableConnectedToARruw(rfCableLdn)) {
                    this.trace("MO: " + rfCableLdn + ", is not connected to a RRUW and therefore no update candidate - no action");
                    continue;
                }
            } else {
                this.trace("MO: " + rfCableLdn + ", is already converted - no action");
                continue;
            }
            result.add(rfCableMoData);
        }
        return result;
    }

    private void updateNamingAttributeValues(List updateCandidates) throws Exception {
        this.traceEnter("updateNamingAttributeValues()");
        TopologyMgr mgr = new TopologyMgr(this.workingMoData);
        Iterator iter = updateCandidates.iterator();
        while (iter.hasNext()) {
            MoData moData = (MoData)iter.next();
            String newLdn = this.generateNewLdn(moData.getLocalDistinguishedName());
            if (newLdn == null) continue;
            mgr.changeLdnTopology(moData, newLdn);
            this.trace("Info: " + moData.getLocalDistinguishedName() + " now has the following LDN : " + newLdn);
        }
        this.trace(mgr.getModificationInfo());
    }

    private String generateNewLdn(String currentLdn) {
        String currentNamingAttributeValue = DC8050598To8050599.getNamingAttributeValue(currentLdn);
        int pos1 = -1;
        int pos2 = -1;
        for (int p1 = 0; p1 < currentNamingAttributeValue.length() && pos1 == -1; ++p1) {
            if (!Character.isDigit(currentNamingAttributeValue.charAt(p1))) continue;
            pos1 = p1;
            for (int p2 = p1; p2 < currentNamingAttributeValue.length() && pos2 == -1; ++p2) {
                if (Character.isDigit(currentNamingAttributeValue.charAt(p2))) continue;
                pos2 = p2;
            }
        }
        this.trace("MO: " + currentLdn + ", pos1 = " + pos1 + ", pos2 = " + pos2);
        if (pos1 == -1 || pos2 == -1) {
            this.trace("MO: " + currentLdn + ", failed to figure out where to insert the two \"_\" - no action");
            return null;
        }
        String newNamingAttributeValue = currentNamingAttributeValue.substring(0, pos1) + '_' + currentNamingAttributeValue.substring(pos1, pos2) + '_' + currentNamingAttributeValue.substring(pos2);
        return DC8050598To8050599.changeNamingAttributeValue(currentLdn, newNamingAttributeValue);
    }

    private boolean isIdAlreadyConverted(String ldn) {
        String id = DC8050598To8050599.getNamingAttributeValue(ldn);
        return id.startsWith(RRUW) && this.countOccurences('_', ldn) == 4;
    }

    private int countOccurences(char c, String s) {
        int count = 0;
        char[] temp = s.toCharArray();
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i] != c) continue;
            ++count;
        }
        return count;
    }

    private boolean isRfCableConnectedToARruw(String ldName) {
        boolean result = false;
        String namingAttributeValue = DC8050598To8050599.getNamingAttributeValue(ldName);
        this.trace(namingAttributeValue);
        if (namingAttributeValue.startsWith(RRUW) && namingAttributeValue.indexOf(95) != -1) {
            String middlePart = namingAttributeValue.substring(4, namingAttributeValue.indexOf(95));
            this.trace(middlePart);
            if (this.inInterval(middlePart, 0, '1', '9') && this.inInterval(middlePart, middlePart.length() - 1, 'A', 'Z')) {
                this.trace(middlePart.substring(1, middlePart.length() - 1));
                int lastDigit = 0;
                int d = lastDigit + 1;
                while (this.inInterval(middlePart, d, '0', '9') && d < middlePart.length() - 1) {
                    lastDigit = d++;
                }
                int firstLetter = middlePart.length() - 1;
                int l = firstLetter - 1;
                while (this.inInterval(middlePart, l, 'A', 'Z') && l > lastDigit) {
                    firstLetter = l--;
                }
                if (lastDigit + 1 == firstLetter) {
                    result = true;
                }
            }
        }
        return result;
    }

    private boolean inInterval(String str, int pos, char min, char max) {
        if (pos > -1 && pos < str.length()) {
            char c = str.charAt(pos);
            return c >= min && c <= max;
        }
        this.trace("The position " + pos + " is not within the string " + str);
        return false;
    }

    private static String getNamingAttributeValue(String ldName) {
        int startPos = ldName.lastIndexOf(VALUE_SEPARATOR);
        return ldName.substring(startPos + 1);
    }

    private static String changeNamingAttributeValue(String currentLdName, String newNamingAttributeValue) {
        int endPos = currentLdName.lastIndexOf(VALUE_SEPARATOR);
        return currentLdName.substring(0, endPos + 1) + newNamingAttributeValue;
    }
}

