/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class CheckSectorAntennaHasFroIdOp
implements Command {
    private static final String SECTOR_ANTENNA_TYPE_NAME = "SectorAntenna";
    private static final String FRO_ID = "froId";
    private final WorkingMoData workingMoData;
    private final Coordinator context;

    public CheckSectorAntennaHasFroIdOp(WorkingMoData workingMoData, Coordinator context) {
        this.workingMoData = workingMoData;
        this.context = context;
    }

    public void execute() throws Exception {
        Collection mos = this.workingMoData.getMoData(SECTOR_ANTENNA_TYPE_NAME);
        Iterator it = mos.iterator();
        while (it.hasNext()) {
            MoData moData = (MoData)it.next();
            Attribute attr = moData.getAttribute(FRO_ID);
            if (attr == null) {
                throw new Exception("SectorAntenna MO does not have required attribute named 'froId'");
            }
            if (!(attr instanceof IntegerAttribute)) {
                throw new Exception("SectorAntenna MO, FroId attribute is of wrong type");
            }
            IntegerAttribute intAttr = (IntegerAttribute)attr;
            if (intAttr.getValue(this.context) != 0) continue;
            throw new Exception("SectorAntenna MO, FroId attribute must be nonzero");
        }
    }
}

