/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.RecoveryHandler;

public class CreateDeviceOp
implements Command {
    private static final Class SELF = CreateDeviceOp.class;
    private static final int DEF_INT_VALUE = 0;
    private static final String ALARM_STATUS = "alarmStatus";
    private static final String USER_LABEL = "userLabel";
    private final String froIdAttrName;
    private final String deviceName;
    private final String deviceSetName;
    private final String deviceGroupName;
    private final String genericDeviceGroupName;
    private final int moDataRevision;
    private final int targetCardinality;
    private final Coordinator context;
    private final WorkingMoData workingMoData;
    private final boolean legacy;

    public CreateDeviceOp(WorkingMoData workingMoData, Coordinator context, String deviceName, String deviceSetName, String deviceGroupName, int moDataRevision, int targetCardinality, boolean legacy) throws MoAccessException {
        this.workingMoData = workingMoData;
        this.context = context;
        this.deviceName = deviceName;
        if (deviceSetName == null) {
            throw new IllegalArgumentException("parent name must not be null");
        }
        if (deviceSetName.equals("")) {
            throw new IllegalArgumentException("parent name must not be an empty string");
        }
        this.deviceSetName = deviceSetName;
        if (deviceGroupName != null && deviceGroupName.equals("")) {
            throw new IllegalArgumentException("grandparent name must not be empty string");
        }
        this.deviceGroupName = deviceGroupName;
        this.genericDeviceGroupName = null;
        this.moDataRevision = moDataRevision;
        this.targetCardinality = targetCardinality;
        this.froIdAttrName = MoDataHelper.getFroIdAttrName(deviceName);
        this.legacy = legacy;
    }

    public CreateDeviceOp(WorkingMoData workingMoData, Coordinator context, String deviceName, String deviceSetName, String grandparentName, String genericDeviceGroupName, int moDataRevision, int targetCardinality) throws MoAccessException {
        this.workingMoData = workingMoData;
        this.context = context;
        this.deviceName = deviceName;
        if (deviceSetName == null) {
            throw new IllegalArgumentException("parent name must not be null");
        }
        if (deviceSetName.equals("")) {
            throw new IllegalArgumentException("parent name must not be an empty string");
        }
        this.deviceSetName = deviceSetName;
        if (!"DeviceGroup".equals(grandparentName)) {
            throw new IllegalArgumentException("grandparent name must be 'DeviceGroup'");
        }
        this.deviceGroupName = "DeviceGroup";
        this.genericDeviceGroupName = genericDeviceGroupName;
        this.moDataRevision = moDataRevision;
        this.targetCardinality = targetCardinality;
        this.froIdAttrName = MoDataHelper.getFroIdAttrName(deviceName);
        this.legacy = false;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"execute()");
        this.validate();
        if (this.deviceGroupName != null) {
            this.checkAndCreateGrandparentMatters();
        } else {
            this.checkAndCreateNoGrandparent();
        }
    }

    private void validate() throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"validate()");
        if (this.deviceGroupName != null) {
            MessageLog.traceEnter((Class)SELF, (String)("check " + this.deviceName + " under " + this.deviceSetName + " under " + this.deviceGroupName));
        } else {
            MessageLog.traceEnter((Class)SELF, (String)("check " + this.deviceName + " under " + this.deviceSetName));
        }
        Collection mos = this.workingMoData.getMoData(this.deviceName);
        MessageLog.trace((int)9, (Class)SELF, (String)(this.deviceName + " found " + mos.size() + " MOs in Working Data. "));
        Object[] moList = mos.toArray();
        for (int i = 0; i < moList.length; ++i) {
            MoData tmpMoData = (MoData)moList[i];
            String moLdn = tmpMoData.getLocalDistinguishedName();
            if (moLdn.indexOf(this.deviceSetName) == -1 || this.deviceGroupName != null && moLdn.indexOf(this.deviceGroupName) == -1) continue;
            this.validateSetMoData(tmpMoData);
        }
    }

    private void validateSetMoData(MoData deviceMoData) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)("validateSetMoData(), Mo:" + deviceMoData.getLocalDistinguishedName()));
        IntegerAttribute froIdAttr = (IntegerAttribute)deviceMoData.getAttribute(this.froIdAttrName);
        if (froIdAttr == null || froIdAttr.getValue(this.context) < 1) {
            MessageLog.trace((int)9, (Class)SELF, (String)(" Target mo is not created correctly, the attribute '" + this.froIdAttrName + "'  doesn't exist or has value < 1. This object will be deleted from the MoData list." + deviceMoData.getLocalDistinguishedName()));
            deviceMoData.handleTransaction(this.context, MoData.WRITE_ACCESS);
            deviceMoData.delete(this.context);
            this.workingMoData.deleteMoData(deviceMoData);
        }
    }

    private void checkAndCreateGrandparentMatters() throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)("checkAndCreateGrandparentMatters()" + this.deviceName));
        if (this.genericDeviceGroupName != null && !this.deviceGroupName.equals("DeviceGroup")) {
            MessageLog.traceError((Class)SELF, (String)("expected: DeviceGroup, actual: " + this.deviceGroupName));
            throw new SoftwareErrorException();
        }
        Iterator dgIt = this.workingMoData.getMoData(this.deviceGroupName).iterator();
        while (dgIt.hasNext()) {
            MoData deviceGroupMoData = (MoData)dgIt.next();
            String deviceGroupLdn = deviceGroupMoData.getLocalDistinguishedName();
            if (this.genericDeviceGroupName != null && !LDNHelper.getNamingAttributeValue(deviceGroupLdn).equals(this.genericDeviceGroupName)) continue;
            MoDataHelper.activateWriteAccess(this.context, deviceGroupMoData);
            Iterator dsIt = FindMo.getChildren(this.deviceSetName, deviceGroupLdn, this.workingMoData).iterator();
            while (dsIt.hasNext()) {
                MoData deviceSetMoData = (MoData)dsIt.next();
                String deviceSetLdn = deviceSetMoData.getLocalDistinguishedName();
                int nDevices = FindMo.getChildren(this.deviceName, deviceSetLdn, this.workingMoData).size();
                if (nDevices > this.targetCardinality) {
                    throw new MoDataConversionException("The cardinality is wrong!! " + this.deviceSetName + ": " + deviceSetLdn + ", No of children: " + nDevices);
                }
                if (nDevices == this.targetCardinality) {
                    MessageLog.trace((int)9, (Class)SELF, (String)(" Required target device(s) already exist under " + this.deviceSetName + ": " + deviceSetLdn));
                    continue;
                }
                MoDataHelper.activateWriteAccess(this.context, deviceSetMoData);
                this.createAddToMoDataList(deviceSetLdn, this.targetCardinality - nDevices);
            }
        }
    }

    private void checkAndCreateNoGrandparent() throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)("checkAndCreateNoGrandparent()" + this.deviceName));
        Collection mos = this.workingMoData.getMoData(this.deviceSetName);
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, (Class)SELF, (String)(this.deviceSetName + " MO not found in Working Data. " + this.deviceName + " not needed."));
            return;
        }
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            MoDataHelper.activateWriteAccess(this.context, tmpMoData);
            String txgMoLdn = tmpMoData.getLocalDistinguishedName();
            int nTargetMos = FindMo.getChildren(this.deviceName, txgMoLdn, this.workingMoData).size();
            if (nTargetMos > this.targetCardinality) {
                throw new MoDataConversionException("The cardinality is wrong!! " + this.deviceSetName + ": " + txgMoLdn + ", No of children: " + nTargetMos);
            }
            if (nTargetMos < this.targetCardinality) {
                this.createAddToMoDataList(txgMoLdn, this.targetCardinality - nTargetMos);
                continue;
            }
            MessageLog.trace((int)9, (Class)SELF, (String)(" Exist already  Target Device under " + this.deviceSetName + ": " + txgMoLdn));
        }
    }

    private void createAddToMoDataList(String deviceSetLdn, int nDevicesToCreate) throws Exception {
        String msg;
        MessageLog.traceEnter((Class)SELF, (String)("createAddToMoDataList()" + this.deviceName));
        MoData myMoData = null;
        int nCreated = 0;
        Vector cMoDataList = RecoveryHandler.getCollectedMoData();
        if (cMoDataList != null && cMoDataList.toArray() != null) {
            Object[] collectedData = cMoDataList.toArray();
            for (int i = 0; i < collectedData.length; ++i) {
                CMoData cMoData = (CMoData)collectedData[i];
                if (!LDNHelper.getParentLdn(cMoData.getLocalDistinguishedName(), cMoData.getMoTypeName()).equals(deviceSetLdn) || !cMoData.getMoTypeName().equals(this.deviceName)) continue;
                myMoData = this.createMoData(cMoData, this.context);
                cMoData.handleTransaction(this.context, CMoData.WRITE_ACCESS);
                cMoData.delete(this.context);
                this.workingMoData.addMoData(myMoData);
                if (++nCreated == nDevicesToCreate) break;
            }
        }
        if (this.legacy && nCreated == 0) {
            msg = "No CMoData instances found for " + deviceSetLdn;
            MessageLog.traceError((Class)SELF, (String)msg);
            throw new MoDataConversionException(msg);
        }
        if (!this.legacy && nCreated != nDevicesToCreate) {
            msg = "Wrong number of CMoData instances for " + deviceSetLdn + ": expected: " + nDevicesToCreate + ", actually found: " + nCreated;
            MessageLog.traceError((Class)SELF, (String)msg);
            throw new MoDataConversionException(msg);
        }
    }

    private MoData createMoData(CMoData cMoData, Coordinator context) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)("Creating new MO " + this.deviceName + " with LDN: " + cMoData.getLocalDistinguishedName()));
        MoData moData = new MoData(cMoData.getLocalDistinguishedName(), cMoData.getMoTypeName(), true, context);
        se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute froId = (se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute)cMoData.getAttribute(this.froIdAttrName);
        if (froId == null) {
            throw new MoDataConversionException("The attribute '" + this.froIdAttrName + "' not found in the collected cMoData. Mo: " + cMoData.getLocalDistinguishedName());
        }
        MoDataHelper.registerStringAttr(moData, null, USER_LABEL, false, "");
        MoDataHelper.registerIntegerAttr(moData, null, this.froIdAttrName, false, froId.getValue(context));
        MoDataHelper.registerIntegerAttr(moData, null, ALARM_STATUS, false, 0);
        moData.setRevision(this.moDataRevision);
        this.registerExtraAttributes(cMoData, context);
        moData.handleTransaction(context, MoData.WRITE_ACCESS);
        return moData;
    }

    public void registerExtraAttributes(CMoData cMoData, Coordinator context) {
    }
}

