/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.frodataconv;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.frodataconv.ApcFroAttributes;
import se.ericsson.wcdma.rbs.boam.frodataconv.ColumnData;
import se.ericsson.wcdma.rbs.boam.frodataconv.CommonSupportSystemFroDataConverter;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySystemMo;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;

public class PowerDistributionFroDataConverter
extends CommonSupportSystemFroDataConverter {
    private static final PowerDistributionFroDataConverter INSTANCE = new PowerDistributionFroDataConverter();
    private final ColumnData[] columnData = new ColumnData[]{new ColumnData("ldn", DatabaseMgr.getSql().varcharType(100)), new ColumnData("mainLoadUndervoltageDisconnect", "INTEGER"), new ColumnData("priorityLoadUndervoltageDisconnect", "INTEGER"), new ColumnData("undervoltageDisconnectCeaseOffset", "INTEGER")};

    protected PowerDistributionFroDataConverter() {
        super("PowerDistributionFroDataConverter");
    }

    public static CommonSupportSystemFroDataConverter instance() {
        return INSTANCE;
    }

    protected ColumnData[] getColumnData() {
        return this.columnData;
    }

    protected String getTypeName() {
        return "PowerSupplySystem";
    }

    protected Object[] getTableData(ManagedObject nextMo, Coordinator c) throws MoAccessException {
        PowerSupplySystemMo pss = (PowerSupplySystemMo)nextMo;
        String ldn = "ManagedElement=1,EquipmentSupportFunction=1,PowerDistribution=" + pss.getNamingAttributeValue();
        return new Object[]{new Integer(this.nextFroId()), ldn, new Integer(pss.getMainLoadUndervoltageDisconnect(c)), new Integer(pss.getPriorityLoadUndervoltageDisconnect(c)), new Integer(pss.getUndervoltageDisconnectCeaseOffset(c))};
    }

    protected void createNewMoData(MoData ignored, String ldn, int froId, Coordinator c) throws MoAccessException {
        MoData newModata = new MoData(ldn, this.getNewTypeName(), true, c);
        newModata.handleTransaction(c, MoData.WRITE_ACCESS);
        newModata.registerPersistentAttr((Attribute)new StringAttribute("userLabel", false, ""));
        newModata.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, froId));
        newModata.setRevision(8010001);
    }

    protected ApcFroAttributes[] getApcFroAttributesData() {
        int froType = this.getFroType();
        return new ApcFroAttributes[]{new ApcFroAttributes(froType, "mainLoadUndervoltageDisconnect", "S32"), new ApcFroAttributes(froType, "priorityLoadUndervoltageDisconnect", "S32"), new ApcFroAttributes(froType, "undervoltageDisconnectCeaseOffset", "S32")};
    }

    protected String getNewTypeName() {
        return "PowerDistribution";
    }
}

