/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.common;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public abstract class ReserveMoHelper {
    private static final Class SELF = ReserveMoHelper.class;
    public static final String BOAM_RESERVED_BY = "persistentReservers";
    public static final String CELLO_RESERVED_BY = "reservedBy";
    public static final String CELLO_RESERVED_BY_UC = "ReservedBy";
    public static final String CELLO_RESERVED_BY_PIU = "reservedByList";

    public static void substituteReserver(WorkingMoData workingMoData, ReferenceAttribute reservedObjectRef, String oldReserverLdn, String newReserverLdn, Coordinator context) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"substituteReserver()");
        if (workingMoData == null || reservedObjectRef == null || reservedObjectRef.getReferenceAsLDN() == null || oldReserverLdn == null || oldReserverLdn.equals("") || newReserverLdn == null || newReserverLdn.equals("")) {
            MessageLog.trace((int)9, (Class)SELF, (String)" substituteReserver(), Some input parameter is not valid");
            return;
        }
        MoData reservedMoData = null;
        Collection mos = workingMoData.getMoData(LDNHelper.getMoTypeName(reservedObjectRef.getReferenceAsLDN()));
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            if (!tmpMoData.getLocalDistinguishedName().equals(reservedObjectRef.getReferenceAsLDN())) continue;
            reservedMoData = tmpMoData;
            break;
        }
        if (reservedMoData == null) {
            throw new Exception("substituteReserver(), The Node configuration is corrupt!! The reserved MO not found!! Reserved MO: " + reservedObjectRef.getReferenceAsLDN() + " the oldReserverLdn: " + oldReserverLdn + " the newReserverLdn: " + newReserverLdn);
        }
        ReserveMoHelper.substituteReserver(reservedMoData, oldReserverLdn, newReserverLdn, context);
    }

    public static void substituteReserver(MoData mo, String oldReserverLdn, String newReserverLdn, Coordinator context) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"substituteReserver()");
        if (mo == null || oldReserverLdn == null || oldReserverLdn.equals("") || newReserverLdn == null || newReserverLdn.equals("")) {
            MessageLog.trace((int)9, (Class)SELF, (String)" substituteReserver(), Some input parameter is not valid");
            return;
        }
        MoDataHelper.activateWriteAccess(context, mo);
        if (ReserveMoHelper.release(mo, oldReserverLdn, context)) {
            ReserveMoHelper.reserve(mo, newReserverLdn, context);
        } else {
            MessageLog.info((Class)SELF, (String)("The reservation can't be dune. The reserve/release is not implemented correctly!! The oldReserverLdn:" + oldReserverLdn + ",  has reference to the reserved MO: " + mo.getLocalDistinguishedName() + ", but the reserved MO has no reference in his reservedBy attribute to the reserver!! "));
        }
    }

    public static void updateReserversAtResevedLdnChanged(WorkingMoData workingMoData, String reserverLdn, String oldReservedLDN, String newReservedLDN, Coordinator context) throws Exception {
        MoData reserverMo = null;
        MessageLog.traceEnter((Class)SELF, (String)"updateReserversAtResevedLdnChanged()");
        if (workingMoData == null || reserverLdn == null || oldReservedLDN == null || newReservedLDN == null) {
            MessageLog.trace((int)9, (Class)SELF, (String)" release(), Some input parameter is not valid");
            return;
        }
        Collection mos = workingMoData.getMoData(LDNHelper.getMoTypeName(reserverLdn));
        if (mos.isEmpty()) {
            MessageLog.traceError((Class)SELF, (String)("updateReserversAtResevedLdnChanged(), The Node configuration is corrupt!! The reserver MO not found!! reserverLdn: " + reserverLdn));
            throw new Exception("updateReserversAtResevedLdnChanged(), The Node configuration is corrupt!! The reserver MO not found!! reserverLdn: " + reserverLdn);
        }
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            if (!tmpMoData.getLocalDistinguishedName().equals(reserverLdn)) continue;
            reserverMo = tmpMoData;
            break;
        }
        if (reserverMo == null) {
            MessageLog.traceError((Class)SELF, (String)("updateReserversAtResevedLdnChanged(), The Node configuration is corrupt!! The reserver MO not found!! reserverLdn: " + reserverLdn));
            throw new Exception("updateReserversAtResevedLdnChanged(), The Node configuration is corrupt!! The reserver MO not found!! reserverLdn: " + reserverLdn);
        }
        MoDataHelper.activateWriteAccess(context, reserverMo);
        Enumeration attrList = reserverMo.getAllPersistentAttributes();
        boolean isUpdated = false;
        while (attrList.hasMoreElements()) {
            Attribute element = (Attribute)attrList.nextElement();
            if (!(!(element instanceof ReferenceAttribute) || element.getName().equals(BOAM_RESERVED_BY) || element.getName().equals(CELLO_RESERVED_BY_PIU) || element.getName().equals(CELLO_RESERVED_BY) || element.getName().equals(CELLO_RESERVED_BY_UC))) {
                ReferenceAttribute reservedObjectRef = (ReferenceAttribute)element;
                if (reservedObjectRef.getReferenceAsLDN() == null || !reservedObjectRef.getReferenceAsLDN().equals(oldReservedLDN)) continue;
                reserverMo.deregisterAttribute((Attribute)reservedObjectRef);
                ReferenceAttribute newRef = new ReferenceAttribute(reservedObjectRef.getName(), newReservedLDN, false);
                reserverMo.registerPersistentAttr((Attribute)newRef);
                isUpdated = true;
                continue;
            }
            if (!(element instanceof SequenceAttribute) || element.getName().equals(BOAM_RESERVED_BY) || element.getName().equals(CELLO_RESERVED_BY_PIU) || element.getName().equals(CELLO_RESERVED_BY) || element.getName().equals(CELLO_RESERVED_BY_UC)) continue;
            SequenceAttribute reservedObjectRefLis = (SequenceAttribute)element;
            Attribute[] refList = reservedObjectRefLis.getValue(context);
            for (int i = 0; i < refList.length; ++i) {
                ReferenceAttribute ref = (ReferenceAttribute)refList[i];
                if (ref.getReferenceAsLDN() == null || !ref.getReferenceAsLDN().equals(oldReservedLDN)) continue;
                reservedObjectRefLis.removeElement((Attribute)ref);
                ReferenceAttribute newRef = new ReferenceAttribute(ref.getName(), newReservedLDN, false);
                reservedObjectRefLis.addElement((Attribute)newRef);
                isUpdated = true;
            }
        }
        if (!isUpdated) {
            MessageLog.traceError((Class)SELF, (String)("updateReserversAtResevedLdnChanged(), The Node configuration is corrupt!! The reserver MO not found!! reserverLdn: " + reserverLdn));
            throw new Exception("updateReserversAtResevedLdnChanged(), The Node configuration is corrupt!! The reserver MO not found!! reserverLdn: " + reserverLdn);
        }
    }

    public static boolean release(WorkingMoData workingMoData, ReferenceAttribute reservedObjectRef, String reservingLDN, Coordinator context) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"release()");
        if (workingMoData == null || reservedObjectRef == null || reservingLDN == null || reservedObjectRef.getReferenceAsLDN() == null) {
            MessageLog.trace((int)9, (Class)SELF, (String)" release(), Some input parameter is not valid");
            return false;
        }
        Collection mos = workingMoData.getMoData(LDNHelper.getMoTypeName(reservedObjectRef.getReferenceAsLDN()));
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, (Class)SELF, (String)(reservedObjectRef.getReferenceAsLDN() + " MO not found in Working Data."));
            return false;
        }
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            if (!tmpMoData.getLocalDistinguishedName().equals(reservedObjectRef.getReferenceAsLDN())) continue;
            MoDataHelper.activateWriteAccess(context, tmpMoData);
            return ReserveMoHelper.release(tmpMoData, reservingLDN, context);
        }
        return false;
    }

    public static boolean release(MoData reservedMoData, String reserverLDN, Coordinator context) throws Exception {
        if (reserverLDN == null || reservedMoData == null) {
            MessageLog.trace((int)9, (Class)SELF, (String)"release(),The reserver ldn, reserved MoData  is null!!");
            return false;
        }
        MoDataHelper.activateWriteAccess(context, reservedMoData);
        Attribute reservedBy = reservedMoData.getAttribute(CELLO_RESERVED_BY);
        if (reservedBy == null) {
            reservedBy = reservedMoData.getAttribute(CELLO_RESERVED_BY_PIU);
        }
        if (reservedBy == null) {
            reservedBy = reservedMoData.getAttribute(CELLO_RESERVED_BY_UC);
        }
        if (reservedBy == null) {
            reservedBy = reservedMoData.getAttribute(BOAM_RESERVED_BY);
        }
        if (reservedBy == null) {
            return false;
        }
        boolean result = false;
        if (reservedBy instanceof ReferenceAttribute) {
            ReferenceAttribute reservedObjectRef = (ReferenceAttribute)reservedBy;
            if (reservedObjectRef.getReferenceAsLDN() != null && reservedObjectRef.getReferenceAsLDN().equals(reserverLDN)) {
                reservedMoData.deregisterAttribute((Attribute)reservedObjectRef);
                ReferenceAttribute newRef = new ReferenceAttribute(reservedObjectRef.getName(), null, false);
                reservedMoData.registerPersistentAttr((Attribute)newRef);
                result = true;
            }
        } else if (reservedBy instanceof SequenceAttribute) {
            result = ReserveMoHelper.release((SequenceAttribute)reservedBy, reserverLDN, context);
        }
        return result;
    }

    public static boolean release(SequenceAttribute reservedList, String reservingLDN, Coordinator context) throws Exception {
        if (reservedList == null || reservingLDN == null) {
            MessageLog.trace((int)9, (Class)SELF, (String)"release(),The reserver or reserved List is null!!");
            return false;
        }
        ReferenceAttribute refAttr = null;
        Attribute[] refArray = reservedList.getValue(context);
        if (refArray == null || refArray.length == 0) {
            MessageLog.trace((int)9, (Class)SELF, (String)"release(), Couldn't  release MO, the reservedBy list is empty!!");
            return false;
        }
        for (int i = 0; i < refArray.length; ++i) {
            refAttr = (ReferenceAttribute)refArray[i];
            if (refAttr == null || refAttr.getReferenceAsLDN() == null || !refAttr.getReferenceAsLDN().equals(reservingLDN)) continue;
            reservedList.removeElement((Attribute)refAttr);
            return true;
        }
        MessageLog.trace((int)9, (Class)SELF, (String)("release(), Couldn't  release MO, the reserver not found in the reservedBy list !! reservingLDN:" + reservingLDN));
        return false;
    }

    public static boolean reserve(WorkingMoData workingMoData, ReferenceAttribute reservedObjectRef, String reserverLdn, Coordinator context) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"reserve()");
        if (workingMoData == null || reservedObjectRef == null || reservedObjectRef.getReferenceAsLDN() == null || reserverLdn == null || reserverLdn.equals("")) {
            MessageLog.trace((int)9, (Class)SELF, (String)" reserve(), Some input parameter is not valid");
            return false;
        }
        Collection mos = workingMoData.getMoData(LDNHelper.getMoTypeName(reservedObjectRef.getReferenceAsLDN()));
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, (Class)SELF, (String)(reservedObjectRef.getReferenceAsLDN() + " MO not found in Working Data."));
            return false;
        }
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            if (!tmpMoData.getLocalDistinguishedName().equals(reservedObjectRef.getReferenceAsLDN())) continue;
            return ReserveMoHelper.reserve(tmpMoData, reserverLdn, context);
        }
        return false;
    }

    public static boolean reserve(MoData reservedMoData, String reserverLDN, Coordinator context) throws Exception {
        if (reserverLDN == null) {
            MessageLog.trace((int)9, (Class)SELF, (String)"reserve(MoData, String, Coordinator), reserver LDN is null");
            return false;
        }
        if (reservedMoData == null) {
            MessageLog.trace((int)9, (Class)SELF, (String)"reserve(MoData, String, Coordinator), reserved MoData is null");
            return false;
        }
        MoDataHelper.activateWriteAccess(context, reservedMoData);
        Attribute attr = reservedMoData.getAttribute(CELLO_RESERVED_BY);
        if (attr == null) {
            attr = reservedMoData.getAttribute(CELLO_RESERVED_BY_PIU);
        }
        if (attr == null) {
            attr = reservedMoData.getAttribute(CELLO_RESERVED_BY_UC);
        }
        if (attr == null) {
            attr = reservedMoData.getAttribute(BOAM_RESERVED_BY);
        }
        if (attr == null) {
            MoDataHelper.registerSeqAttr(reservedMoData, null, BOAM_RESERVED_BY, false, new Attribute[]{new ReferenceAttribute("", reserverLDN, false)});
            return true;
        }
        if (attr instanceof ReferenceAttribute) {
            ReferenceAttribute refAttr = (ReferenceAttribute)attr;
            if (refAttr.getReferenceAsLDN() != null && !refAttr.getReferenceAsLDN().equals(reserverLDN)) {
                throw new Exception("reserve(), the node configuration is corrupt!!, MO " + reserverLDN + " cannot reserve " + reservedMoData.getLocalDistinguishedName() + ", the MO is already reserved by another object: " + refAttr.getReferenceAsLDN());
            }
            if (refAttr.getReferenceAsLDN() == null) {
                reservedMoData.deregisterAttribute((Attribute)refAttr);
                ReferenceAttribute newRefAttr = new ReferenceAttribute(refAttr.getName(), reserverLDN, false);
                reservedMoData.registerPersistentAttr((Attribute)newRefAttr);
                return true;
            }
        } else if (attr instanceof SequenceAttribute) {
            return ReserveMoHelper.reserve((SequenceAttribute)attr, reserverLDN, context);
        }
        return false;
    }

    public static boolean reserve(SequenceAttribute reservedBy, String reserverLDN, Coordinator context) throws Exception {
        if (reservedBy == null || reserverLDN == null) {
            MessageLog.trace((int)9, (Class)SELF, (String)"reserve(),The reserver or reserved (reservedBy) is null!!");
            return false;
        }
        ReferenceAttribute reserverRef = new ReferenceAttribute("", reserverLDN, false);
        if (ReserveMoHelper.isReservedBy(reservedBy, reserverLDN, context)) {
            MessageLog.trace((int)9, (Class)SELF, (String)("reserve(), the reserver:" + reserverLDN + " is already in the reservedBy list. "));
        } else {
            reservedBy.addElement((Attribute)reserverRef);
        }
        return true;
    }

    public static boolean isReservedBy(SequenceAttribute reservedByAttr, String reserverLdn, Coordinator context) throws Exception {
        if (reservedByAttr == null || reserverLdn == null) {
            return false;
        }
        Enumeration e = reservedByAttr.elements();
        while (e.hasMoreElements()) {
            ReferenceAttribute element = (ReferenceAttribute)e.nextElement();
            if (element == null || element.getReferenceAsLDN() == null || !element.getReferenceAsLDN().equals(reserverLdn)) continue;
            return true;
        }
        return false;
    }
}

