/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.database.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DbAccessException;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Sql;

public class StandardSql
implements Sql {
    public Sql.Select selectAll(String table) {
        return new SelectAll(table);
    }

    public Sql.Select select(String table, String column, String condition) {
        return new Select(table, column, condition);
    }

    public Sql.Update updateEquals(String table, String matchColumn, Object matchValue) {
        return new ConditionalUpdate(table, matchColumn, matchValue);
    }

    public Sql.Delete deleteRow(String table, String matchColumn, Object matchValue) {
        return new Delete(table, matchColumn, matchValue);
    }

    public Sql.Select selectEquals(String table, String selectColumns, String matchColumn, Object matchValue) {
        if (matchValue instanceof String) {
            return this.select(table, selectColumns, matchColumn + "='" + matchValue + "'");
        }
        return this.select(table, selectColumns, matchColumn + "=" + matchValue);
    }

    public Sql.DropTable dropTable(String table) {
        return new DropTable(table);
    }

    public Sql.Insert insert(String table, Object[] values) {
        InsertRow row = new InsertRow(table);
        for (int i = 0; i < values.length; ++i) {
            row.addValue(values[i]);
        }
        return row;
    }

    public Sql.Insert insert(String table) {
        return new InsertRow(table);
    }

    public Sql.CreateTable createTable(String table) {
        return new CreateTable(table);
    }

    public String varcharType(int maxLen) {
        return "VARCHAR(" + maxLen + ")";
    }

    public int defaultVarCharDisplaySize() {
        return 30;
    }

    public String integer16Type() {
        return "SMALLINT";
    }

    public String integer8Type() {
        return "TINYINT";
    }

    private static String object2SqlValue(Object o) {
        if (o instanceof String) {
            return "'" + o + "'";
        }
        return o.toString();
    }

    private static class CreateTable
    implements Sql.CreateTable {
        private LinkedList _columns = new LinkedList();
        private String _tableName;

        public CreateTable(String tableName) {
            this._tableName = tableName;
        }

        public void addColumn(String name, String dataType) {
            this._columns.add(new ColumnSpec(name, dataType, null, false));
        }

        public void addColumn(String name, String dataType, String constraint) {
            this._columns.add(new ColumnSpec(name, dataType, constraint, false));
        }

        public void addPrimaryKey(String primaryKeyName, String primaryKeyDataType) {
            this._columns.add(new ColumnSpec(primaryKeyName, primaryKeyDataType, null, true));
        }

        public void addPrimaryKey(String name, String dataType, String constraint) {
            this._columns.add(new ColumnSpec(name, dataType, constraint, true));
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            ArrayList<String> primaryKeys = new ArrayList<String>();
            buf.append("CREATE TABLE ");
            buf.append(this._tableName);
            buf.append(" (");
            Iterator i = this._columns.iterator();
            while (i.hasNext()) {
                ColumnSpec columnSpec = (ColumnSpec)i.next();
                buf.append(columnSpec._name);
                buf.append(" ");
                buf.append(columnSpec._type);
                if (columnSpec._isPrimaryKey) {
                    primaryKeys.add(columnSpec._name);
                }
                if (columnSpec._constraint != null) {
                    buf.append(" ");
                    buf.append(columnSpec._constraint);
                }
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
            if (!primaryKeys.isEmpty()) {
                buf.append(", ");
                buf.append("primary key (");
                Iterator j = primaryKeys.iterator();
                while (j.hasNext()) {
                    buf.append((String)j.next());
                    if (!j.hasNext()) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append(")");
            return buf.toString();
        }

        private class ColumnSpec {
            final String _name;
            final String _type;
            final String _constraint;
            final boolean _isPrimaryKey;

            public ColumnSpec(String name, String type, String constraint, boolean isPrimaryKey) {
                this._name = name;
                this._type = type;
                this._constraint = constraint;
                this._isPrimaryKey = isPrimaryKey;
            }
        }
    }

    private static class InsertRow
    implements Sql.Insert {
        private String _table;
        private LinkedList _values = new LinkedList();

        public InsertRow(String tableName) {
            this._table = tableName;
        }

        public void addValue(Object value) {
            this._values.add(value);
        }

        public Object getValue(int column) throws DbAccessException {
            return this._values.get(column - 1);
        }

        public String toString() {
            StringBuffer valuesAsStr = new StringBuffer();
            Iterator i = this._values.iterator();
            while (i.hasNext()) {
                Object value = i.next();
                if (i == null) {
                    valuesAsStr.append("NULL");
                } else {
                    valuesAsStr.append(StandardSql.object2SqlValue(value));
                }
                if (!i.hasNext()) continue;
                valuesAsStr.append(",");
            }
            return "INSERT INTO " + this._table + " VALUES (" + valuesAsStr.toString() + ")";
        }
    }

    private static class Delete
    implements Sql.Delete {
        private String _table;
        private String _column;
        private Object _matchValue;

        public Delete(String table, String matchColumn, Object matchValue) {
            this._table = table;
            this._column = matchColumn;
            this._matchValue = matchValue;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("DELETE FROM  ");
            buf.append(this._table);
            buf.append(" WHERE ");
            buf.append(this._column);
            buf.append("=");
            buf.append(StandardSql.object2SqlValue(this._matchValue));
            return buf.toString();
        }
    }

    private static class ConditionalUpdate
    implements Sql.Update {
        private String _table;
        private String _column;
        private Object _matchValue;
        private LinkedList _values = new LinkedList();

        public ConditionalUpdate(String table, String matchColumn, Object matchValue) {
            this._table = table;
            this._column = matchColumn;
            this._matchValue = matchValue;
        }

        public void updateValue(String columnName, Object value) {
            this._values.add(new ColAndVal(columnName, value));
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("UPDATE ");
            buf.append(this._table);
            buf.append(" SET ");
            Iterator i = this._values.iterator();
            while (i.hasNext()) {
                ColAndVal cv = (ColAndVal)i.next();
                buf.append(cv.col());
                buf.append("=");
                buf.append(cv.val());
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(" WHERE ");
            buf.append(this._column);
            buf.append("=");
            buf.append(StandardSql.object2SqlValue(this._matchValue));
            return buf.toString();
        }

        private static class ColAndVal {
            private String _col;
            private Object _val;

            public ColAndVal(String col, Object val) {
                this._col = col;
                this._val = val;
            }

            public String col() {
                return this._col;
            }

            public String val() {
                return StandardSql.object2SqlValue(this._val);
            }
        }
    }

    private static class DropTable
    implements Sql.DropTable {
        private String _table;

        public DropTable(String tableName) {
            this._table = tableName;
        }

        public String toString() {
            return "DROP TABLE " + this._table;
        }
    }

    private static class Select
    implements Sql.Select {
        private String _table;
        private String _columns;
        private String _condition;

        public Select(String table, String columns, String condition) {
            this._table = table;
            this._columns = columns;
            this._condition = condition;
        }

        public String toString() {
            return "SELECT " + this._columns + " FROM " + this._table + " WHERE " + this._condition;
        }
    }

    private static class SelectAll
    implements Sql.Select {
        private String _table;

        public SelectAll(String table) {
            this._table = table;
        }

        public String toString() {
            return "SELECT * FROM " + this._table;
        }
    }
}

