/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.cvhelper;

import java.util.TimerTask;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.pnp.cvhelper.CvHelper;
import se.ericsson.crbs.omf.mao.pnp.cvhelper.CvHelperFactory;
import se.ericsson.crbs.omf.mao.pnp.cvhelper.CvTimer;
import se.ericsson.crbs.omf.mao.pnp.proxy.PnpContext;

public final class CvCreator {
    private static final int DEFAULT_TIME_TO_WAIT_IMMEDIATE = 120000;
    private static final Class THIS_CLASS = CvCreator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int DEFAULT_TIME_TO_WAIT_DELAYED = 1800000;
    static final Object MUTEX_OBJECT = new Object();
    static boolean isCvWaitingToBeWrittenDelay = false;
    static boolean isCvWaitingToBeWrittenImmediate = false;
    static final String TIME_WAITING_PROPERTY = "mao.pnp.delayedcv.time.to.wait";
    private static final long TIME_TO_WAIT_DELAYED;
    private static final long TIME_TO_WAIT_IMMEDIATE;
    private static CvTimer currentTimer;

    private CvCreator() {
    }

    public static void createCv(PnpContext pnpContext, int createCvOption) {
        logger.traceEnter(THIS_CLASS, "createCv()");
        if (createCvOption == 2) {
            if (!isCvWaitingToBeWrittenImmediate) {
                isCvWaitingToBeWrittenImmediate = true;
                CvCreator.startCvTimer(pnpContext, TIME_TO_WAIT_IMMEDIATE);
            } else {
                logger.traceGeneral(THIS_CLASS, "Immediate timer already started.");
            }
        } else if (createCvOption == 1) {
            if (!isCvWaitingToBeWrittenDelay && !isCvWaitingToBeWrittenImmediate) {
                logger.info(THIS_CLASS, "No timer is scheduled. Timer will be started and executed in [" + TIME_TO_WAIT_DELAYED / 60000L + "] minutes");
                isCvWaitingToBeWrittenDelay = true;
                CvCreator.startCvTimer(pnpContext, TIME_TO_WAIT_DELAYED);
            } else {
                logger.traceGeneral(THIS_CLASS, "Delayed or immediate timer already started.");
            }
        }
        if (CvCreator.inValidCreateCvOption(createCvOption)) {
            logger.traceError(THIS_CLASS, "Unexpected Create CV option: " + createCvOption + " No CV created.");
        }
        logger.traceReturn(THIS_CLASS, "createCv()");
    }

    private static boolean inValidCreateCvOption(int createCvOption) {
        return createCvOption != 1 && createCvOption != 2 && createCvOption != 0;
    }

    private static void startCvTimer(final PnpContext pnpContext, long timeToWait) {
        logger.traceEnter(THIS_CLASS, "startCvTimer()");
        TimerTask taskPerformer = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CvCreator.createCv(pnpContext);
                Object object = MUTEX_OBJECT;
                synchronized (object) {
                    MUTEX_OBJECT.notifyAll();
                }
            }
        };
        if (currentTimer == null) {
            currentTimer = new CvTimer();
        } else {
            currentTimer.cancelIfActive();
        }
        currentTimer.scheduleTask(timeToWait, taskPerformer);
        logger.traceReturn(THIS_CLASS, "startCvTimer()");
    }

    private static void createCv(PnpContext pnpContext) {
        isCvWaitingToBeWrittenDelay = false;
        isCvWaitingToBeWrittenImmediate = false;
        currentTimer = null;
        try {
            logger.info(THIS_CLASS, "Calling createCv in CvHelper");
            CvHelper cvHelper = CvHelperFactory.getCvHelper(pnpContext);
            cvHelper.createCv();
        }
        catch (MoAccessException e) {
            logger.info(THIS_CLASS, "Got exception when trying to store new CV. Exception: " + e.toString());
        }
    }

    static {
        long localTimeToWaitDelayed = 1800000L;
        long localTimeToWaitImmediate = 120000L;
        String unitTestStr = System.getProperty("UNIT_TEST", "");
        if (!unitTestStr.equalsIgnoreCase("")) {
            localTimeToWaitDelayed = 500L;
            localTimeToWaitImmediate = 100L;
        }
        TIME_TO_WAIT_DELAYED = localTimeToWaitDelayed;
        TIME_TO_WAIT_IMMEDIATE = localTimeToWaitImmediate;
    }
}

