/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.request;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import se.ericsson.cello.configirpimpl.NoSuchActionException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.mao.pnp.proxy.PnpContext;
import se.ericsson.crbs.omf.mao.pnp.request.AbstractPnpSubRequest;

public class PnpActionRequest
extends AbstractPnpSubRequest {
    private String actionName = "";
    private final List attributeTypesList = new ArrayList();
    private final Map classesMap = new HashMap();

    public PnpActionRequest(PnpContext inputPnpContext) {
        super(PnpActionRequest.class, inputPnpContext);
        this.classesMap.put("string".toLowerCase(Locale.getDefault()), String.class);
        this.classesMap.put("s32".toLowerCase(Locale.getDefault()), Integer.TYPE);
        this.classesMap.put("s64".toLowerCase(Locale.getDefault()), Long.TYPE);
        this.classesMap.put("boolean".toLowerCase(Locale.getDefault()), Boolean.TYPE);
        this.classesMap.put("struct".toLowerCase(Locale.getDefault()), Struct.class);
        this.classesMap.put("moref".toLowerCase(Locale.getDefault()), ManagedObject.class);
    }

    public String getRequestType() {
        return "action";
    }

    public void setAttributeTypes(List inputAttributeTypesList) {
        this.attributeTypesList.clear();
        this.attributeTypesList.addAll(inputAttributeTypesList);
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(this.loggingClass, "execute " + this.getRequestType() + " - " + this.getLdn());
        ManagedObject actionMo = this.getMo(this.getLdn());
        this.checkActionName(actionMo.getType());
        Class[] javaClasses = this.convertToJavaClasses(actionMo.getType(), this.attributeList.getAttrValues(), this.attributeTypesList);
        Object[] parametersArray = this.getParametersArray(this.attributeList.getAttrValues(), javaClasses, coordinator);
        this.executeResultName = "ChangeThis";
        try {
            Method method = actionMo.getClass().getMethod(this.actionName, javaClasses);
            this.executeResult = method.invoke((Object)actionMo, parametersArray);
        }
        catch (Exception e) {
            this.handleException(this.actionName, actionMo, javaClasses, parametersArray);
        }
        logger.traceReturn(this.loggingClass, "execute");
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String inputActionName) {
        this.actionName = inputActionName;
    }

    private void checkActionName(String moType) throws NoSuchActionException {
        if (!this.actionName.startsWith("action")) {
            throw new NoSuchActionException("Specified action must always start with \"action\"", moType);
        }
    }

    private void handleException(String localActionName, ManagedObject actionMo, Class[] javaClasses, Object[] parametersArray) throws NoSuchActionException {
        int i;
        StringBuffer errorMsg = new StringBuffer(500);
        errorMsg.append("No action with name \"").append(localActionName).append("\" available with parameters:\n");
        for (i = 0; i < parametersArray.length; ++i) {
            errorMsg.append('\t').append(parametersArray[i].toString()).append('\n');
        }
        errorMsg.append("and parameter types:\n");
        for (i = 0; i < javaClasses.length; ++i) {
            errorMsg.append('\t').append(javaClasses[i].getName());
            if (i >= javaClasses.length - 1) continue;
            errorMsg.append('\n');
        }
        throw new NoSuchActionException(errorMsg.toString(), actionMo.getType());
    }

    private Class[] convertToJavaClasses(String moType, List localAttributeValuesList, List localAttributeTypesList) throws NoSuchAttributeException {
        logger.traceEnter(this.loggingClass, "convertToJavaClasses()");
        Class[] javaClasses = new Class[localAttributeTypesList.size() + 1];
        for (int i = 0; i < localAttributeTypesList.size(); ++i) {
            String xmlType = (String)localAttributeTypesList.get(i);
            if ("array".equalsIgnoreCase(xmlType)) {
                javaClasses[i] = this.getArrayClass(localAttributeValuesList.get(i));
                continue;
            }
            if (this.isSupportedXmlType(xmlType)) {
                javaClasses[i] = (Class)this.classesMap.get(xmlType.toLowerCase(Locale.getDefault()));
                continue;
            }
            throw new NoSuchAttributeException("Unrecognized XML attribute type, \"" + xmlType + "\"", moType);
        }
        javaClasses[javaClasses.length - 1] = Coordinator.class;
        logger.traceReturn(this.loggingClass, "convertToJavaClasses()");
        return javaClasses;
    }

    private boolean isSupportedXmlType(String xmlType) {
        boolean stringType = "string".equalsIgnoreCase(xmlType);
        boolean integerType = "s32".equalsIgnoreCase(xmlType);
        boolean longType = "s64".equalsIgnoreCase(xmlType);
        boolean booleanType = "boolean".equalsIgnoreCase(xmlType);
        boolean structType = "struct".equalsIgnoreCase(xmlType);
        boolean moRefType = "moref".equalsIgnoreCase(xmlType);
        return stringType || integerType || longType || booleanType || structType || moRefType;
    }

    private Class getArrayClass(Object object) {
        Class result = object.getClass();
        if (object instanceof Boolean[]) {
            result = [Z.class;
        } else if (object instanceof Integer[]) {
            result = [I.class;
        } else if (object instanceof Long[]) {
            result = [J.class;
        }
        return result;
    }

    private Object[] getParametersArray(List localAttributeValuesList, Class[] javaClasses, Coordinator coordinator) {
        logger.traceEnter(this.loggingClass, "getParametersArray()");
        Object[] parametersArray = new Object[localAttributeValuesList.size() + 1];
        localAttributeValuesList.toArray(parametersArray);
        parametersArray[parametersArray.length - 1] = coordinator;
        logger.traceReturn(this.loggingClass, "getParametersArray()");
        return this.convertToPrimitivesArray(parametersArray);
    }

    private Object[] convertToPrimitivesArray(Object[] parametersArray) {
        Object[] result = new Object[parametersArray.length];
        for (int i = 0; i < parametersArray.length; ++i) {
            result[i] = parametersArray[i] instanceof Boolean[] ? this.getPrimitiveBooleanArray(parametersArray[i]) : (parametersArray[i] instanceof Integer[] ? (Object)this.getPrimitiveIntegerArray(parametersArray[i]) : (parametersArray[i] instanceof Long[] ? this.getPrimitiveLongArray(parametersArray[i]) : parametersArray[i]));
        }
        return result;
    }

    private Object getPrimitiveLongArray(Object parametersArray) {
        Long[] objectArray = (Long[])parametersArray;
        long[] primitiveArray = new long[objectArray.length];
        for (int j = 0; j < primitiveArray.length; ++j) {
            primitiveArray[j] = objectArray[j];
        }
        return primitiveArray;
    }

    private Object getPrimitiveBooleanArray(Object parametersArray) {
        Boolean[] objectArray = (Boolean[])parametersArray;
        boolean[] primitiveArray = new boolean[objectArray.length];
        for (int j = 0; j < primitiveArray.length; ++j) {
            primitiveArray[j] = objectArray[j];
        }
        return primitiveArray;
    }

    private int[] getPrimitiveIntegerArray(Object parametersArray) {
        Integer[] objectArray = (Integer[])parametersArray;
        int[] primitiveArray = new int[objectArray.length];
        for (int j = 0; j < primitiveArray.length; ++j) {
            primitiveArray[j] = objectArray[j];
        }
        return primitiveArray;
    }
}

