/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.session;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.session.MaoFroAttributeStruct;
import se.ericsson.cello.session.MaoFroFormatConvert;
import se.ericsson.cello.support.debug.MessageLog;

public class MaoFroInitiateServiceCfm
extends UnlinkedSignal {
    private int signalRevision;
    private int result;
    private int nValues;
    private MaoFroAttributeStruct[] attributes;
    private static final int SIGNO = 720930;

    public MaoFroInitiateServiceCfm() {
        super(720930);
    }

    public MaoFroInitiateServiceCfm(int n, int n2, int n3, MaoFroAttributeStruct[] maoFroAttributeStructArray) {
        super(720930);
        this.signalRevision = n;
        this.result = n2;
        this.nValues = n3;
        this.attributes = maoFroAttributeStructArray;
    }

    public int getResult() {
        return this.result;
    }

    public int getSignalRevision() {
        return this.signalRevision;
    }

    public int getNumberOfValues() {
        return this.nValues;
    }

    public void initSend() {
        SignalOutputStream signalOutputStream = this.getSignalOutputStream();
        try {
            signalOutputStream.writeU32((long)this.signalRevision);
            MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing signalRevision: " + this.signalRevision));
            signalOutputStream.writeU32((long)this.result);
            MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing result: " + this.result));
            int n = this.nValues;
            signalOutputStream.writeU32((long)n);
            MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing nAttr: " + n));
            for (int i = 0; i < n; ++i) {
                signalOutputStream.writeU32((long)this.attributes[i].attribute);
                MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing attribute tag: " + this.attributes[i].attribute));
                signalOutputStream.writeU16(this.attributes[i].type);
                MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing attr type: " + this.attributes[i].type));
                signalOutputStream.writeU16(this.attributes[i].state);
                MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing dummy attr state: " + this.attributes[i].state));
                signalOutputStream.writeU32((long)this.attributes[i].value);
                MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)("Writing value: " + this.attributes[i].value));
                if (this.attributes[i].type != 1) continue;
                int[] nArray = MaoFroFormatConvert.string2intArray(this.attributes[i].stringValue, this.attributes[i].value);
                signalOutputStream.writeU8Array(nArray);
                MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)"Writing string value ");
            }
            signalOutputStream.flush();
        }
        catch (IOException iOException) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)"Not able to write signal to stream", (Throwable)iOException);
        }
    }

    public MaoFroAttributeStruct[] getAttributes() {
        return this.attributes;
    }

    public void initReceive() {
        SignalInputStream signalInputStream = this.getSignalInputStream();
        try {
            this.signalRevision = (int)signalInputStream.readU32();
            this.result = (int)signalInputStream.readU32();
            this.nValues = (int)signalInputStream.readU32();
            this.attributes = new MaoFroAttributeStruct[this.nValues];
            for (int i = 0; i < this.nValues; ++i) {
                MaoFroAttributeStruct maoFroAttributeStruct = new MaoFroAttributeStruct();
                maoFroAttributeStruct.attribute = (int)signalInputStream.readU32();
                maoFroAttributeStruct.type = signalInputStream.readU16();
                maoFroAttributeStruct.state = signalInputStream.readU16();
                maoFroAttributeStruct.value = (int)signalInputStream.readU32();
                if (maoFroAttributeStruct.type == 1) {
                    int[] nArray = signalInputStream.readU8Array(maoFroAttributeStruct.value);
                    maoFroAttributeStruct.stringValue = MaoFroFormatConvert.intArray2String(nArray);
                }
                this.attributes[i] = maoFroAttributeStruct;
                MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)(" attribute: " + this.attributes[i].attribute));
                MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)(" type: " + this.attributes[i].type));
                MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)(" state: " + this.attributes[i].state));
                MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)(" value: " + this.attributes[i].value));
                MessageLog.trace((int)4, ((Object)((Object)this)).getClass(), (String)(" stringValue: " + this.attributes[i].stringValue));
            }
        }
        catch (IOException iOException) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)"Not able to read signal from stream", (Throwable)iOException);
        }
    }
}

