/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.licensing.LicensingLogger;
import se.ericsson.cello.licensing.model.LicenseAttributeRecord;
import se.ericsson.cello.licensing.model.LicenseType;
import se.ericsson.cello.licensing.model.LicensingNameValue;
import se.ericsson.cello.licensing.model.RecordExtractor;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.neal.cm.DnAttributes;
import se.ericsson.cello.neal.cm.DnNameValues;
import se.ericsson.cello.neal.cm.Mo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordCollector {
    private NodeServices myNodeServices;
    private LicenseType myCollectorType;
    Hashtable<String, ArrayList<String>> licenseAttributesTable;
    Hashtable<String, ArrayList<String>> featureAttributesTable;
    Hashtable<String, ArrayList<String>> capacityAttributesTable;

    public RecordCollector(NodeServices nodeServices, LicenseType collectorType) {
        this.myNodeServices = nodeServices;
        this.myCollectorType = collectorType;
    }

    public List<LicenseAttributeRecord> collectLicenseRecords() {
        ArrayList<LicenseAttributeRecord> records = new ArrayList<LicenseAttributeRecord>(20);
        this.resolveLicenseAttributes();
        Hashtable<String, ArrayList<String>> licTable = this.myCollectorType == LicenseType.FEATURE ? this.featureAttributesTable : this.capacityAttributesTable;
        RecordExtractor extractor = new RecordExtractor(this.myNodeServices);
        Set<String> moClasses = licTable.keySet();
        for (String moClass : moClasses) {
            DnNameValues[] dnNameValues = this.fetchAttributes(moClass, licTable.get(moClass));
            records.addAll(extractor.extractRecords(dnNameValues, this.myCollectorType));
        }
        this.addLicenseStateAttributes(records);
        return records;
    }

    private void addLicenseStateAttributes(ArrayList<LicenseAttributeRecord> records) {
        RecordExtractor extractor = new RecordExtractor(this.myNodeServices);
        Set<String> moClasses = this.licenseAttributesTable.keySet();
        ArrayList<LicenseAttributeRecord> licenseStateRecords = new ArrayList<LicenseAttributeRecord>(20);
        for (String moClass : moClasses) {
            DnNameValues[] dnNameValues = this.fetchAttributes(moClass, this.licenseAttributesTable.get(moClass));
            licenseStateRecords.addAll(extractor.extractRecords(dnNameValues));
        }
        block1: for (LicenseAttributeRecord record : records) {
            if (record.getAttribute("licenseState") != null) continue;
            String name = "licenseState" + record.getName();
            for (LicenseAttributeRecord licenseStateRecord : licenseStateRecords) {
                LicensingNameValue nv = licenseStateRecord.getAttribute("licenseState");
                if (nv == null || !nv.getName().equals(name)) continue;
                record.addAttribute(nv);
                continue block1;
            }
        }
    }

    private DnNameValues[] fetchAttributes(String moType, ArrayList<String> attributeList) {
        String[] attributeNames = attributeList.toArray(new String[0]);
        DnNameValues[] dnNameValues = null;
        try {
            Mo[] mos = this.myNodeServices.getNode().getCmService().getMoByType(moType, null);
            DnAttributes[] dnAttributes = new DnAttributes[mos.length];
            for (int i = 0; i < mos.length; ++i) {
                dnAttributes[i] = new DnAttributes(mos[i].getLdn(), attributeNames);
            }
            dnNameValues = this.myNodeServices.getNode().getCmService().getMoAttributes(dnAttributes, null);
        }
        catch (Exception e) {
            LicensingLogger.logger().warning("Could not fetch attributes for MO " + moType + ".\n" + LicensingLogger.stackToString(e));
            MessageDialogFactory.createMessageDialog((String)("Could not retrieve attributes correctly for the MO " + moType), (String)("The tab " + this.myCollectorType.tabName + " might not display the MO correctly."), (Exception)e, (boolean)false, null).setVisible(true);
        }
        if (dnNameValues == null) {
            return new DnNameValues[0];
        }
        return dnNameValues;
    }

    void resolveLicenseAttributes() {
        Iterator momClasses = this.myNodeServices.getMimModel().getClasses();
        this.licenseAttributesTable = new Hashtable();
        this.capacityAttributesTable = new Hashtable();
        this.featureAttributesTable = new Hashtable();
        while (momClasses.hasNext()) {
            MomClass momClass = (MomClass)momClasses.next();
            Iterator momAttributes = momClass.getAttributes();
            ArrayList<String> licenseList = new ArrayList<String>();
            ArrayList<String> capacityList = new ArrayList<String>();
            ArrayList<String> featureList = new ArrayList<String>();
            while (momAttributes.hasNext()) {
                MomAttribute momAttribute = (MomAttribute)momAttributes.next();
                String attributeName = momAttribute.getName();
                if (this.isRncLicenseStateAttribute(attributeName)) {
                    featureList.add(attributeName);
                    continue;
                }
                if (this.isLicenseStateAttribute(attributeName)) {
                    licenseList.add(attributeName);
                    continue;
                }
                if (this.isLicenseCapacityAttribute(attributeName)) {
                    capacityList.add(attributeName);
                    continue;
                }
                if (!this.isLicenseFeatureAttribute(attributeName)) continue;
                featureList.add(attributeName);
            }
            if (!licenseList.isEmpty()) {
                this.licenseAttributesTable.put(momClass.getName(), licenseList);
            }
            if (!capacityList.isEmpty()) {
                this.capacityAttributesTable.put(momClass.getName(), capacityList);
            }
            if (featureList.isEmpty()) continue;
            this.featureAttributesTable.put(momClass.getName(), featureList);
        }
    }

    private boolean isLicenseStateAttribute(String attributeName) {
        return attributeName.startsWith("licenseState");
    }

    private boolean isRncLicenseStateAttribute(String attributeName) {
        return attributeName.equals("licenseState");
    }

    private boolean isLicenseCapacityAttribute(String attributeName) {
        return this.myCollectorType == LicenseType.CAPACITY && (attributeName.startsWith("licenseCapacity") || attributeName.startsWith("licensedCapacityLimit") || attributeName.startsWith("capacityUnit") || attributeName.startsWith("keyId"));
    }

    private boolean isLicenseFeatureAttribute(String attributeName) {
        return this.myCollectorType == LicenseType.FEATURE && (attributeName.startsWith("serviceState") || attributeName.startsWith("featureState") || attributeName.startsWith("keyId"));
    }
}

