/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.treetable.AbstractTreeTableModel;
import se.ericsson.cello.nex.gui.treetable.TreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.NexTreeNodeFactoryI;
import se.ericsson.cello.nex.gui.view.workers.BatchUpdateWorker;
import se.ericsson.cello.nex.gui.view.workers.ExpandRecursivelyWorker;
import se.ericsson.cello.nex.gui.view.workers.ExpandSingleWorker;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;
import se.ericsson.cello.nex.gui.view.workers.ModelWorker;
import se.ericsson.cello.nex.gui.view.workers.PartiallyExpandToLDNWorker;
import se.ericsson.cello.nex.gui.view.workers.RefreshAllWorker;
import se.ericsson.cello.nex.gui.view.workers.RefreshNodeWorker;
import se.ericsson.cello.nex.gui.view.workers.UpdateNodesWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoTreeTableModel
extends AbstractTreeTableModel
implements TreeModel {
    private static final long serialVersionUID = 3868852158278431626L;
    private ArrayList<String> columnNames = new ArrayList();
    private NexTreeNodeFactoryI nodeFactory = null;
    private ExecutorService executor = Executors.newFixedThreadPool(1);

    public MoTreeTableModel(NexTreeNode root, Collection<String> columnNames, NexTreeNodeFactoryI nodeFactory) {
        super(root);
        this.nodeFactory = nodeFactory;
        this.columnNames.addAll(columnNames);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    @Override
    public Object getValueAt(Object node, int column) {
        Object value;
        if (-1 == column || column >= this.columnNames.size() || null == node) {
            return "";
        }
        if (column == 0) {
            value = ((NexTreeNode)node).getName();
        } else {
            String columnName = this.getColumnName(column);
            value = ((NexTreeNode)node).getValueAt(columnName);
        }
        return value;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return TreeTableModel.class;
            }
        }
        return String.class;
    }

    public void addColumn(String name) {
        this.columnNames.add(name);
    }

    public NexTreeNodeFactoryI getNodeFactory() {
        return this.nodeFactory;
    }

    public int getColumnIndex(String columnName) {
        return this.columnNames.indexOf(columnName);
    }

    public boolean containsColumn(String columnName) {
        return this.columnNames.contains(columnName);
    }

    public void setWorkerExecutor(ExecutorService e) {
        this.executor = e;
    }

    public ModelWorker<?, ?> asynchronousExpandNode(NexTreeNode node, ModelCallback<Void> modelCallback) {
        return this.runWorker(new ExpandSingleWorker(this, node, modelCallback));
    }

    public ModelWorker<?, ?> asynchronousExpandRecursively(NexTreeNode node, ModelCallback<Collection<TreePath>> callback) {
        return this.runWorker(new ExpandRecursivelyWorker(this, node, Integer.MAX_VALUE, callback));
    }

    public ModelWorker<?, ?> asynchronousExpandToLevel(NexTreeNode node, int level, ModelCallback<Collection<TreePath>> callback) {
        return this.runWorker(new ExpandRecursivelyWorker(this, node, level, callback));
    }

    public ModelWorker<?, ?> asynchronousUpdateNodes(Collection<NexTreeNode> nodes, Collection<String> columns, ModelCallback<Void> modelCallback) {
        return this.runWorker(new UpdateNodesWorker(this, nodes, columns, modelCallback));
    }

    public ModelWorker<?, ?> asynchronousBatchUpdate(Collection<NexTreeNode> nodes, Collection<String> columns, NodeServices nodeServices, ModelCallback<Boolean> callback) {
        return this.runWorker(new BatchUpdateWorker(this, nodeServices, nodes, columns, callback));
    }

    public ModelWorker<?, ?> asynchronousRefreshNode(NexTreeNode node, ModelCallback<NexTreeNode> callBack) {
        return this.runWorker(new RefreshNodeWorker(this, node, callBack));
    }

    public ModelWorker<?, ?> asynchronousRefreshAll(Enumeration<TreePath> expandedPaths, ModelCallback<Collection<TreePath>> callback) {
        return this.runWorker(new RefreshAllWorker(this, expandedPaths, callback));
    }

    public ModelWorker<?, ?> asynchronousPartiallyExpandToLDNs(Collection<String> ldns, ModelCallback<Collection<NexTreeNode>> callback) {
        return this.runWorker(new PartiallyExpandToLDNWorker(this, ldns, (NexTreeNode)this.getRoot(), callback));
    }

    private ModelWorker<?, ?> runWorker(ModelWorker<?, ?> worker) {
        NexLog.logger().fine("Enqueuing worker: " + ((Object)worker).toString());
        this.executor.execute((Runnable)((Object)worker));
        return worker;
    }

    public NexTreeNode findNode(String anLdn) {
        NexTreeNode top = (NexTreeNode)this.getRoot();
        return this.findNode(anLdn, top);
    }

    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[0]);
    }

    private NexTreeNode findNode(String ldn, NexTreeNode parent) {
        NexLog.logger().log(Level.FINEST, "findNode parent: " + parent.getName());
        if (parent.getLongName().equals(ldn)) {
            NexLog.logger().log(Level.FINEST, "findNode FOUND returning: " + parent.getName());
            return parent;
        }
        Enumeration<TreeNode> enumm = parent.children();
        while (enumm.hasMoreElements()) {
            NexTreeNode node = this.findNode(ldn, (NexTreeNode)enumm.nextElement());
            if (null == node) continue;
            NexLog.logger().log(Level.FINEST, "findNode has FOUND the Node!");
            return node;
        }
        return null;
    }

    public void destroy() {
        this.executor.shutdown();
    }

    public void removeColumn(String columnName) {
        this.columnNames.remove(columnName);
    }
}

