/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices;

import java.util.logging.Level;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.UI;
import se.ericsson.cello.nex.toolservices.NexEvent;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.cello.nex.viewservices.utils.MoDeletor;

public class DeleteMoExecutor
implements Runnable {
    private MoDeletor myMoDeletor = null;
    private ToolServicesI myToolServices = null;
    private UI myUI;
    private boolean completeSuccessful = false;

    public DeleteMoExecutor(MoDeletor aMoDeletor, ToolServicesI aToolServices, UI aUI) {
        this.myMoDeletor = aMoDeletor;
        this.myToolServices = aToolServices;
        this.myUI = aUI;
    }

    public void run() {
        try {
            this.myMoDeletor.deleteAll();
            this.myUI.setStatusMessage("Selected MOs deleted");
            this.completeSuccessful = true;
            NexLog.logger().log(Level.INFO, "DeleteMoExrcutor successful to delete MOs\n");
        }
        catch (Exception e) {
            String ldnList = this.myMoDeletor.getDeletedMosList();
            this.myUI.setMessage("Deletion failure.", "It was not possible to delete MO(s):\n" + ldnList, e, false);
            NexLog.logger().log(Level.INFO, "DeleteMoExrcutor failed to delete MOs\n");
            this.completeSuccessful = false;
        }
        if (this.completeSuccessful) {
            DeleteMoExecutor mySource = this;
            String myType = "se.ericsson.cello.nex.MO_DELETED";
            long mySequenceNumber = System.currentTimeMillis();
            String[] myLdnsUserData = this.myMoDeletor.getMosList();
            NexEvent myNexEvent = new NexEvent(myType, mySource, mySequenceNumber);
            myNexEvent.setUserData(myLdnsUserData);
            this.myToolServices.sendEmNotification(myNexEvent);
            NexLog.logger().log(Level.INFO, "DeleteMoExecutor sent EM notification\n");
        }
    }
}

