/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import se.ericsson.cello.nex.viewservices.ViewServicesI;
import se.ericsson.cello.nex.viewservices.model.ViewModelI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewInfo {
    private Map<String, ViewModelI> myPreDefViewModels;
    private Map<String, ViewModelI> myUserDefViewModels;
    private Map<String, ViewModelI> myImportedViewModels;
    private ViewServicesI viewServ;
    private boolean preDefsInitiated = false;
    private boolean userDefsOnceInitiated = false;
    private boolean importedOnceInitiated = false;

    public ViewInfo(ViewServicesI viewServices) {
        this.viewServ = viewServices;
        this.myPreDefViewModels = new HashMap<String, ViewModelI>();
        this.myUserDefViewModels = new HashMap<String, ViewModelI>();
        this.myImportedViewModels = new HashMap<String, ViewModelI>();
    }

    public Collection<String> getTopMoClasses(String viewName) {
        ViewModelI model = null;
        if (this.myPreDefViewModels.containsKey(viewName)) {
            model = this.myPreDefViewModels.get(viewName);
        } else if (this.myUserDefViewModels.containsKey(viewName)) {
            model = this.myUserDefViewModels.get(viewName);
        } else if (this.myImportedViewModels.containsKey(viewName)) {
            model = this.myImportedViewModels.get(viewName);
        }
        if (null != model) {
            return model.getTopMoClasses();
        }
        return new ArrayList<String>();
    }

    public Collection<String> getViewsForMoClass(String moClassName) {
        ViewModelI model;
        this.fillInPreDefViews();
        if (!this.userDefsOnceInitiated) {
            this.fillInUserDefViews();
        }
        if (!this.importedOnceInitiated) {
            this.fillInImportedViews();
        }
        Vector<String> supportedViews = new Vector<String>();
        Set<String> viewNames = this.myPreDefViewModels.keySet();
        for (String viename : viewNames) {
            model = this.myPreDefViewModels.get(viename);
            if (null == model || !model.getTopMoClasses().contains(moClassName)) continue;
            supportedViews.add(viename);
        }
        viewNames = this.myUserDefViewModels.keySet();
        for (String viename : viewNames) {
            model = this.myUserDefViewModels.get(viename);
            if (null == model || !model.getTopMoClasses().contains(moClassName)) continue;
            supportedViews.add(viename);
        }
        viewNames = this.myImportedViewModels.keySet();
        for (String viename : viewNames) {
            model = this.myImportedViewModels.get(viename);
            if (null == model || !model.getTopMoClasses().contains(moClassName)) continue;
            supportedViews.add(viename);
        }
        return supportedViews;
    }

    public String getDescription(String viewName) {
        if (this.myPreDefViewModels.containsKey(viewName)) {
            return this.myPreDefViewModels.get(viewName).getDescription();
        }
        if (this.myUserDefViewModels.containsKey(viewName)) {
            return this.myUserDefViewModels.get(viewName).getDescription();
        }
        if (this.myImportedViewModels.containsKey(viewName)) {
            return this.myImportedViewModels.get(viewName).getDescription();
        }
        return null;
    }

    public void fillInPreDefViews() {
        if (this.preDefsInitiated) {
            return;
        }
        this.myPreDefViewModels.put("Containment (MOM based)", this.viewServ.getViewModel("Containment (MOM based)", ViewServicesI.ViewType.CONTAINMENT));
        Collection<String> keys = this.viewServ.getPreDefViewNames();
        for (String key : keys) {
            ViewModelI model = this.viewServ.getViewModel(key, ViewServicesI.ViewType.PREDEFINED);
            if (null == model) continue;
            this.myPreDefViewModels.put(key, model);
        }
        this.preDefsInitiated = true;
    }

    public void fillInUserDefViews() {
        this.myUserDefViewModels.clear();
        Collection<String> keys = this.viewServ.getUserDefViewNames();
        for (String key : keys) {
            ViewModelI model = this.viewServ.getViewModel(key, ViewServicesI.ViewType.USERDEFINED);
            if (null == model) continue;
            this.myUserDefViewModels.put(key, model);
        }
        this.userDefsOnceInitiated = true;
    }

    public void fillInImportedViews() {
        this.myImportedViewModels.clear();
        Collection<String> keys = this.viewServ.getImportedViewNames();
        for (String key : keys) {
            ViewModelI model = this.viewServ.getViewModel(key, ViewServicesI.ViewType.IMPORTED);
            if (null == model) continue;
            this.myImportedViewModels.put(key, model);
        }
        this.importedOnceInitiated = true;
    }

    public void destroy() {
        this.myPreDefViewModels.clear();
        this.myPreDefViewModels = null;
        this.myUserDefViewModels.clear();
        this.myUserDefViewModels = null;
        this.myImportedViewModels.clear();
        this.myImportedViewModels = null;
        this.viewServ = null;
    }
}

