/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions.util;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.RbsAueMetaData;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2UtilHelper;

public class Step2UtilHelperImpl
implements Step2UtilHelper {
    private static final Class THIS_CLASS = Step2UtilHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());

    public MoDataWrapper createMo(MoDataAccessor moDataAccessor, String ldn, Coordinator coordinator, ConverterContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createMo(MoDataAccessor, String, Coordinator)");
        try {
            int froIdFromDatabase = Step2UtilHelperImpl.getFroIdFromDatabase(ldn, context);
            MoDataWrapper newMo = moDataAccessor.create(ldn, coordinator);
            newMo.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            Step2UtilHelperImpl.addFroIdAttribute(newMo, froIdFromDatabase);
            logger.traceReturn(THIS_CLASS, "createMo(MoDataAccessor, String, Coordinator)");
            return newMo;
        }
        catch (CrbsAueException cae) {
            throw cae;
        }
        catch (AueException ae) {
            CrbsAueException cae = new CrbsAueException(ae.getMessage());
            cae.setStackTrace(ae.getStackTrace());
            throw cae;
        }
    }

    private static void addFroIdAttribute(MoDataWrapper moData, int froId) throws CrbsAueException {
        IntegerAttribute froIdAttribute = new IntegerAttribute("froId", false, froId);
        moData.registerPersistentAttr((Attribute)froIdAttribute);
    }

    private static int getFroIdFromDatabase(String ldn, ConverterContext context) throws CrbsAueException {
        DbWrapper dbWrapper;
        try {
            dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        }
        catch (Exception e) {
            throw new CrbsAueException("Can not get the DbWrapper. Reason: " + e.getMessage());
        }
        Step2Handler step2Handler = (Step2Handler)context.getAttribute("CURRENT_STEP2_HANDLER");
        RbsAueMetaData rbsAueMetaData = step2Handler.getRbsAueMetaData();
        ResultSet resultSet = null;
        String frodataTableName = null;
        String table = rbsAueMetaData.getFroVersionsTableName();
        Integer froid = new Integer(-1);
        String froTypeName = LdnUtil.getMoType(ldn);
        try {
            dbWrapper.openConnection();
            resultSet = dbWrapper.executeQuery("SELECT frodataTableName FROM " + rbsAueMetaData.getFroVersionsTableName() + " WHERE froTypeName = " + AueUtil.quote(froTypeName));
            frodataTableName = Step2UtilHelperImpl.getValue(resultSet);
            if (frodataTableName == null) {
                logger.traceDebug(THIS_CLASS, "Can not find frodata table for " + froTypeName);
            } else {
                table = frodataTableName;
                resultSet = dbWrapper.executeQuery("SELECT froid FROM " + frodataTableName + " WHERE ldn = " + AueUtil.quote(ldn));
                froid = Integer.valueOf(Step2UtilHelperImpl.getValue(resultSet));
            }
        }
        catch (NumberFormatException e) {
            throw new CrbsAueException("Can not find the froid for " + ldn + " in " + frodataTableName);
        }
        catch (SQLException e) {
            throw new CrbsAueException("Can not open and execute query to table " + table + ". Reason: " + e.getMessage());
        }
        finally {
            try {
                dbWrapper.closeConnection(2);
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sqle) {
                throw new CrbsAueException(sqle.getMessage());
            }
        }
        return froid;
    }

    private static String getValue(ResultSet resultSet) throws SQLException {
        String value = null;
        if (resultSet.next()) {
            value = resultSet.getString(1);
        }
        return value;
    }
}

