/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpOam;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpRoutingTable;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IpRoutingRI
extends AbstractResourceItem
implements ResourceItem {
    private static final String[] myInstallationPhases = new String[]{"IpRoutingCreationPhase"};
    private static String name = "IPROUTING";
    private String ipAddress = "0.0.0.0";
    private String subnetMask = "0.0.0.0";
    private Integer routeMetric = new Integer(100);
    private Boolean redistribute = false;
    private String nextHopString;
    private NalStruct defaultRouterEntry = null;
    private String ipRoutingTableLdn;
    private BemMo ipRoutingTableMo;

    public IpRoutingRI(Rbs rbs) throws BemException {
        super(name, rbs, myInstallationPhases);
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpOam.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimIp.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi3 = new SingleChildMoi(singleChildMoi2, MimIpRoutingTable.MOTYPENAME, "1");
        this.ipRoutingTableLdn = singleChildMoi3.getLdn();
        this.ipRoutingTableMo = this.getMo(this.ipRoutingTableLdn);
    }

    public void install(String string) throws BemException {
        if (myInstallationPhases[0].equals(string)) {
            this.setIpRouting();
        }
    }

    private void setIpRouting() throws BemException {
        CustomerParameterImpl customerParameterImpl = null;
        customerParameterImpl = (CustomerParameterImpl)super.getCustomerParameter("defaultRouter");
        this.nextHopString = customerParameterImpl.getValue();
        String string = customerParameterImpl.getLoadedValue();
        if (!(this.nextHopString == null || this.nextHopString.equals("") || this.nextHopString.equals("##UNDEFINED") || this.nextHopString.equals("0.0.0.0") || string != null && !string.equals("##UNDEFINED") && string.equals(this.nextHopString))) {
            NalNameValue[] nalNameValueArray = new NalNameValue[5];
            try {
                nalNameValueArray[0] = Nal.getFactory().getNameValue("ipAddress", this.ipAddress);
                nalNameValueArray[1] = Nal.getFactory().getNameValue("subnetMask", this.subnetMask);
                nalNameValueArray[2] = Nal.getFactory().getNameValue("hopIpAddress", this.nextHopString);
                if (this.defaultRouterEntry != null) {
                    this.routeMetric = (Integer)this.defaultRouterEntry.getMemberValue("routeMetric");
                    this.redistribute = (Boolean)this.defaultRouterEntry.getMemberValue("redistribute");
                }
                nalNameValueArray[3] = Nal.getFactory().getNameValue("routeMetric", this.routeMetric);
                nalNameValueArray[4] = Nal.getFactory().getNameValue("redistribute", this.redistribute);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new BemException(this.getClass().getName(), "setIpRouting()", null, "\tCould not find field in routing table", noSuchFieldException);
            }
            if (string != null && !string.equals("##UNDEFINED") && !this.rbs.getRbsStep().equals("STEP_INT_DHCP")) {
                NalNameValue[] nalNameValueArray2 = new NalNameValue[]{Nal.getFactory().getNameValue("routingTableEntry", this.getDefaultRouterEntry())};
                this.action(this.ipRoutingTableMo, "deleteStaticRoute", nalNameValueArray2);
            }
            this.action(this.ipRoutingTableMo, "addStaticRoute", nalNameValueArray);
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        if (super.isExisting(this.ipRoutingTableLdn)) {
            bl = true;
        }
        return bl;
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return this.ipRoutingTableLdn;
    }

    public NalStruct getDefaultRouterEntry() throws BemException {
        NalStruct nalStruct = null;
        try {
            int n = (Integer)this.action(this.ipRoutingTableMo, "numberOfRoutes", new NalNameValue[0]);
            NalNameValue[] nalNameValueArray = new NalNameValue[1];
            for (int i = 0; i < n; ++i) {
                nalNameValueArray[0] = Nal.getFactory().getNameValue("IpRoutingTableId", new Integer(i));
                nalStruct = (NalStruct)this.action(this.ipRoutingTableMo, "getRoutingTableEntry", nalNameValueArray);
                String string = (String)nalStruct.getMember("destinationIpAddr").getValue();
                String string2 = (String)nalStruct.getMember("destinationNetworkMask").getValue();
                String string3 = (String)nalStruct.getMember("nextHopIpAddr").getValue();
                if (!string.equals("0.0.0.0") || !string2.equals("0.0.0.0") || string3.equals("0.0.0.0")) continue;
                Integer n2 = (Integer)nalStruct.getMemberValue("routeMetric");
                if (this.defaultRouterEntry != null && n2.compareTo((Integer)this.defaultRouterEntry.getMember("routeMetric").getValue()) >= 0) continue;
                this.defaultRouterEntry = nalStruct;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException(this.getClass().getName(), "getDefaultRouter()", null, "\tCould not find field in RoutingTableEntry", noSuchFieldException);
        }
        return this.defaultRouterEntry;
    }
}

