/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.resource;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IpInterfaceNetworkPrefixLengthConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ReconnectDialogProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpHostLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpOam;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalProgress;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.common.util.RegressionTestInDesigntestUtils;

public class ReconnectRI
extends AbstractResourceItem {
    public static final String name = "ReconnectRI";
    private static final String[] phases = new String[]{"ReconnectPhase"};
    private String newNodeIpAddress;
    private boolean isNodeIpAddressConfiguredByDHCP = false;
    private static final int MAX_ATTEMPTS_WITH_GUI = 10;
    private static final int RETRY_INTERVAL_MS = 60000;
    private String dhcpMessage = "";
    private String oamDefaultRouter0Value;
    private String oamSubnetMaskValue;

    public ReconnectRI(Rbs rbs) {
        super(name, rbs, phases);
    }

    public void install(String string) throws BemException {
        if (string.equals("ReconnectPhase")) {
            this.reconnect();
        }
    }

    private void fetchNodeIpAddress() throws BemException {
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpOam.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimIp.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi3 = new SingleChildMoi(singleChildMoi2, MimIpHostLink.MOTYPENAME, "1");
        boolean bl = false;
        long l = System.currentTimeMillis();
        while (!bl) {
            if (super.isInterrupted()) {
                Nal.getLog().nalTrace(4, this.getClass(), "Getting attribute ipAddress on MO IpHostLink was interrupted by user!\n");
                break;
            }
            long l2 = System.currentTimeMillis();
            if (l2 - l > 60000L) {
                Nal.getLog().nalTrace(4, this.getClass(), "Getting attribute ipAddress on MO IpHostLink was timeout!\n");
                break;
            }
            try {
                BemMo bemMo = this.getMo(singleChildMoi3.getLdn());
                String[] stringArray = (String[])this.getAttribute(bemMo, "ipv4Addresses");
                if (stringArray != null && stringArray.length > 0) {
                    BemMo bemMo2 = (BemMo)this.getAttribute(bemMo, "ipInterfaceMoRef");
                    this.oamDefaultRouter0Value = (String)this.getAttribute(bemMo2, "defaultRouter0");
                    Integer n = (Integer)this.getAttribute(bemMo2, "networkPrefixLength");
                    if (n != null) {
                        IpInterfaceNetworkPrefixLengthConversion ipInterfaceNetworkPrefixLengthConversion = new IpInterfaceNetworkPrefixLengthConversion();
                        this.oamSubnetMaskValue = ipInterfaceNetworkPrefixLengthConversion.convertToParameterValue(n);
                    }
                    this.newNodeIpAddress = stringArray[0];
                    if (this.newNodeIpAddress == null || "".equals(this.newNodeIpAddress) || this.oamDefaultRouter0Value == null || "".equals(this.oamDefaultRouter0Value) || this.oamSubnetMaskValue == null || "".equals(this.oamSubnetMaskValue)) {
                        try {
                            Thread.sleep(200L);
                            Nal.getLog().nalTrace(4, this.getClass(), "Did not get the ipv4Address or DefaultRouter0 or SubnetMask!!\n");
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            Nal.getLog().nalTrace(4, this.getClass(), "Getting attribute ipAddress on MO IpHostLink was interrupted by user!!\n");
                            break;
                        }
                    }
                    Nal.getLog().nalTrace(3, this.getClass(), "About to  CHANGE THE IP ADDRESS of the node and DISCONNECT!\n             New address fetched from DHCP:\n               " + this.newNodeIpAddress);
                    bl = true;
                    continue;
                }
                try {
                    Thread.sleep(200L);
                    Nal.getLog().nalTrace(4, this.getClass(), "Did not get the ipv4Addresses!!\n");
                }
                catch (InterruptedException interruptedException) {
                    Nal.getLog().nalTrace(4, this.getClass(), "Getting attribute ipAddress on MO IpHostLink was interrupted by user!!!\n");
                    break;
                }
            }
            catch (Exception exception) {
                Nal.getLog().nalTrace(4, this.getClass(), "GET_IPV4ADDRESSED EXCEPTION" + exception.getMessage());
            }
        }
        if (!bl) {
            throw new BemException("Fecthing O&M access IP address failed in DHCP configuration mode");
        }
    }

    private void reconnect() throws BemException {
        ExceptionProperties exceptionProperties = ExceptionProperties.getRevisionProperties();
        exceptionProperties.setProperty("Rbs Reconnect IP Address", this.newNodeIpAddress);
        try {
            Nal.getFactory().sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BemException("Sleep interrupted when waiting for reconnection.");
        }
        if (this.isNodeIpAddressConfiguredByDHCP) {
            if (RegressionTestInDesigntestUtils.getRegressionTest() || BemLanguageHelp.getEnvironment() == 1) {
                this.newNodeIpAddress = "1.1.1.1";
                this.oamSubnetMaskValue = "255.255.255.0";
                this.oamDefaultRouter0Value = "0.0.0.0";
                Nal.getLog().nalTrace(3, this.getClass(), "Fecthing O&M access IP address successfully in DHCP configuration mode for test mode.");
            } else if (this.rbs.getRbsStep().equals("STEP_INT_OAM")) {
                this.newNodeIpAddress = "127.0.0.1";
            } else {
                this.fetchNodeIpAddress();
                this.dhcpMessage = ", subnetMask=" + this.oamSubnetMaskValue + ", defaultRouter0=" + this.oamDefaultRouter0Value;
            }
        }
        Nal.getLog().nalTrace(3, this.getClass(), "About to  CHANGE THE IP ADDRESS of the node and DISCONNECT!\n             New address:\n               " + this.newNodeIpAddress);
        this.rbs.reportProgress("Reconnecting to new node IP=" + this.newNodeIpAddress + this.dhcpMessage);
        final ReconnectDialogProvider reconnectDialogProvider = this.rbs.getReconnectDialogProvider();
        NalProgress nalProgress = null;
        if (reconnectDialogProvider != null) {
            nalProgress = new NalProgress(){

                public void reportProgress(int n, String string) {
                    reconnectDialogProvider.reportReconnectProgress(string);
                }
            };
            reconnectDialogProvider.launchReconnectProgressDialog();
        }
        int n = 1;
        while (true) {
            try {
                Nal.getFactory().reconnectMib(this.newNodeIpAddress, nalProgress);
                String string = "Done reconnecting to new node IP address = " + this.newNodeIpAddress + this.dhcpMessage + " !";
                Nal.getLog().nalTrace(3, this.getClass(), string);
                this.rbs.reportProgress(string);
                if (reconnectDialogProvider != null) {
                    reconnectDialogProvider.closeReconnectProgressDialog(string);
                }
                return;
            }
            catch (NalCmException nalCmException) {
                String string = "Failed reconnecting to the newNodeIpAddress: " + this.newNodeIpAddress;
                Nal.getLog().nalTrace(4, this.getClass(), string + " Time to retry?");
                if (reconnectDialogProvider == null || n >= 10) {
                    BemException bemException = new BemException(string + " after attempt #" + n, (Throwable)nalCmException);
                    bemException.setProperty("Problem", "Failed reconnecting to the node on new OAM IP Address");
                    bemException.setProperty("Additional Info", "Nodes new ipAddress=" + this.newNodeIpAddress);
                    throw bemException;
                }
                reconnectDialogProvider.reportReconnectProgress(nalCmException.toString() + ", attempt #" + n + " of " + 10);
                ++n;
                continue;
            }
            break;
        }
    }

    public void setNodeIpAddressConfiguredByDHCP(boolean bl) {
        this.isNodeIpAddressConfiguredByDHCP = bl;
    }

    public void setNewNodeIpAddress(String string) {
        this.newNodeIpAddress = string;
    }

    public String getLdn() {
        return null;
    }

    public String getDisplayName() {
        return name;
    }
}

