/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.LocationParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.AtmPortProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.IpOverAtmCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.IpOverAtmParameterSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpMcrParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpPcrParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.resource.Aal5TpVccTpRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.resource.AtmStackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.resource.IpAtmLinkRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class RIAndCPSet
implements CustomerParameterListener {
    public static final int DEFAULT = 0;
    public static final int REDUNDANT = 1;
    public static final int NO_OF_LINKS = 2;
    private static String vpiValue = null;
    private static String vpPcrValue = null;
    private static String vpMcrValue = null;
    private static String vpServiceCategoryValue = null;
    private int linkId = 0;
    private AtmPortProvider atmPortProvider = null;
    private LocationParameter location = null;
    private IpOverAtmCI ipOverAtmCI = null;
    private Aal5TpVccTpRI aal5TpVccTpRI = null;
    private AtmStackRI atmStackRI = null;
    private IpAtmLinkRI ipAtmLinkRI = null;
    private TerminationParameterList paramList = null;
    private IpOverAtmParameterSet paramSet = null;
    boolean isXMLFileInUse = false;
    private String vpServiceValue = "";

    public RIAndCPSet(int n, IpOverAtmCI ipOverAtmCI, AtmPortProvider atmPortProvider, LocationParameter locationParameter, Aal5TpVccTpRI aal5TpVccTpRI, AtmStackRI atmStackRI, IpAtmLinkRI ipAtmLinkRI, IpOverAtmParameterSet ipOverAtmParameterSet, TerminationParameterList terminationParameterList) {
        this.ipOverAtmCI = ipOverAtmCI;
        this.linkId = n;
        this.atmPortProvider = atmPortProvider;
        this.location = locationParameter;
        this.aal5TpVccTpRI = aal5TpVccTpRI;
        this.atmStackRI = atmStackRI;
        this.ipAtmLinkRI = ipAtmLinkRI;
        this.paramSet = ipOverAtmParameterSet;
        this.paramList = terminationParameterList;
        this.addCPListener();
    }

    protected void addCPListener() {
        ParameterEvent parameterEvent;
        if (this.location != null) {
            this.location.addCustomerParameterListener(this);
            parameterEvent = new ParameterEvent(2);
            this.parameterPropertiesChanged(this.location, parameterEvent);
        }
        if (this.paramList != null) {
            this.paramList.addCustomerParameterListener(this);
            parameterEvent = new ParameterEvent(2);
            this.parameterPropertiesChanged(this.paramList, parameterEvent);
        }
        if (this.paramSet != null) {
            this.paramSet.addCustomerParameterListener(this);
        }
    }

    public int getLinkId() {
        return this.linkId;
    }

    public TerminationParameterList getTerminationParameterList() {
        return this.paramList;
    }

    public IpOverAtmParameterSet getParamSet() {
        return this.paramSet;
    }

    public Aal5TpVccTpRI getAal5TpVccTpRI() {
        return this.aal5TpVccTpRI;
    }

    public AtmStackRI getAtmStackRI() {
        return this.atmStackRI;
    }

    public IpAtmLinkRI getIpAtmLinkRI() {
        return this.ipAtmLinkRI;
    }

    public String getAtmPortLdn() throws BemException {
        String string = this.paramList.getSlotParameter().getName();
        return this.atmPortProvider.getAtmPortLdn(string);
    }

    protected void updateDefaultPeakCellRate() throws BemException {
        VpPcrParameter vpPcrParameter = this.paramSet.getVpPcrParameter();
        Integer n = this.atmPortProvider.getMaxPeakCellRate(this.linkId);
        if (n != null) {
            vpPcrParameter.setDefaultValue(n.toString());
        }
    }

    protected void updateMaxRangeForPeakCellRate() throws BemException {
        VpPcrParameter vpPcrParameter = this.paramSet.getVpPcrParameter();
        Integer n = this.atmPortProvider.getDefaultPeakCellRate(this.linkId);
        int n2 = vpPcrParameter.getMinValue();
        if (n == null) {
            return;
        }
        IntegerRange integerRange = new IntegerRange(n2, (int)n);
        IntegerRange integerRange2 = (IntegerRange)vpPcrParameter.getEnabledValueRange();
        Integer n3 = integerRange2.getMaxValue();
        if (n3.intValue() != n.intValue()) {
            vpPcrParameter.getRestriction().setRange(integerRange, true);
            if (!this.isXMLFileInUse) {
                vpPcrParameter.setValue(n.toString());
            }
        }
    }

    protected void updateDefaultMinCellRate() throws BemException {
        VpMcrParameter vpMcrParameter = this.paramSet.getVpMcrParameter();
        if ((Integer)this.paramSet.getVpServiceCategoryParameter().getValueMom() == 1 && !this.isXMLFileInUse) {
            vpMcrParameter.setValue("0");
            return;
        }
        Integer n = this.atmPortProvider.getMaxMinCellRate(this.linkId);
        if (n != null) {
            vpMcrParameter.setDefaultValue(n.toString());
            if (vpMcrParameter.getAccessLevel() != 0) {
                vpMcrParameter.setValue(n.toString());
            }
        }
    }

    protected void updateMaxRangeForMinCellRate() throws BemException {
        VpMcrParameter vpMcrParameter = this.paramSet.getVpMcrParameter();
        Integer n = this.atmPortProvider.getMaxMinCellRate(this.linkId);
        int n2 = vpMcrParameter.getMinValue();
        if (n == null) {
            return;
        }
        IntegerRange integerRange = new IntegerRange(n2, (int)n);
        IntegerRange integerRange2 = (IntegerRange)vpMcrParameter.getEnabledValueRange();
        Integer n3 = integerRange2.getMaxValue();
        if (n3.intValue() != n.intValue()) {
            vpMcrParameter.getRestriction().setRange(integerRange, true);
        }
    }

    protected void update_VP_values() {
        if (this.linkId == 0) {
            vpiValue = this.paramSet.getVpiParameter().getValue();
            vpPcrValue = this.paramSet.getVpPcrParameter().getValue();
            vpMcrValue = this.paramSet.getVpMcrParameter().getValue();
            vpServiceCategoryValue = this.paramSet.getVpServiceCategoryParameter().getValue();
        } else if (this.linkId == 1) {
            if (vpiValue != null) {
                this.paramSet.getVpiParameter().setValue(vpiValue);
            }
            if (vpPcrValue != null) {
                this.paramSet.getVpPcrParameter().setValue(vpPcrValue);
            }
            if (vpMcrValue != null) {
                this.paramSet.getVpMcrParameter().setValue(vpMcrValue);
            }
            if (vpServiceCategoryValue != null) {
                this.paramSet.getVpServiceCategoryParameter().setValue(vpServiceCategoryValue);
            }
        }
    }

    protected void updateParamSet() throws BemException {
        if (!this.paramList.isReadOnly()) {
            if (this.linkId == 0) {
                this.paramSet.setAsMandatoryCP();
                this.update_VP_values();
            } else if (this.linkId == 1) {
                boolean bl = this.ipOverAtmCI.usesSameAtmPort(0, 1);
                if (bl) {
                    this.paramSet.setAsIgnoredCP(true, true, true, true, false, false, false);
                    this.update_VP_values();
                    this.ipOverAtmCI.setListenersTo_VPI_PCR();
                } else {
                    this.paramSet.setAsMandatoryCP();
                    this.ipOverAtmCI.removeListenersFrom_VPI_PCR();
                }
            }
        } else if (this.location.isRemote()) {
            this.paramSet.setAsReadOnlyCP();
        } else if (this.location.isOnSite()) {
            if (this.linkId == 0) {
                this.update_VP_values();
                this.paramSet.setVPIAndVCIAsReadOnlyCP();
            } else if (this.linkId == 1) {
                boolean bl = this.ipOverAtmCI.usesSameAtmPort(0, 1);
                if (bl) {
                    this.paramSet.setVPI_VCI_ReadOnly_PCR_Ignored();
                    this.update_VP_values();
                    this.ipOverAtmCI.setListenersTo_VPI_PCR();
                } else {
                    this.paramSet.setVPIAndVCIAsReadOnlyCP();
                    this.ipOverAtmCI.setListenersTo_VPI_PCR();
                }
            }
        }
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        try {
            if (parameterEvent.isValueChanged() || parameterEvent.isRangeChanged()) {
                this.updateMaxRangeForPeakCellRate();
                this.updateMaxRangeForMinCellRate();
                if (this.paramList.isIgnored()) {
                    this.paramSet.setAsIgnoredCP();
                } else {
                    this.updateParamSet();
                    if (!this.isXMLFileInUse) {
                        IpOverAtmParameterSet ipOverAtmParameterSet;
                        String string;
                        if (customerParameter instanceof TerminationParameterList) {
                            this.updateDefaultPeakCellRate();
                            this.updateDefaultMinCellRate();
                        } else if (customerParameter instanceof IpOverAtmParameterSet && !(string = (ipOverAtmParameterSet = (IpOverAtmParameterSet)customerParameter).getVpServiceCategoryParameter().getValue()).equals(this.vpServiceValue)) {
                            this.vpServiceValue = string;
                            this.updateDefaultPeakCellRate();
                            this.updateDefaultMinCellRate();
                        }
                    }
                }
            }
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
        }
    }
}

