/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ControlSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal5TpVccTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTransportNetwork;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.ReferringMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class Aal5TpVccTpRI
extends AbstractResourceItem {
    public static final String NAME = "Aal5TpVccTp";
    private static final String[] myInstallationPhases = new String[]{"Aal5CreationPhase", "Aal5DeletionPhase"};
    private static final int DEFAULT = 0;
    private static final int REDUNDANT = 1;
    private int linkId = 0;
    private String[] rdnId = new String[]{"1", "2"};
    private String loadedProcessorId = null;
    private String processorId = null;
    private String loadedVclTpId = null;
    private String vclTpId = null;
    private String aal5Ldn;
    private MoInstance aal5Moi;
    private ControlSystemProvider controlSProvider = null;

    public Aal5TpVccTpRI(Rbs rbs, int n, MoInstance moInstance, ControlSystemProvider controlSystemProvider) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        this.linkId = n;
        this.controlSProvider = controlSystemProvider;
        SingleChildMoi singleChildMoi = new SingleChildMoi(rbs.getRootMoi(), MimTransportNetwork.MOTYPENAME, "1");
        if (n != 0 && n != 1) {
            throw new BemException("Faulty link id: " + n);
        }
        this.aal5Moi = new ReferringMoi(singleChildMoi, MimAal5TpVccTp.MOTYPENAME, moInstance, "aal5TpVccTpId", this.rdnId[n]);
        this.aal5Ldn = this.aal5Moi.getLdn();
        this.readAllAttributes();
        this.fetchProcessorId();
    }

    private void readAllAttributes() throws BemException {
        if (this.isExisting()) {
            BemMo bemMo = (BemMo)this.getAttribute(this.getMo(this.aal5Ldn), "vclTpId");
            this.vclTpId = this.loadedVclTpId = bemMo.getDN();
            BemMo bemMo2 = (BemMo)this.getAttribute(this.getMo(this.aal5Ldn), "processorId");
            this.loadedProcessorId = bemMo2.getDN();
        }
    }

    public boolean isExisting() throws BemException {
        BemMo bemMo = this.getMo(this.aal5Ldn);
        return this.isExisting(bemMo);
    }

    public String getLoadedVclTpId() {
        return this.loadedVclTpId;
    }

    public void setVclTpId(String string) {
        this.vclTpId = string;
    }

    public boolean isVclTpIdChanged() {
        boolean bl = false;
        if (this.loadedVclTpId != null && !this.loadedVclTpId.equals(this.vclTpId)) {
            bl = true;
        }
        return bl;
    }

    private void fetchProcessorId() throws BemException {
        String[] stringArray = (String[])this.controlSProvider.getProcessorPiuLdns().clone();
        if (stringArray != null) {
            if (stringArray.length == 1) {
                this.processorId = stringArray[0];
            } else if (stringArray.length >= 2) {
                this.processorId = stringArray[this.linkId];
            }
        } else {
            throw new BemException("No processor LDN found");
        }
    }

    public boolean isProcessorIdChanged() {
        boolean bl = false;
        if (this.loadedProcessorId != null && !this.loadedProcessorId.equals(this.processorId)) {
            bl = true;
        }
        return bl;
    }

    public String getMPType() throws BemException {
        String string = null;
        BemMo bemMo = this.getMo(this.processorId);
        BemMo[] bemMoArray = this.getChildren(bemMo, 1, "", "");
        if (bemMoArray != null && bemMoArray.length == 2) {
            String string2 = bemMoArray[1].getLastRDN();
            int n = string2.lastIndexOf("=");
            string = string2.substring(0, n);
        }
        return string;
    }

    public void install(String string) throws BemException {
        if (string.equals("Aal5CreationPhase")) {
            this.createMO();
        }
    }

    private void createMO() throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        BemMo bemMo = this.getMo(this.vclTpId);
        BemMo bemMo2 = this.getMo(this.processorId);
        vector.add(Nal.getFactory().getNameValue("vclTpId", bemMo));
        vector.add(Nal.getFactory().getNameValue("processorId", bemMo2));
        vector.add(Nal.getFactory().getNameValue("fromUserMaxSduSize", new Integer(1508)));
        vector.add(Nal.getFactory().getNameValue("toUserMaxSduSize", new Integer(1508)));
        this.createMoIfNotExisting(this.aal5Ldn, vector);
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("Aal5DeletionPhase")) {
            this.deleteMoIfNotExisting(this.aal5Ldn);
        }
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getLdn() {
        return this.aal5Ldn;
    }
}

