/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessHostEt;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSec;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSystem;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IpSecRI
extends AbstractResourceItem {
    public static final String name = "IpSec";
    private static String[] phases = new String[]{"IpSecCreationPhase"};
    private final List pseudoList = new ArrayList();
    private static final String IPSEC_AUTO_UPDATE_CERT_ENROLLMENT_SERVER = "IpSec_autoUpdateCertEnrollmentServer";
    private MoInstance ipSecMoi;
    private final ParameterRestriction restrictionReadonly = new ParameterRestriction("Read Only", 0);
    public static final String NOIPSEC = "NON_IPSEC";
    public static final String IPSECB = "IPSEC_SINGLE_LINK";
    public static final String IPSECC = "IPSEC_DUAL_LINK";

    public IpSecRI(Rbs rbs) throws BemException {
        super(name, rbs, phases);
        List list = this.getCustomerParameters();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CustomerParameter customerParameter = (CustomerParameter)iterator.next();
            this.pseudoList.add(customerParameter.getName());
        }
        this.initializeMois();
        this.initiateCPWithNodeValues();
    }

    private void initializeMois() {
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpSystem.MOTYPENAME, "1");
        this.ipSecMoi = new SingleChildMoi(singleChildMoi, MimIpSec.MOTYPENAME, "1");
    }

    private void initiateCPWithNodeValues() throws BemException {
        String string = "";
        String string2 = this.ipSecMoi.getLdn();
        boolean bl = this.isInstalled();
        if (bl) {
            Object object;
            Object object2;
            Object object3;
            BemMo bemMo = this.getMo(string2);
            Iterator iterator = this.pseudoList.iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = this.rbs.getCustomerParameterServerObject((String)object3);
                string = object2.getAttributeName();
                object = this.getAttribute(bemMo, string);
                object2.setLoadedValue(object);
            }
            object3 = this.rbs.getCustomerParameterServerObject("IpSec_configType");
            object2 = this.rbs.getRootMoi();
            object = new SingleChildMoi((MoInstance)object2, MimIpSystem.MOTYPENAME, "1");
            BemMo bemMo2 = this.getMo(((MoInstance)object).getLdn());
            BemMo[] bemMoArray = this.getChildren(bemMo2, 1, MimIpAccessHostEt.MOTYPENAME, "");
            if (bemMoArray.length == 2) {
                object3.setLoadedValue(IPSECB);
            } else if (bemMoArray.length == 3) {
                object3.setLoadedValue(IPSECC);
            }
            object3.addRestriction(this.restrictionReadonly);
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        if (this.ipSecMoi != null) {
            String string = this.ipSecMoi.getLdn();
            BemMo bemMo = this.getMo(string);
            bl = this.isExisting(bemMo);
        }
        return bl;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            Iterator iterator = this.pseudoList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                bl = bl2;
                break;
            }
        } else {
            Iterator iterator = this.pseudoList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                if (!customerParameter.isValidValue()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (string.equals("IpSecCreationPhase")) {
            this.installIpSec();
        }
    }

    private void installIpSec() throws BemException {
        String string = this.ipSecMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isInstalled();
        if (!bl) {
            Object object;
            String string2;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            Iterator iterator = this.pseudoList.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                string2 = customerParameterServer.getAttributeName();
                object = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string2, object));
            }
            string2 = "featureState";
            object = new Integer(1);
            vector.add(Nal.getFactory().getNameValue(string2, object));
            this.create(bemMo, vector);
        } else {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            Iterator iterator = this.pseudoList.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
                boolean bl2 = customerParameterServer.hasValueChanged();
                if (!bl2) continue;
                String string5 = customerParameterServer.getAttributeName();
                Object object = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string5, object));
            }
            if (vector.size() > 0) {
                this.setAttributes(bemMo, vector);
            }
        }
    }

    public String getLdn() {
        return "";
    }

    public String getDisplayName() {
        return name;
    }

    public String getIpSecLdn() throws BemException {
        String string = "";
        if (this.ipSecMoi != null) {
            string = this.ipSecMoi.getLdn();
        }
        return string;
    }

    public MoInstance getMoi() {
        return this.ipSecMoi;
    }

    private List getCustomerParameters() throws BemException {
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(IPSEC_AUTO_UPDATE_CERT_ENROLLMENT_SERVER);
        arrayList.add(customerParameter);
        return arrayList;
    }
}

