/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.BatteryCapacityParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.ConfPowerShelfFanParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.ConfigureBatteryBackupParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.ConfigurePowerSupplyParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.NoOfPsuParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.AccuManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.BatteryManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.PowerDistrManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.PowerManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimBattery;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public abstract class AbstractPowerSupplyRBS3CI
extends AbstractConfigurationItem
implements CustomerParameterListener,
PowerSupplyProvider {
    public static final String name = "PowerSystemCI";
    private PowerManager powerManager;
    private AccuManager accuManager;
    private BatteryManager batteryManager;
    private PowerDistrManager powerDistrManager;
    protected ConfigureBatteryBackupParameter confBattBackupCustParam;
    protected BatteryCapacityParameter battCapacityCustParam;
    protected ConfigurePowerSupplyParameter confPowerSupplyCustParam;
    protected NoOfPsuParameter noOfPsuCustParam;
    protected ConfPowerShelfFanParameter confPowerShelfFanParam;
    private boolean isOpen = false;
    private ParameterRestriction restrictionOptional = new ParameterRestriction("", 2);
    private ParameterRestriction restrictionReadOnlyWhenBatteryInstalled = new ParameterRestriction("Can not delete an existing battery", 0);
    private ParameterRestriction restrictionIgnoredBatteryWhenNoPowerSupply = new ParameterRestriction("Power Supply not configured", 1);
    private String[] allowedValueNo = new String[]{"NO"};
    private EnumeratedRange allowedRangeNo = new EnumeratedRange(this.allowedValueNo);
    private ParameterRestriction restrictionRangeWhenNoBatterySupport = new ParameterRestriction("Configuration of Battery not supported", this.allowedRangeNo, true);
    private ParameterRestriction restrictionIgnoredBatteryCapacityWhenNoBattery = new ParameterRestriction("Battery Capacity read only", 1);
    private ParameterRestriction restrictionRangeForBatteryCapacity = new ParameterRestriction("Range for BatteryCapacity", new IntegerRange(MimBattery.MIN_BATTERYCAPACITYDEFAULTVALUE, MimBattery.MAX_BATTERYCAPACITYDEFAULTVALUE), true);
    protected ParameterRestriction restrictionIgnoredPSUWhenNoPowerSupply = new ParameterRestriction("PSUs are not needed when no power supply is selected", 1);
    protected ParameterRestriction restrictionRangeNoOfPsu;
    protected String[] allowedValueYes = new String[]{"YES"};
    protected EnumeratedRange allowedRangeYes = new EnumeratedRange(this.allowedValueYes);
    protected ParameterRestriction restrictionRangeYesWhenPowerSupplyMandatory = new ParameterRestriction("Power supply is mandatory for this RBS type", this.allowedRangeYes, true);
    protected ParameterRestriction restrictionReadOnlyWhenPowerSupplyInstalled = new ParameterRestriction("Can not delete an existing power supply", 0);
    protected ParameterRestriction restrictionIgnoredPSFANWhenNoPowerSupply = new ParameterRestriction("PS ShelfFan are not needed when no power supply is selected", 1);

    public AbstractPowerSupplyRBS3CI(Rbs rbs) {
        super(rbs);
    }

    public boolean open() throws BemException {
        try {
            if (this.isOpen) {
                throw new BemException("AbstractPowerSupplyCI.open(): Already open");
            }
            this.initialiseResourceMgrs();
            this.createCustomerParameters();
            this.setDefaultValues();
            this.setRestrictions();
            this.updateLoadedBatteryValues();
            this.updateLoadedPowerSupplyValues();
            this.updateLoadedPSFanShelfValues();
            this.activateRestrictions();
            this.setListeners();
            this.isOpen = true;
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("AbstractPowerSupplyCI.open() got exception=" + exception.toString());
        }
        return true;
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = true;
        if (serviceValue.getValue(PrefixUtil.getFirstCabinetPrefix() + "noOfPsu") == null) {
            return false;
        }
        try {
            this.open();
            this.checkConsistency();
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("AbstractPowerSupplyCI.open(sv) got exception=" + exception.toString());
        }
        return bl;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String[] stringArray = new String[]{this.confBattBackupCustParam.getName(), this.battCapacityCustParam.getName(), this.confPowerSupplyCustParam.getName(), this.noOfPsuCustParam.getName(), this.confPowerShelfFanParam.getName()};
        super.setCustomerParametersFromSV(stringArray, serviceValue);
    }

    private void initialiseResourceMgrs() throws BemException {
        this.powerManager = this.getPowerManager();
        this.batteryManager = this.getBatteryManager();
        this.accuManager = this.getAccuManager();
        this.powerDistrManager = this.getPowerDistrManager();
    }

    private void createCustomerParameters() throws BemException {
        this.confPowerSupplyCustParam = new ConfigurePowerSupplyParameter();
        String string = PrefixUtil.getFirstCabinetPrefix() + "noOfPsu";
        this.noOfPsuCustParam = new NoOfPsuParameter(string, this.powerManager.getPsuRange());
        String string2 = PrefixUtil.getFirstCabinetPrefix() + "configureBatteryBackup";
        String string3 = PrefixUtil.getFirstCabinetPrefix() + "batteryCapacity";
        this.confBattBackupCustParam = new ConfigureBatteryBackupParameter(string2);
        this.battCapacityCustParam = new BatteryCapacityParameter(string3);
        this.confPowerShelfFanParam = new ConfPowerShelfFanParameter();
        this.addParameter(this.confPowerSupplyCustParam);
        this.addParameter(this.noOfPsuCustParam);
        this.addParameter(this.confBattBackupCustParam);
        this.addParameter(this.battCapacityCustParam);
        this.addParameter(this.confPowerShelfFanParam);
    }

    private void updateLoadedBatteryValues() throws BemException {
        boolean bl = this.batteryManager.isBatteryInstalled();
        if (bl) {
            this.confBattBackupCustParam.setLoadedValue("YES");
            String string = this.batteryManager.getBatteryCapacity();
            this.battCapacityCustParam.setLoadedValue(string);
            this.restrictionReadOnlyWhenBatteryInstalled.setActive(true);
            this.restrictionIgnoredBatteryCapacityWhenNoBattery.setActive(false);
        } else {
            this.restrictionReadOnlyWhenBatteryInstalled.setActive(false);
            this.confBattBackupCustParam.setLoadedValue("NO");
            this.restrictionIgnoredBatteryCapacityWhenNoBattery.setActive(true);
        }
        boolean bl2 = this.batteryManager.isBatterySupported();
        if (!bl2) {
            this.restrictionRangeWhenNoBatterySupport.setActive(true);
        } else {
            this.restrictionRangeWhenNoBatterySupport.setActive(false);
        }
    }

    private void updateLoadedPowerSupplyValues() throws BemException {
        boolean bl = this.powerManager.isPowerSupplyInstalled();
        if (bl) {
            this.confPowerSupplyCustParam.setLoadedValue("YES");
            this.restrictionReadOnlyWhenPowerSupplyInstalled.setActive(true);
            int n = this.powerManager.getInstalledNumberOfPsus();
            this.noOfPsuCustParam.setLoadedValue(String.valueOf(n));
        } else {
            this.confPowerSupplyCustParam.setLoadedValue("NO");
            this.restrictionReadOnlyWhenPowerSupplyInstalled.setActive(false);
            if (this.powerManager.isConfigurePowerSupplyMandatory()) {
                this.restrictionRangeYesWhenPowerSupplyMandatory.setActive(true);
            } else {
                this.restrictionRangeYesWhenPowerSupplyMandatory.setActive(false);
                this.restrictionOptional.setActive(true);
            }
        }
    }

    private void updateLoadedPSFanShelfValues() throws BemException {
        boolean bl = this.powerManager.isPowerSubrackFanInstalled();
        if (bl) {
            this.confPowerShelfFanParam.setLoadedValue("YES");
        } else {
            this.confPowerShelfFanParam.setLoadedValue("NO");
        }
    }

    private void setRestrictions() {
        this.restrictionRangeNoOfPsu = new ParameterRestriction("Cannot delete existing PSUs", this.powerManager.getPsuRange(), true);
        this.noOfPsuCustParam.addRestriction(this.restrictionIgnoredPSUWhenNoPowerSupply);
        this.noOfPsuCustParam.addRestriction(this.restrictionRangeNoOfPsu);
        this.confPowerSupplyCustParam.addRestriction(this.restrictionRangeYesWhenPowerSupplyMandatory);
        this.confPowerSupplyCustParam.addRestriction(this.restrictionReadOnlyWhenPowerSupplyInstalled);
        this.confPowerSupplyCustParam.addRestriction(this.restrictionOptional);
        this.confBattBackupCustParam.addRestriction(this.restrictionReadOnlyWhenBatteryInstalled);
        this.confBattBackupCustParam.addRestriction(this.restrictionIgnoredBatteryWhenNoPowerSupply);
        this.confBattBackupCustParam.addRestriction(this.restrictionRangeWhenNoBatterySupport);
        this.battCapacityCustParam.addRestriction(this.restrictionIgnoredBatteryCapacityWhenNoBattery);
        this.battCapacityCustParam.addRestriction(this.restrictionRangeForBatteryCapacity);
        this.confPowerShelfFanParam.addRestriction(this.restrictionIgnoredPSFANWhenNoPowerSupply);
    }

    public void activateRestrictions() throws BemException {
        String string = this.confPowerSupplyCustParam.getValue();
        if (string.equals("NO")) {
            this.restrictionIgnoredPSUWhenNoPowerSupply.setActive(true);
            this.restrictionIgnoredBatteryWhenNoPowerSupply.setActive(true);
            this.restrictionIgnoredPSFANWhenNoPowerSupply.setActive(true);
        } else {
            this.restrictionIgnoredPSUWhenNoPowerSupply.setActive(false);
            this.restrictionIgnoredBatteryWhenNoPowerSupply.setActive(false);
            this.restrictionIgnoredPSFANWhenNoPowerSupply.setActive(false);
        }
        int n = this.powerManager.getInstalledNumberOfPsus();
        if (n > 0) {
            Integer n2 = this.powerManager.getPsuRange().getMaxValue();
            Integer n3 = this.powerManager.getPsuRange().getMinValue();
            IntegerRange integerRange = new IntegerRange(n3, n2);
            this.restrictionRangeNoOfPsu.setRange(integerRange, true);
            this.restrictionRangeNoOfPsu.setActive(true);
        }
        this.restrictionRangeForBatteryCapacity.setActive(true);
    }

    public ArrayList getNeededRIs() throws BemException {
        ArrayList arrayList = this.getRIsToBeInstalled();
        return arrayList;
    }

    public String getName() {
        return name;
    }

    public ArrayList getRIsToBeInstalled() throws BemException {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = this.confPowerSupplyCustParam.getValue();
        bl = string.equalsIgnoreCase("YES");
        String string2 = this.confBattBackupCustParam.getValue();
        bl2 = string2.equalsIgnoreCase("YES");
        String string3 = this.confPowerShelfFanParam.getValue();
        bl3 = string3.equalsIgnoreCase("YES");
        String string4 = this.noOfPsuCustParam.getValue();
        n = Integer.parseInt(string4);
        String string5 = this.battCapacityCustParam.getValue();
        ArrayList arrayList = this.powerManager.getRIsToBeInstalled(bl, n, bl3);
        arrayList.addAll(this.batteryManager.getRIsToBeInstalled(bl2, string5));
        if (this.accuManager.isAccuSupported()) {
            arrayList.addAll(this.accuManager.getRIsToBeInstalled());
        }
        if (this.powerDistrManager.isPowerDistrSupported()) {
            arrayList.addAll(this.powerDistrManager.getRIsToBeInstalled());
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        ArrayList arrayList = new ArrayList(0);
        String string = this.noOfPsuCustParam.getValue();
        int n = Integer.parseInt(string);
        int n2 = this.powerManager.getInstalledNumberOfPsus();
        int n3 = n2 - n;
        if (n3 > 0) {
            arrayList = this.powerManager.getRIsToBeUnInstalled(n3);
        }
        return arrayList;
    }

    private void setListeners() {
        this.confPowerSupplyCustParam.addCustomerParameterListener(this);
        this.confBattBackupCustParam.addCustomerParameterListener(this);
    }

    protected void setDefaultValues() throws BemException {
        this.noOfPsuCustParam.setDefaultValue("1");
        this.confPowerSupplyCustParam.setDefaultValue("YES");
        this.confBattBackupCustParam.setDefaultValue("NO");
        this.confPowerShelfFanParam.setDefaultValue("NO");
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            boolean bl;
            String string = customerParameter.getName();
            String string2 = customerParameter.getValue();
            if (string.equalsIgnoreCase("configurePowerSupply")) {
                bl = string2.equalsIgnoreCase("YES");
                if (bl) {
                    this.restrictionIgnoredBatteryWhenNoPowerSupply.setActive(false);
                    this.restrictionIgnoredPSUWhenNoPowerSupply.setActive(false);
                    this.restrictionIgnoredPSFANWhenNoPowerSupply.setActive(false);
                } else {
                    this.restrictionIgnoredBatteryWhenNoPowerSupply.setActive(true);
                    this.clearCustomerParameters();
                    this.restrictionIgnoredPSUWhenNoPowerSupply.setActive(true);
                    this.restrictionIgnoredPSFANWhenNoPowerSupply.setActive(true);
                }
            }
            if (string.equalsIgnoreCase(this.confBattBackupCustParam.getName())) {
                bl = string2.equalsIgnoreCase("YES");
                if (bl) {
                    this.restrictionIgnoredBatteryCapacityWhenNoBattery.setActive(false);
                } else {
                    this.restrictionIgnoredBatteryCapacityWhenNoBattery.setActive(true);
                }
            }
        }
    }

    private void clearCustomerParameters() {
        this.confPowerSupplyCustParam.setValue("NO");
        this.confBattBackupCustParam.setValue("NO");
        this.noOfPsuCustParam.resetValue();
        this.battCapacityCustParam.resetValue();
        this.confPowerShelfFanParam.setValue("NO");
    }

    protected abstract PowerManager getPowerManager() throws BemException;

    protected abstract BatteryManager getBatteryManager() throws BemException;

    protected abstract AccuManager getAccuManager() throws BemException;

    protected PowerDistrManager getPowerDistrManager() throws BemException {
        return new PowerDistrManager(this.rbs, false, "", "");
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        return new ConfigurationCheckReport();
    }

    public boolean hasSupportControlUnit() {
        return false;
    }

    public boolean isSupportSystemAvailable() {
        return false;
    }

    public int getNumberOfHwGroup() throws BemException {
        throw new BemException("getNumberOfHwGroup() not implemented for AbstractPowerSupplyRBS3CI");
    }
}

