/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt;

import java.util.ArrayList;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractCableRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class RfCableDuwRI
extends AbstractCableRI {
    private static final String name = "RfCable";
    private String objectALdn;
    private BemMo objectAMo;
    private int objectAConnector;
    private String objectBLdn;
    private BemMo objectBMo;
    private int objectBConnector;
    private NalNameValue[] cableSetAttributes = null;
    private String ldn;
    private MoHandler moHandler = null;

    public RfCableDuwRI(Rbs rbs, String string, int n, String string2, int n2, NalNameValue[] nalNameValueArray, String string3) throws BemException {
        super(rbs, name);
        string = BemUtil.extractLdn(string, MimAuxPlugInUnit.MOTYPENAME);
        string2 = BemUtil.extractLdn(string2, MimAuxPlugInUnit.MOTYPENAME);
        this.objectALdn = string;
        this.objectAConnector = n;
        this.objectBLdn = string2;
        this.objectBConnector = n2;
        this.cableSetAttributes = nalNameValueArray;
        this.moHandler = rbs.getMoHandler();
        this.objectAMo = this.moHandler.getMo(string);
        this.objectBMo = this.moHandler.getMo(string2);
        this.ldn = BemLdn.LDN_EQUIPMENT + "," + MimRfCable.MOTYPENAME + "=" + string3;
    }

    public void install(String string) throws BemException {
        if (!string.equals("CabinetCableCreationPhase")) {
            return;
        }
        this.checkThatBothBoardsExists();
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        nalNameValue = Nal.getFactory().getNameValue("connectedToObjectARef", this.objectAMo);
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("connectedToObjectBRef", this.objectBMo);
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("objectAConnector", new Integer(this.objectAConnector));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("objectBConnector", new Integer(this.objectBConnector));
        vector.add(nalNameValue);
        this.createMoIfNotExisting(this.ldn, vector);
        NalNameValue[] nalNameValueArray = this.getChangedAttributes(this.cableSetAttributes);
        this.setAttributes(nalNameValueArray);
    }

    private void checkThatBothBoardsExists() throws BemException {
        boolean bl = false;
        String string = null;
        try {
            boolean bl2 = this.moHandler.isExisting(this.objectAMo);
            if (!bl2) {
                string = "ObjectA";
            } else {
                boolean bl3 = this.moHandler.isExisting(this.objectBMo);
                if (!bl3) {
                    string = "ObjectB";
                } else {
                    bl = true;
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Could not access node: " + moHandlerException);
        }
        if (!bl) {
            throw new BemException("RF cable: " + this.ldn + " could not be created, " + string + " does not exist.\n" + "Object A ldn: " + this.objectALdn + "\n" + "Object B ldn: " + this.objectBLdn);
        }
    }

    private NalNameValue[] getChangedAttributes(NalNameValue[] nalNameValueArray) throws BemException {
        ArrayList<NalNameValue> arrayList = new ArrayList<NalNameValue>();
        NalNameValue[] nalNameValueArray2 = null;
        BemMo bemMo = this.moHandler.getMo(this.ldn);
        try {
            if (nalNameValueArray != null) {
                int n;
                for (n = 0; n < nalNameValueArray.length; ++n) {
                    String string = nalNameValueArray[n].getName();
                    Object object = nalNameValueArray[n].getValue();
                    Object object2 = this.moHandler.getAttribute(bemMo, string);
                    if (object == null || object2 == null || object.toString().equals(object2.toString())) continue;
                    NalNameValue nalNameValue = Nal.getFactory().getNameValue(string, object);
                    arrayList.add(nalNameValue);
                }
                n = arrayList.size();
                if (n > 0) {
                    nalNameValueArray2 = new NalNameValue[n];
                    for (int i = 0; i < n; ++i) {
                        nalNameValueArray2[i] = (NalNameValue)arrayList.get(i);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new BemException("RfCableDuwRI.getChangedAttributes()", (Throwable)exception);
        }
        return nalNameValueArray2;
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("CabinetCableDeletionPhase")) {
            this.deleteMoIfNotExisting(this.ldn);
        }
    }

    private BemMo getObjectParent(BemMo bemMo) {
        BemMo bemMo2 = bemMo;
        if (bemMo.getDN().indexOf("PlugInUnit") != -1) {
            BemMo bemMo3;
            bemMo2 = bemMo3 = bemMo.getParent();
        }
        return bemMo2;
    }

    public String getDisplayName() {
        return "RfCable:" + this.ldn;
    }

    public String getLdn() {
        return this.ldn;
    }

    private void setAttributes(NalNameValue[] nalNameValueArray) throws BemException {
        if (nalNameValueArray == null) {
            return;
        }
        BemMo bemMo = this.moHandler.getMo(this.ldn);
        try {
            if (bemMo.isExisting()) {
                this.moHandler.setAttributes(bemMo, nalNameValueArray);
            }
        }
        catch (Exception exception) {
            throw new BemException("RfCableRI.setAttributes()", "setAttributes()", this.ldn, null, exception);
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = super.isInstalled();
        try {
            if (bl) {
                BemMo bemMo = this.moHandler.getMo(this.ldn);
                BemMo bemMo2 = (BemMo)this.moHandler.getAttribute(bemMo, "connectedToObjectARef");
                BemMo bemMo3 = this.getObjectParent(this.objectAMo);
                boolean bl2 = ((Object)bemMo2).equals(bemMo3);
                BemMo bemMo4 = (BemMo)this.moHandler.getAttribute(bemMo, "connectedToObjectBRef");
                BemMo bemMo5 = this.getObjectParent(this.objectBMo);
                boolean bl3 = ((Object)bemMo4).equals(bemMo5);
                bl = bl2 && bl3;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.getAction(), moHandlerException.getLdn(), (Throwable)moHandlerException);
        }
        return bl;
    }

    public String toString() {
        return "RfCable: connectedToObjectARef " + this.getObjectParent(this.objectAMo).getDN() + ", " + "objectAConnector" + " " + this.objectAConnector + ", " + "connectedToObjectBRef" + " " + this.getObjectParent(this.objectBMo) + ", " + "objectBConnector" + " " + this.objectBConnector;
    }
}

