/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntFeederCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntennaBranch;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimNodeBFunction;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class SectorUtil {
    private static final String[] SECTOR_RDN = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    private static final String AUTO_CREATED_RDNID_1 = "1";
    public static final int startingSectorNumberOnPDuw = 1;
    public static final int startingSectorNumberOnSDuw = 7;

    public static String[] getSectorRdn() {
        return SECTOR_RDN;
    }

    public static String getSectorLdn(int n) throws BemException {
        MoInstance moInstance = SectorUtil.getNodeBFunctionMoi();
        String string = SectorUtil.getSectorLdn(n, moInstance);
        return string;
    }

    public static String getSectorLdn(int n, MoInstance moInstance) throws BemException {
        String string = moInstance.getLdn() + "," + MimSector.MOTYPENAME + "=" + SECTOR_RDN[n - 1];
        return string;
    }

    private static MoInstance getNodeBFunctionMoi() throws BemException {
        try {
            RootMoi rootMoi = new RootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimNodeBFunction.MOTYPENAME, AUTO_CREATED_RDNID_1);
            return singleChildMoi;
        }
        catch (Exception exception) {
            throw new BemException("Can not read NodeBFunction MO", (Throwable)exception);
        }
    }

    public static int getSectorNumberFromSectorIndex(int n, int n2) {
        return n + n2;
    }

    public static int getSectorIndexFromSectorNumber(int n, int n2) {
        return n - n2;
    }

    public static String getSectorPrefix(ServiceNameValue serviceNameValue) {
        int n = serviceNameValue.getPrefix().indexOf("_");
        String string = serviceNameValue.getPrefix().substring(0, n + 1);
        return string;
    }

    public static String getCellPrefix(ServiceNameValue serviceNameValue) {
        int n = serviceNameValue.getPrefix().lastIndexOf("_");
        String string = serviceNameValue.getPrefix().substring(0, n + 1);
        return string;
    }

    public static int getSectorNumFromLdn(String string) {
        String string2 = "Sector=";
        int n = string.indexOf(string2);
        if (n == -1) {
            return -1;
        }
        int n2 = string.indexOf(",", n);
        if (n2 == -1) {
            return Integer.parseInt(string.substring(n + string2.length()));
        }
        return Integer.parseInt(string.substring(n + string2.length(), n2));
    }

    public static int getCarrierNumFromLdn(String string) {
        String string2 = "Carrier=";
        int n = string.indexOf(string2);
        if (n == -1) {
            return -1;
        }
        int n2 = string.indexOf(",", n);
        if (n2 == -1) {
            return Integer.parseInt(string.substring(n + string2.length()));
        }
        return Integer.parseInt(string.substring(n + string2.length(), n2));
    }

    public static Set getLoadedRruLdnUnderEquipmentBySector(Rbs rbs, int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        try {
            List list = SectorUtil.getAntFeederCable(rbs, n);
            for (int i = 0; i < list.size(); ++i) {
                BemMo bemMo = (BemMo)((BemMo)list.get(i)).getAttribute("connectedToObjectARef");
                if (bemMo == null || !bemMo.getType().equalsIgnoreCase(MimAuxPlugInUnit.MOTYPENAME)) continue;
                int n2 = (Integer)bemMo.getAttribute("auType");
                if (!bemMo.getParent().getType().equals(MimEquipment.MOTYPENAME) || n2 != 20) continue;
                treeSet.add(bemMo.getDN());
            }
        }
        catch (Exception exception) {
            Nal.getLog().nalTrace(1, SectorUtil.class, "getLoadedRruLdnUnderEquipmentBySector() :" + exception.getMessage());
        }
        return treeSet;
    }

    private static List getAntFeederCable(Rbs rbs, int n) throws BemException {
        List list = SectorUtil.getAntennaBranch(rbs, n);
        ArrayList<BemMo> arrayList = new ArrayList<BemMo>();
        for (int i = 0; i < list.size(); ++i) {
            BemMo[] bemMoArray = (BemMo[])((BemMo)list.get(i)).getAttribute("reservedBy");
            for (int j = 0; j < bemMoArray.length; ++j) {
                if (!bemMoArray[j].getType().equalsIgnoreCase(MimAntFeederCable.MOTYPENAME)) continue;
                arrayList.add(bemMoArray[j]);
            }
        }
        return arrayList;
    }

    private static List getAntennaBranch(Rbs rbs, int n) throws BemException {
        MoHandler moHandler = rbs.getMoHandler();
        ArrayList<BemMo> arrayList = new ArrayList<BemMo>();
        BemMo bemMo = moHandler.getMo(SectorUtil.getSectorLdn(n));
        BemMo[] bemMoArray = (BemMo[])bemMo.getAttribute("sectorAntennasRef");
        BemMo[] bemMoArray2 = null;
        for (int i = 0; i < bemMoArray.length; ++i) {
            bemMoArray2 = bemMoArray[i].getChildren();
            for (int j = 0; j < bemMoArray2.length; ++j) {
                if (!bemMoArray2[j].getType().equalsIgnoreCase(MimAntennaBranch.MOTYPENAME)) continue;
                arrayList.add(bemMoArray2[j]);
            }
        }
        return arrayList;
    }

    public static String[] getAllLoadedRruAuxPiuLdn(Rbs rbs) {
        MoHandler moHandler = rbs.getMoHandler();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BemMo bemMo = moHandler.getMo(rbs.getEquipmentMoi().getLdn());
            BemMo[] bemMoArray = null;
            String string = "auType==20";
            bemMoArray = moHandler.getChildren(bemMo, 1, MimAuxPlugInUnit.MOTYPENAME, string);
            if (bemMoArray != null) {
                for (int i = 0; i < bemMoArray.length; ++i) {
                    arrayList.add(bemMoArray[i].getDN());
                }
            }
        }
        catch (Exception exception) {
            Nal.getLog().nalTrace(1, SectorUtil.class, "getAllLoadedRrusAuxPiuLdn() :" + exception);
        }
        return arrayList.toArray(new String[0]);
    }

    public static int getExistingSectorMoNumber(Rbs rbs) throws BemException {
        int n = 0;
        MoHandler moHandler = rbs.getMoHandler();
        try {
            BemMo bemMo = moHandler.getMo(rbs.getNodeBFunctionMoi().getLdn());
            BemMo[] bemMoArray = moHandler.getChildren(bemMo, 1, MimSector.MOTYPENAME, "");
            if (bemMoArray != null) {
                n = bemMoArray.length;
            }
        }
        catch (Exception exception) {
            throw new BemException("Get existing Sector Mo Number failed:", (Throwable)exception);
        }
        return n;
    }

    private static boolean isRbbSupportDualSector(AbstractRbb abstractRbb) {
        return !abstractRbb.mustConfigRadioSharedBy() && abstractRbb.supportsRadioSharedBy();
    }

    public static boolean isPositionConfigurationSupported(Rbs rbs, int n) throws BemException {
        RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
        if (!(radioEquipmentProvider instanceof RbbManager)) {
            return true;
        }
        RbbManager rbbManager = (RbbManager)rbs.getRadioEquipmentProvider();
        AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n);
        String string = abstractRbb.getRadioSharedBySector();
        if (!SectorUtil.isRbbSupportDualSector(abstractRbb) || string.equals("")) {
            return true;
        }
        int n2 = Integer.parseInt(string);
        return n <= n2;
    }

    public static boolean isRrus32WithRbb441d(Rbs rbs, int n) {
        boolean bl = false;
        RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)rbs.getProvider(RadioEquipmentProviderWithRbb.class);
        if (radioEquipmentProviderWithRbb != null && radioEquipmentProviderWithRbb.getAuUnitType(n) != null && radioEquipmentProviderWithRbb.getAuUnitType(n).equals("RRUWRRUS") && radioEquipmentProviderWithRbb.getRbbName(n).equalsIgnoreCase("RBB44_1D")) {
            bl = true;
        }
        return bl;
    }

    public static int getSectorAntennaNumberWithRetCascading(Rbs rbs, int n) {
        return SectorUtil.isRrus32WithRbb441d(rbs, n) ? 2 : 1;
    }

    public static String getSectorPrefix(int n) {
        String string = MessageFormat.format("S{0}_", new Integer(n));
        return string;
    }

    public static boolean isIRUInEnclosure(Rbs rbs, int n) {
        BemMo bemMo;
        String string = BemLdn.LDN_EQUIPMENT + "," + MimAuxPlugInUnit.MOTYPENAME + "=" + "IRU" + "-" + n + "-1";
        BemMo bemMo2 = rbs.getMoHandler().getMo(string);
        return bemMo2.isExisting() && (null == (bemMo = (BemMo)bemMo2.getAttribute("positionRef")) || null == bemMo.getDN() || bemMo.getDN().equals(""));
    }

    public static boolean isDualBand(Rbs rbs, int n) {
        boolean bl = false;
        int n2 = 0;
        if (rbs.isPantherHybridRbs() && n >= 7) {
            n2 = 1;
        }
        try {
            CellAndCarrierCI cellAndCarrierCI = (CellAndCarrierCI)rbs.getCellAndCarrierProvider(n2);
            if (cellAndCarrierCI != null) {
                bl = cellAndCarrierCI.isDualBand(n);
            }
        }
        catch (BemException bemException) {
            Nal.getLog().nalTraceError(SectorUtil.class, "Failed to get CellAndCarrierProvider", bemException);
        }
        return bl;
    }
}

