/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3116duwxcu.configitem;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.AbstractPowerSupplyCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.BfuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.CluRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRbsSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;

public class PowerSupply3116DuwXcuCI
extends AbstractPowerSupplyCI {
    private static final int[] PSU_SLOTS = new int[]{2, 3, 4};
    private static final int BFU_SLOT = 1;
    private static final IntegerRange PSU_RANGE = new IntegerRange(new Integer(1), new Integer(3));
    private static final String POWER_SUBRACK_CABINET_POSITION = "1";
    private static final String POWER_SUBRACK_POSITION = "1B1";
    private static final int AU_HUB_TYPE = 1;
    private ArrayList resources;

    public PowerSupply3116DuwXcuCI(Rbs rbs) {
        super(rbs, 1);
        this.fcuConfigurable = true;
        super.setPsuSlots(PSU_SLOTS);
        super.setBfuSlot(1);
        this.cabinetParameters = new Integer[50];
        for (int i = 0; i < 50; ++i) {
            this.cabinetParameters[i] = new Integer(0);
        }
        this.cabinetParameters[0] = new Integer(1);
        this.cabinetParameters[1] = new Integer(3);
        this.cabinetParameters[2] = new Integer(67);
        this.cabinetParameters[3] = new Integer(70);
        this.cabinetParameters[4] = new Integer(20);
        this.cabinetParameters[5] = new Integer(0);
        this.cabinetParameters[6] = new Integer(0);
        this.cabinetParameters[7] = new Integer(0);
        this.cabinetParameters[11] = new Integer(6);
        this.cabinetParameters[12] = new Integer(40);
        this.cabinetParameters[13] = new Integer(5);
        this.cabinetParameters[14] = new Integer(90);
        this.cabinetParameters[15] = new Integer(5);
        this.cabinetParameters[16] = new Integer(75);
        this.cabinetParameters[17] = new Integer(75);
    }

    protected void setDefaultParameterValues() throws BemException {
        this.noPsuCustParam.setDefaultValue(POWER_SUBRACK_CABINET_POSITION);
        this.confPowerSupplyCustParam.setDefaultValue("YES");
        this.confPowerSupplyCustParam.setValue("YES");
        this.confBatteryBackupCustParam.setDefaultValue("NO");
    }

    protected IntegerRange getPsuRange() {
        return PSU_RANGE;
    }

    protected boolean isInternalPowerSupplyMandatory() {
        return false;
    }

    protected boolean hasInternalBatteryBackup() {
        return true;
    }

    protected String getPowerSubrackPosition() {
        return POWER_SUBRACK_POSITION;
    }

    protected String getPowerSubrackCabinetPosition() {
        return POWER_SUBRACK_CABINET_POSITION;
    }

    protected AbstractRbsSubrackRI getPsSubrackRI() {
        return this.powerSupplySubrackRI;
    }

    protected AbstractRbsSubrackRI getBfSubrackRI() {
        return this.powerSupplySubrackRI;
    }

    protected void createBfSubrackRI(MoInstance moInstance) {
    }

    protected void createBfuRIs() throws BemException {
        MoInstance moInstance = this.powerSupplySubrackRI.getMoiSlot(1);
        this.bfuRI = new BfuRI(this.getRbs(), 1, moInstance);
    }

    protected void createCluRI() throws BemException {
        this.cluRI = new CluRI(super.getRbs());
    }

    public ArrayList getNeededRIs() throws BemException {
        this.resources = super.getNeededRIs();
        this.resources.add(this.cluRI);
        return this.resources;
    }
}

