/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.exception;

import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperty;

public abstract class PrintBuffer {
    protected final StringBuffer buffer = new StringBuffer();

    abstract void printTitle(String var1);

    abstract void printKey(String var1);

    abstract void printValue(String var1);

    void print(ExceptionProperty exceptionProperty) {
        this.printKey(exceptionProperty.key);
        this.printValue(exceptionProperty.value);
    }

    void print(ExceptionProperty.Iterator iterator) {
        if (!iterator.isEmpty()) {
            this.printTitle(iterator.getTitle());
            while (iterator.hasNext()) {
                this.print(iterator.next());
            }
        }
    }

    void print(ExceptionProperty.Iterators iterators) {
        while (iterators.hasNext()) {
            this.print(iterators.next());
        }
    }

    void printIndented(String string, String string2) {
        if (string != null && !string.equals("")) {
            int n = string.indexOf(10);
            if (n == -1) {
                this.buffer.append(string);
            } else {
                int n2 = string.length() + 10 * string2.length();
                StringBuffer stringBuffer = new StringBuffer(n2);
                stringBuffer.append(string);
                int n3 = n;
                while (n3 != -1) {
                    stringBuffer.insert(n3 + 1, string2);
                    n3 = stringBuffer.indexOf("\n", n3 + string2.length());
                }
                this.buffer.append(stringBuffer);
            }
        }
    }

    void printRightPadded(String string, char c, int n) {
        int n2 = this.buffer.length() + n;
        this.buffer.append(string).append(c);
        while (this.buffer.length() < n2) {
            this.buffer.append(c);
        }
    }

    void print(String string) {
        this.buffer.append(string);
    }

    void print(StringBuffer stringBuffer) {
        this.buffer.append(stringBuffer);
    }

    public int length() {
        int n = this.buffer.length();
        return n;
    }

    public String toString() {
        String string = this.buffer.toString();
        return string;
    }

    public static class ExceptionMessage
    extends PrintBuffer {
        static final String STACKDUMP_KEY_INDENTION = "   ";
        int keyWidth = 16;

        void printTitle(String string) {
        }

        void printKey(String string) {
            this.print("\n");
            this.print(STACKDUMP_KEY_INDENTION);
            this.printRightPadded(string, ' ', this.keyWidth);
            this.print(": ");
        }

        void printValue(String string) {
            this.printIndented(string, "      ");
        }

        void print(ExceptionProperty.Iterator iterator) {
            if (!iterator.isEmpty()) {
                int n = iterator.maxKeyLength() + 1;
                if (this.keyWidth < n) {
                    this.keyWidth = n;
                }
                while (iterator.hasNext()) {
                    this.print(iterator.next());
                }
            }
        }
    }

    public static class Details
    extends ErrorPopUp {
        void printTitle(String string) {
            this.print("\n\n ");
            this.print(string);
            this.print("\n ");
            this.printRightPadded("", '=', string.length());
        }

        void print(ExceptionProperty exceptionProperty) {
            if ("Jar file revisions".equals(exceptionProperty.key)) {
                exceptionProperty.value = exceptionProperty.value.trim();
            }
            super.print(exceptionProperty);
        }
    }

    public static class ErrorPopUp
    extends PrintBuffer {
        static final String POPUP_VALUE_INDENTION = "    ";

        void printTitle(String string) {
        }

        void printKey(String string) {
            this.print("\n\n ");
            this.print(string);
            this.print(":");
        }

        void printValue(String string) {
            this.print("\n");
            this.print(POPUP_VALUE_INDENTION);
            this.printIndented(string, POPUP_VALUE_INDENTION);
        }

        void print(ExceptionProperty.Iterator iterator) {
            if (!iterator.isEmpty()) {
                super.print(iterator);
                if (this.buffer.charAt(this.buffer.length() - 1) != '\n') {
                    this.print("\n");
                }
            }
        }
    }
}

