/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common;

import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;

public class MoDistinguishedNameParser {
    static final String RDN_SEPARATOR = ",";
    static final String VALUE_SEPARATOR = "=";

    public static String getNamingAttributeValue(String dName) {
        String namingValue = null;
        int startPos = dName.lastIndexOf(VALUE_SEPARATOR);
        if (startPos != -1) {
            namingValue = dName.substring(startPos + 1);
            return namingValue;
        }
        return null;
    }

    public static String getMoTypeName(String dName) {
        int startPos = dName.lastIndexOf(RDN_SEPARATOR);
        int endPos = dName.lastIndexOf(VALUE_SEPARATOR);
        startPos = startPos < 0 ? 0 : ++startPos;
        if (endPos != -1) {
            String namingValue = dName.substring(startPos, endPos);
            return namingValue;
        }
        return null;
    }

    public static boolean isEmpty(String intAttr) {
        return intAttr == null || intAttr.length() == 0;
    }

    public static String getRelativeDistinguishedName(String source) {
        if (MoDistinguishedNameParser.isEmpty(source)) {
            MessageLog.traceError(MoDistinguishedNameParser.class, "getRelativeDistinguishedName(), The input ldn is null/empty!!");
            return source;
        }
        if (source.indexOf(VALUE_SEPARATOR) == source.lastIndexOf(VALUE_SEPARATOR)) {
            return source;
        }
        int startPos = source.lastIndexOf(RDN_SEPARATOR);
        if (startPos != -1) {
            String rdn = source.substring(startPos + 1);
            return rdn;
        }
        return null;
    }

    public static String getLdnStartFromtType(String source, String typeName) {
        if (MoDistinguishedNameParser.isEmpty(source) || MoDistinguishedNameParser.isEmpty(typeName) || source.indexOf(typeName + VALUE_SEPARATOR) < 0) {
            MessageLog.traceError(MoDistinguishedNameParser.class, "getLdnStartFromtType(), Some input is null/empty!!");
            return source;
        }
        int startIndex = source.indexOf(typeName);
        return source.substring(startIndex, source.length());
    }

    public static String getParentLdn(String source, String typeName) {
        if (MoDistinguishedNameParser.isEmpty(source) || MoDistinguishedNameParser.isEmpty(typeName) || source.indexOf(typeName + VALUE_SEPARATOR) < 0) {
            MessageLog.traceError(MoDistinguishedNameParser.class, "getParentLdn(), Some input is null/empty!!");
            return source;
        }
        if (source.indexOf(typeName + VALUE_SEPARATOR) == 0) {
            return "";
        }
        typeName = typeName + VALUE_SEPARATOR;
        int endIndex = source.indexOf(typeName);
        return source.substring(0, endIndex - 1);
    }
}

