/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.generic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.ReflectUtil;
import se.ericsson.wcdma.rbs.boam.common.generic.GenericConstant;
import se.ericsson.wcdma.rbs.boam.common.generic.GenericMOContext;
import se.ericsson.wcdma.rbs.boam.common.generic.LicFeatureAdaptor;
import se.ericsson.wcdma.rbs.boam.common.generic.LicenseFeatureDataMap;
import se.ericsson.wcdma.rbs.boam.common.generic.MOAttributeMetadata;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationFailedException;

public class GenericMOManager {
    private static final GenericMOManager INSTANCE = new GenericMOManager();
    private static final Integer ZERO = new Integer(0);
    private LicenseFeatureDataMap licFeatureData = new LicenseFeatureDataMap();

    private GenericMOManager() {
    }

    public static GenericMOManager getManager() {
        return INSTANCE;
    }

    public static GenericMOContext obtainContext(Coordinator trans) {
        return new GenericMOContext(trans);
    }

    public MOAttributeMetadata getMOMetadata(String attrName) {
        MOAttributeMetadata moMetadata = this.licFeatureData.get(attrName.toLowerCase(Locale.ENGLISH));
        if (moMetadata == null) {
            return GenericConstant.UNKNOW_ATTRIBUTE;
        }
        return moMetadata;
    }

    public String[] getAttributeName() {
        return this.licFeatureData.getAttributeName();
    }

    public boolean couldHandleGetter(String attrName) {
        if (attrName == null) {
            return false;
        }
        if (attrName.startsWith("pm")) {
            return true;
        }
        MOAttributeMetadata metadata = this.getMOMetadata(attrName);
        return metadata != null && metadata != GenericConstant.UNKNOW_ATTRIBUTE;
    }

    public boolean couldHandleSetter(String attrName) {
        if (attrName == null) {
            return false;
        }
        MOAttributeMetadata metadata = this.getMOMetadata(attrName);
        if (metadata != null && metadata != GenericConstant.UNKNOW_ATTRIBUTE) {
            return metadata.isFeatureAttribute();
        }
        return false;
    }

    public Object invokeAttributeGetter(Object target, String attrName, GenericMOContext genericContext) throws MoAccessException {
        if (attrName.startsWith("pm")) {
            Method method = null;
            Object[] params = new Object[1];
            method = ReflectUtil.findMethod(target.getClass(), "getScannerValue");
            params[0] = attrName;
            try {
                Class<?> returnType;
                Object result2 = method.invoke(target, params);
                if (!(result2 != null && result2 instanceof int[] || ManagedObject.class.isAssignableFrom(returnType = method.getReturnType()))) {
                    Assert.cppAssert((boolean)false, (String)("Only MO get access methods that returns an MO are allowed to return null, returntype :" + returnType + " method :" + method));
                    return null;
                }
                int[] tmpInt = (int[])result2;
                if (1 == tmpInt.length) {
                    return new Integer(tmpInt[0]);
                }
                return result2;
            }
            catch (IllegalArgumentException e) {
                throw new OperationFailedException("Attribute: " + attrName + " is not supported, " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new OperationFailedException("Attribute: " + attrName + " is not supported, " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new OperationFailedException("Attribute: " + attrName + " is not supported, " + e.getMessage());
            }
        }
        if (target instanceof LicFeatureAdaptor) {
            MOAttributeMetadata.LicFeatureMetadata attrDef = (MOAttributeMetadata.LicFeatureMetadata)this.getMOMetadata(attrName);
            if (attrDef.isZeroDelivery()) {
                return ZERO;
            }
            Object info = ((LicFeatureAdaptor)target).getFeatureAndLicenseState(attrDef, genericContext);
            try {
                return ReflectUtil.invokeGetAttribute(info, attrDef.getNameInSignal());
            }
            catch (Exception e) {
                throw new OperationFailedException("Attribute: " + attrName + " is not supported, " + e.getMessage());
            }
        }
        throw new OperationFailedException("Attribute: " + attrName + " is not supported.");
    }

    public void invokeAttributeSetter(ManagedObject target, String attrName, Object value, GenericMOContext genericContext) throws MoAccessException {
        MOAttributeMetadata.LicFeatureMetadata attrDef;
        if (target instanceof LicFeatureAdaptor) {
            attrDef = (MOAttributeMetadata.LicFeatureMetadata)this.getMOMetadata(attrName);
            if (attrDef.isZeroDelivery()) {
                return;
            }
        } else {
            throw new OperationFailedException("Attribute: " + attrName + " is not supported.");
        }
        ((LicFeatureAdaptor)target).setFeatureState(attrDef, (Integer)value, genericContext);
    }
}

