/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsTmfDataTypeT;

public class EcGetTmasParamRspS
extends UnlinkedSignal {
    public static final int SIG_NO = 16815396;
    public long clientId;
    public int result;
    public int errorCode;
    public long dlAttenuation;
    public long dlDelay;
    public long ulDelay;
    public RbsTmfDataTypeT tmfData = new RbsTmfDataTypeT();
    public String tmfFilePath = "";
    public String tmfFileName = "";
    public long[] bandsOfAtma = new long[2];
    public long[] dlAttenuationPerBand = new long[2];
    public long[] dlTrafficDelayPerBand = new long[2];
    public long[] ulTrafficDelayPerBand = new long[2];

    public EcGetTmasParamRspS() {
        super(16815396);
    }

    public EcGetTmasParamRspS(long clientId, int result2, int errorCode, long dlAttenuation, long dlDelay, long ulDelay, RbsTmfDataTypeT tmfData, String tmfFilePath, String tmfFileName, long[] bandsOfAtma, long[] dlAttenuationPerBand, long[] dlTrafficDelayPerBand, long[] ulTrafficDelayPerBand) {
        super(16815396);
        this.clientId = clientId;
        this.result = result2;
        this.errorCode = errorCode;
        this.dlAttenuation = dlAttenuation;
        this.dlDelay = dlDelay;
        this.ulDelay = ulDelay;
        this.tmfData = tmfData;
        this.tmfFilePath = tmfFilePath;
        this.tmfFileName = tmfFileName;
        this.bandsOfAtma = bandsOfAtma;
        this.dlAttenuationPerBand = dlAttenuationPerBand;
        this.dlTrafficDelayPerBand = dlTrafficDelayPerBand;
        this.ulTrafficDelayPerBand = ulTrafficDelayPerBand;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.result = in.readS32();
            this.errorCode = in.readS32();
            this.dlAttenuation = in.readU32();
            this.dlDelay = in.readU32();
            this.ulDelay = in.readU32();
            this.tmfData.airCarrier = in.readU16();
            this.tmfData.feederCarrier = in.readU16Array(2);
            this.tmfData.ifBandwidth = in.readU16();
            this.tmfData.ulDelay = in.readU16Array(2);
            this.tmfData.dlDelay = in.readU16Array(2);
            this.tmfFilePath = Strings.toString(in.readS8Array(200));
            this.tmfFileName = Strings.toString(in.readS8Array(36));
            this.bandsOfAtma = in.readU32Array(2);
            this.dlAttenuationPerBand = in.readU32Array(2);
            this.dlTrafficDelayPerBand = in.readU32Array(2);
            this.ulTrafficDelayPerBand = in.readU32Array(2);
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initReceive failed in EcGetTmasParamRspS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeU32(this.clientId);
            out.writeS32(this.result);
            out.writeS32(this.errorCode);
            out.writeU32(this.dlAttenuation);
            out.writeU32(this.dlDelay);
            out.writeU32(this.ulDelay);
            out.writeU16(this.tmfData.airCarrier);
            out.writeU16Array(this.tmfData.feederCarrier);
            out.writeU16(this.tmfData.ifBandwidth);
            out.writeU16Array(this.tmfData.ulDelay);
            out.writeU16Array(this.tmfData.dlDelay);
            out.writeS8Array(Strings.getBytes(this.tmfFilePath, 200));
            out.writeS8Array(Strings.getBytes(this.tmfFileName, 36));
            out.writeU32Array(this.bandsOfAtma);
            out.writeU32Array(this.dlAttenuationPerBand);
            out.writeU32Array(this.dlTrafficDelayPerBand);
            out.writeU32Array(this.ulTrafficDelayPerBand);
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initSend failed in EcGetTmasParamRspS: " + e));
        }
    }
}

