/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;

public class RbsLmIdT {
    private static final Class SELF = RbsLmIdT.class;
    public String lmFilePath;
    public String lmFileName;
    public int lmFileSize;
    public String lmProductNumber;
    public String lmProductRevision;
    public String hwProductNumber;
    public String hwProductRevision;

    public RbsLmIdT(String lmFilePath, String lmFileName, int lmFileSize, String lmProductNumber, String lmProductRevision, String hwProductNumber, String hwProductRevision) throws SoftwareErrorException {
        this(lmProductNumber, lmProductRevision, hwProductNumber, hwProductRevision, lmFilePath, lmFileName, lmFileSize);
        RbsLmIdT.checkParameterLength("file path", lmFilePath, 200);
        RbsLmIdT.checkParameterLength("file name", lmFileName, 36);
        RbsLmIdT.checkParameterLength("LM prod number", lmProductNumber, 25);
        RbsLmIdT.checkParameterLength("LM prod rev", lmProductRevision, 8);
        RbsLmIdT.checkParameterLength("HW prod number", hwProductNumber, 25);
        RbsLmIdT.checkParameterLength("HW prod rev", hwProductRevision, 8);
    }

    public RbsLmIdT(String lmProductNumber, String lmProductRevision, String hwProductNumber, String hwProductRevision, String lmFilePath, String lmFileName, int lmFileSize) {
        this.lmFilePath = lmFilePath;
        this.lmFileName = lmFileName;
        this.lmFileSize = lmFileSize;
        this.lmProductNumber = lmProductNumber;
        this.lmProductRevision = lmProductRevision;
        this.hwProductNumber = hwProductNumber;
        this.hwProductRevision = hwProductRevision;
    }

    private static void checkParameterLength(String name, String value, int maxSize) throws SoftwareErrorException {
        if (value.length() >= maxSize) {
            MessageLog.traceError(SELF, "size of " + name + " '" + value + "' exceeds " + (maxSize - 1));
            throw new SoftwareErrorException();
        }
    }
}

