/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies;

import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGpehEventS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGpehScanActReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGpehScanCleanupReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGpehScanSuspReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGpehWriteFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGpehWriteFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcSubscGpehReqS;

public class NcGpehScannerProxy
extends NcGenericProxy {
    private static NcGpehScannerProxy INSTANCE = null;
    private static final String SERVICE_NAME = "bcNmGpehHandler";

    private NcGpehScannerProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "Constructor");
        this.boamSignalPort.addSignalObserver(this, BcGpehWriteFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, BcGpehWriteFaultCeaseIndS.class);
    }

    public static synchronized NcGpehScannerProxy instance() {
        if (INSTANCE == null) {
            INSTANCE = new NcGpehScannerProxy();
        }
        return INSTANCE;
    }

    public void activateScanner(int clientId, int maxStorageSize, int maxFileSize, String meUserLabel, String meLogicalName, int numberOfGpehEvents, BcGpehEventS[] gpehEvent, String gpehFileLocation) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "activateScanner()");
        BcGpehScanActReqS reqSig = new BcGpehScanActReqS(clientId, maxStorageSize, maxFileSize, meUserLabel, meLogicalName, numberOfGpehEvents, gpehEvent, gpehFileLocation);
        this.sendAndRec(reqSig);
    }

    public void suspendScanner(int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "susependScanner()");
        BcGpehScanSuspReqS reqSig = new BcGpehScanSuspReqS(clientId);
        this.sendAndRec(reqSig);
    }

    public void cleanup(int clientId, String fileLocation) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "cleanup()");
        BcGpehScanCleanupReqS reqSig = new BcGpehScanCleanupReqS(clientId, fileLocation);
        this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification()");
        boolean clientId = false;
        try {
            BcSubscGpehReqS reqSig = new BcSubscGpehReqS(0, 0, this.signalPort.getServiceName());
            this.sendAndRec(reqSig);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }
}

