/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.alarm;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import se.ericsson.cello.support.debug.MessageLog;

public class SwErrorLogHelper {
    private static int MAX_LOG_FILE_LENGTH = 0x200000;
    private static int MAX_LOG_FILE_ROTATE = 3;
    private static String SW_ERROR_LOG_PREFIX = "SwErrorAlarmLog";
    private static String SW_ERROR_LOG_SUFFIX = ".txt";
    private static String SW_ERROR_LOG_UNDERLINE = "_";

    public static void writeLog(String logPath, String logContent) {
        File[] logFiles;
        MessageLog.traceEnter((Class)SwErrorLogHelper.class, (String)"writeLog()");
        File logPathFile = new File(logPath);
        if (!logPathFile.exists()) {
            if (logPathFile.mkdirs()) {
                MessageLog.trace((int)9, (Class)SwErrorLogHelper.class, (String)("File: " + logPathFile.getAbsolutePath() + " created successfully"));
            } else {
                MessageLog.traceError((Class)SwErrorLogHelper.class, (String)("Failed to create file folder: " + logPathFile.getAbsolutePath()));
                return;
            }
        }
        if (null == (logFiles = logPathFile.listFiles())) {
            return;
        }
        if (0 == logFiles.length) {
            SwErrorLogHelper.createLogFileWithTime(logPathFile);
            logFiles = logPathFile.listFiles();
        }
        SwErrorLogHelper.cleanUselessFile(logFiles, logPathFile);
        logFiles = logPathFile.listFiles();
        File newestFile = SwErrorLogHelper.getNewestFile(logFiles);
        if (newestFile.length() + (long)logContent.length() > (long)MAX_LOG_FILE_LENGTH) {
            if (logFiles.length < MAX_LOG_FILE_ROTATE) {
                SwErrorLogHelper.createLogFileWithTime(logPathFile);
            } else {
                File oldestFile = SwErrorLogHelper.getOldestFile(logFiles);
                if (oldestFile.delete()) {
                    MessageLog.trace((int)9, (Class)SwErrorLogHelper.class, (String)("File: " + oldestFile.getAbsolutePath() + " deleted"));
                }
                SwErrorLogHelper.createLogFileWithTime(logPathFile);
            }
            logFiles = logPathFile.listFiles();
            newestFile = SwErrorLogHelper.getNewestFile(logFiles);
        }
        SwErrorLogHelper.appendLog2File(newestFile, logContent);
    }

    private static void createLogFileWithTime(File logPathFile) {
        MessageLog.traceEnter((Class)SwErrorLogHelper.class, (String)"createLogFileWithTime()");
        StringBuffer fileName = new StringBuffer();
        fileName.append(SW_ERROR_LOG_PREFIX).append(SW_ERROR_LOG_UNDERLINE).append(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())).append(SW_ERROR_LOG_SUFFIX);
        File logFile = new File(logPathFile, fileName.toString());
        if (!logFile.exists()) {
            try {
                if (logFile.createNewFile()) {
                    MessageLog.trace((int)9, (Class)SwErrorLogHelper.class, (String)("File: " + logFile.getAbsolutePath() + " created successfully"));
                }
            }
            catch (IOException e) {
                MessageLog.traceError((Class)SwErrorLogHelper.class, (String)("Failed to create file: " + logFile.getAbsolutePath() + " due to " + e));
            }
        }
    }

    private static void cleanUselessFile(File[] logFiles, File logPathFile) {
        MessageLog.traceEnter((Class)SwErrorLogHelper.class, (String)"cleanUselessFile()");
        for (int i = 0; i < logFiles.length; ++i) {
            if (!logFiles[i].exists() || logFiles[i].getName().startsWith(SW_ERROR_LOG_PREFIX + SW_ERROR_LOG_UNDERLINE) && logFiles[i].getName().endsWith(SW_ERROR_LOG_SUFFIX) || !logFiles[i].delete()) continue;
            MessageLog.trace((int)9, (Class)(class$se$ericsson$wcdma$rbs$boam$mao$alarm$SwErrorLogHelper == null ? SwErrorLogHelper.class$("se.ericsson.wcdma.rbs.boam.mao.alarm.SwErrorLogHelper") : class$se$ericsson$wcdma$rbs$boam$mao$alarm$SwErrorLogHelper), (String)("File: " + logFiles[i].getAbsolutePath() + " deleted"));
        }
        logFiles = logPathFile.listFiles();
        while (logFiles.length > MAX_LOG_FILE_ROTATE) {
            File oldestFile = SwErrorLogHelper.getOldestFile(logFiles);
            if (oldestFile.delete()) {
                MessageLog.trace((int)9, (Class)(class$se$ericsson$wcdma$rbs$boam$mao$alarm$SwErrorLogHelper == null ? SwErrorLogHelper.class$("se.ericsson.wcdma.rbs.boam.mao.alarm.SwErrorLogHelper") : class$se$ericsson$wcdma$rbs$boam$mao$alarm$SwErrorLogHelper), (String)("File: " + oldestFile.getAbsolutePath() + " deleted"));
            }
            logFiles = logPathFile.listFiles();
        }
    }

    private static File getNewestFile(File[] logFiles) {
        File newestFile = null;
        long[] fileLastModifiedTime = SwErrorLogHelper.sortFileLastModiTime(logFiles);
        for (int i = 0; i < logFiles.length; ++i) {
            if (fileLastModifiedTime[fileLastModifiedTime.length - 1] != logFiles[i].lastModified()) continue;
            newestFile = logFiles[i];
        }
        return newestFile;
    }

    private static File getOldestFile(File[] logFiles) {
        File oldestFile = null;
        long[] fileLastModifiedTime = SwErrorLogHelper.sortFileLastModiTime(logFiles);
        for (int i = 0; i < logFiles.length; ++i) {
            if (fileLastModifiedTime[0] != logFiles[i].lastModified()) continue;
            oldestFile = logFiles[i];
        }
        return oldestFile;
    }

    private static long[] sortFileLastModiTime(File[] logFiles) {
        long[] fileLastModifiedTime = new long[logFiles.length];
        for (int i = 0; i < logFiles.length; ++i) {
            fileLastModifiedTime[i] = logFiles[i].lastModified();
        }
        Arrays.sort(fileLastModifiedTime);
        return fileLastModifiedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void appendLog2File(File file, String logContent) {
        block11: {
            MessageLog.traceEnter((Class)SwErrorLogHelper.class, (String)"appendLog2File()");
            BufferedWriter bw = null;
            bw = new BufferedWriter(new FileWriter(file, true));
            bw.write(logContent);
            bw.flush();
            Object var5_3 = null;
            try {
                if (null != bw) {
                    bw.close();
                    bw = null;
                }
                break block11;
            }
            catch (IOException ie2) {
                MessageLog.traceError((Class)SwErrorLogHelper.class, (String)("Failed to close stream due to " + ie2));
            }
            break block11;
            {
                catch (IOException ie) {
                    MessageLog.traceError((Class)SwErrorLogHelper.class, (String)("Failed to write log due to " + ie));
                    Object var5_4 = null;
                    try {
                        if (null != bw) {
                            bw.close();
                            bw = null;
                        }
                        break block11;
                    }
                    catch (IOException ie2) {
                        MessageLog.traceError((Class)SwErrorLogHelper.class, (String)("Failed to close stream due to " + ie2));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (null != bw) {
                        bw.close();
                        bw = null;
                    }
                }
                catch (IOException ie2) {
                    MessageLog.traceError((Class)SwErrorLogHelper.class, (String)("Failed to close stream due to " + ie2));
                }
                throw throwable;
            }
        }
    }

    public static String getInfo(String sourceString, String startFlag, String endFlag) {
        int endIndex;
        String info = "";
        int beginIndex = sourceString.indexOf(startFlag);
        if (beginIndex > -1 && (endIndex = sourceString.indexOf(endFlag, beginIndex)) > -1) {
            info = sourceString.substring(beginIndex + startFlag.length(), endIndex);
        }
        return info;
    }
}

