/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.geo;

public class GpsPosition {
    public static final double earthRadius = 6378100.0;
    private final double latitude;
    private final double longitude;
    private final double altitude;
    private final boolean hasAltitude;

    public GpsPosition(double _latitude, double _longitude, double _altitude) {
        this.latitude = _latitude;
        this.longitude = _longitude;
        this.altitude = _altitude;
        this.hasAltitude = true;
    }

    public GpsPosition(double _latitude, double _longitude) {
        this.latitude = _latitude;
        this.longitude = _longitude;
        this.altitude = 0.0;
        this.hasAltitude = false;
    }

    public boolean allValuesZero() {
        return GpsPosition.distanceSquared(this, new GpsPosition(0.0, 0.0, 0.0)) < 1.0E-4;
    }

    public static double distanceSquared(GpsPosition a, GpsPosition b) {
        double radiusB;
        double radiusA;
        double cosLatA = Math.cos(Math.toRadians(a.latitude));
        double sinLatA = Math.sin(Math.toRadians(a.latitude));
        double cosLongA = Math.cos(Math.toRadians(a.longitude));
        double sinLongA = Math.sin(Math.toRadians(a.longitude));
        double cosLatB = Math.cos(Math.toRadians(b.latitude));
        double sinLatB = Math.sin(Math.toRadians(b.latitude));
        double cosLongB = Math.cos(Math.toRadians(b.longitude));
        double sinLongB = Math.sin(Math.toRadians(b.longitude));
        if (a.hasAltitude && b.hasAltitude) {
            radiusA = 6378100.0 + a.altitude;
            radiusB = 6378100.0 + b.altitude;
        } else {
            radiusA = 6378100.0;
            radiusB = 6378100.0;
        }
        double xA = radiusA * cosLatA * cosLongA;
        double yA = radiusA * cosLatA * sinLongA;
        double zA = radiusA * sinLatA;
        double xB = radiusB * cosLatB * cosLongB;
        double yB = radiusB * cosLatB * sinLongB;
        double zB = radiusB * sinLatB;
        return (xA - xB) * (xA - xB) + (yA - yB) * (yA - yB) + (zA - zB) * (zA - zB);
    }

    public static double distance(GpsPosition a, GpsPosition b) {
        return Math.sqrt(GpsPosition.distanceSquared(a, b));
    }

    public String toString() {
        return "{latitude:" + this.latitude + ", longitude:" + this.longitude + ", altitude:" + this.altitude + ", hasAltitude:" + this.hasAltitude + "}";
    }
}

