/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.ue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import se.ericsson.cello.extethswitch.EthernetSwitchMo;
import se.ericsson.cello.extethswitch.EthernetSwitchPortMo;
import se.ericsson.cello.ipoam.EthernetLinkMo;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.iptransport.InternalEthernetPortMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.sync.SynchronizationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.upgradepackage.main.interfaces.TriggerCentral;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.wcdma.rbs.boam.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.main.BoamMain;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.ue.IpAddressHandler;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPlugInUnitUpgradeHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NodeBFunctionMo;

public class RoRoc
implements UpgradeParticipator {
    private static final String AUE_NAME = "BOAM RoRoc AUE ";
    private static String DEF_IP_ADDR = "0.0.0.0";
    public static final int UN_DEF_VID = 0;
    public static final int UN_DEF_MTU = -1;
    private static final Class SELF = RoRoc.class;
    public static final int LOW_VERSION = 7091000;
    private static final int HIGH_VERSION = 8999999;
    private static final int ONE_100_MSEC = 100;
    private static final String ZERO_IP_ADDRESS = "0.0.0.0";
    private static final int VLAN_MEMBERSHIP_MAX_LENGTH_ETHERNETSWITCH = 8;
    private static final int VLAN_MEMBERSHIP_MAX_LENGTH_ETHERNETSWITCHPORT = 256;
    private static RoRoc theOneAndOnly;
    private int nextIpIfId = 0;
    private int nextIpHostLinkId = 0;
    private int mtu = -1;
    private String oamIpAddress = DEF_IP_ADDR;
    private String oamSubnetMask = "255.255.0.0";
    private String oamSubnet = "255.255.0.0";
    private String oamDefaultRouter0 = DEF_IP_ADDR;
    private int oamVid = 0;
    private boolean oamVlan = false;
    private EthernetSwitchPortMo ethernetSwitchPortMo = null;
    private int networkPrefixLength = 0;
    private boolean isLabFix = false;

    private RoRoc() {
        MessageLog.traceEnter(SELF, "RoRoc(), BOAM RoRoc AUE  is initiated.");
        int boamRev = BoamMain.getBoamDataRev();
        if (boamRev >= 7091000 && boamRev <= 8999999) {
            TriggerCentral.subscribeAdmin().addUpgradeParticipator((UpgradeParticipator)this);
        } else {
            MessageLog.trace(9, SELF, "No need to participate in the UP.  BoamDataRev:" + boamRev + ", RoRoc LOW_VERSION:" + 7091000 + ", RoRoc HIGH_VERSION:" + 8999999);
        }
    }

    public static synchronized RoRoc instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new RoRoc();
        }
        return theOneAndOnly;
    }

    public String participatorName() {
        return AUE_NAME;
    }

    public void triggerIndicated(UpgradeMaster master, String triggerName) {
        MessageLog.info(SELF, " triggerIndicated(),Trigger " + triggerName + " received");
        boolean success = false;
        Exception exception = null;
        try {
            if (triggerName.equals("FINISH")) {
                this.execute();
                success = true;
            } else {
                success = true;
            }
        }
        catch (Exception e) {
            exception = e;
            MessageLog.traceError(SELF, "triggerIndicated(), Error!! operation failed due to Excep: " + e.toString());
        }
        MessageLog.writeTraceToSystemLog(master, this, triggerName, success, exception);
        MessageLog.info(SELF, "triggerIndicated(), trigger: " + triggerName + " confirmed: " + success);
    }

    public void execute() throws Exception {
        MessageLog.info(SELF, "Start to execute BOAM RoRoc AUE  Rev B !!!");
        TransactionWrapper tx = null;
        try {
            IpInterfaceMo ipInterfaceMo;
            tx = new TransactionWrapper();
            if (!this.isRoRocAueNeeded(null)) {
                return;
            }
            if (!this.isRoRocEnabled()) {
                return;
            }
            this.prepareRoRoc();
            Coordinator context = tx.getCoordinator();
            if (!this.isLabFix) {
                this.deleteEthernetSwitchPort(context);
            }
            if ((ipInterfaceMo = this.getAvialableIpInterface(context)) == null) {
                ipInterfaceMo = this.createIpInterface(context);
                MessageLog.trace(9, SELF, "A new ipInterfaceMo is created. ipInterfaceMo:" + ipInterfaceMo.getFullDistinguishedName());
            } else {
                MessageLog.trace(9, SELF, "A ipInterfaceMo is founded no need to create new one. ipInterfaceMo:" + ipInterfaceMo.getFullDistinguishedName());
            }
            ManagedObject ipHostLink = this.createIPHostLink((ManagedObject)ipInterfaceMo, context);
            tx.commit();
            this.wait4IpHosLinkEnables(ipHostLink);
            tx = new TransactionWrapper();
            context = tx.getCoordinator();
            if (!this.isLabFix) {
                this.updateLink(context);
                this.updateIpHostLink(ipInterfaceMo, context);
            }
            this.updateVlanMemEthernetSwitch(context);
            if (this.isLabFix) {
                this.updateVlanMemEthernetSystemPorts(context);
            }
            if (!this.isLabFix) {
                this.setIpMoAttributes(context);
            }
            tx.commit();
        }
        catch (Exception e) {
            RoRoc.rollback(tx);
            MessageLog.traceError(SELF, " Interrupting the system upgrade!! Exception thrown during AUE execution", e);
            throw e;
        }
        MessageLog.info(SELF, "BOAM RoRoc AUE  execution is ended successfully!!");
    }

    public void wait4IpHosLinkEnables(ManagedObject ipHostLink) throws Exception {
        MessageLog.traceEnter(this.getClass(), "wait4IpHosLinkEnables()");
        int timePassed = 0;
        int isLikDisabled = ((IpHostLinkMo)ipHostLink).getOperationalState(null);
        while (isLikDisabled == 0 && timePassed < 10) {
            AuxPlugInUnitUpgradeHelper.wait(100);
            isLikDisabled = ((IpHostLinkMo)ipHostLink).getOperationalState(null);
            if (isLikDisabled == 1) continue;
            MessageLog.info(SELF, "wait4IpHosLinkEnables(), Still waiting for IpHostLink to be enabled!! M.Sec passed:" + ++timePassed * 100);
        }
        if (isLikDisabled == 1) {
            MessageLog.info(SELF, "wait4IpHosLinkEnables(), Now IpHostLink is enabled!! M.Sec passed:" + timePassed * 100);
        } else {
            MessageLog.info(SELF, "wait4IpHosLinkEnables(), Still IpHostLink is not enabled, giving up!! M.Sec passed:" + timePassed * 100);
        }
    }

    private boolean isRoRocEnabled() throws Exception {
        NodeBFunctionMo nbMo = (NodeBFunctionMo)this.getMo("NodeBFunction");
        if (nbMo.getUserLabel(null).equals("RoRoc_Disabled")) {
            MessageLog.info(SELF, "The RoRoc Aue is needed but it is disabled by the user, to enable RoRoc Aue, in the from side set NodeBFunctionMo.userLabel to empty string!!");
            return false;
        }
        MessageLog.info(SELF, "\n\n                           Starting RoRoc Aue! \n\n");
        return true;
    }

    private boolean isRoRocAueNeeded(Coordinator context) throws Exception {
        if (this.getMo("IpAtmLink") != null) {
            MessageLog.info(SELF, "No need to run RoRoc Aue, this is a ATM node, IpAtmLink MO exist:" + this.getMo("IpAtmLink").getFullDistinguishedName());
            return false;
        }
        if (this.getMo("IpHostLink") != null) {
            MessageLog.info(SELF, "No need to run RoRoc Aue,  IpHostLink MO exist:" + this.getMo("IpHostLink").getFullDistinguishedName());
            return false;
        }
        if (this.isSyncConfiged(context) && !this.isEthernetSwitchExist()) {
            MessageLog.info(SELF, "No need to run RoRoc Aue, this is a ATM node with no IpAtmLink!!, SynchronizationMo.getSyncReference() is configured but EthernetSwitch MO does not exist.");
            return false;
        }
        if (this.isSyncConfiged(context) && this.isEthernetSwitchExist()) {
            return true;
        }
        MessageLog.info(SELF, "No need to run RoRoc Aue, SynchronizationMo.getSyncReference() is empty, probably OAM access configuration is not done!!");
        return false;
    }

    private boolean isEthernetSwitchExist() throws Exception {
        MoIterator moList = BoamHelper.findMOs("EthernetSwitch");
        return moList.hasMoreElements();
    }

    private boolean isSyncConfiged(Coordinator context) throws Exception {
        SynchronizationMo syncMo = (SynchronizationMo)this.getMo("Synchronization");
        boolean isSyncDone = false;
        ManagedObject[] moList = syncMo.getSyncReference(context);
        for (int i = 0; i < moList.length; ++i) {
            if (moList[i] == null) continue;
            isSyncDone = true;
        }
        return isSyncDone;
    }

    private void prepareRoRoc() throws Exception {
        MessageLog.traceEnter(SELF, "prepareRoRoc()");
        EthernetSwitchMo etSMo = (EthernetSwitchMo)this.getMo("EthernetSwitch");
        String oamSwitchPort = this.getOamSwitchPort(etSMo);
        this.findEthernetSwitchPort(oamSwitchPort);
        EthernetLinkMo eMo = (EthernetLinkMo)this.getMo("EthernetLink");
        String eMoUserlabel = eMo.getUserLabel(null);
        String[] userLabelInfo = this.getUserLabelInfo(eMoUserlabel);
        if (this.isLabFix) {
            MessageLog.info(SELF, "This is a LABFIX!!");
            this.oamIpAddress = userLabelInfo[0];
            this.networkPrefixLength = Integer.parseInt(userLabelInfo[1]);
            this.oamDefaultRouter0 = userLabelInfo[2];
            this.oamVid = Integer.parseInt(userLabelInfo[3]);
            if (this.oamVid > 0) {
                this.oamVlan = true;
            }
            this.oamSubnetMask = IpAddressHandler.getNetworkMask(this.networkPrefixLength);
            MessageLog.info(SELF, "\nReading information for ethernetLinkMo userlabel:  OAM ipAddress = " + this.oamIpAddress + ", networkPrefixLength = " + this.networkPrefixLength + ", oamSubnetMask = " + this.oamSubnetMask + ", defaultRouter0 = " + this.oamDefaultRouter0 + ", vLan = " + this.oamVlan + ", vid = " + this.oamVid);
        } else {
            MessageLog.info(SELF, "This is a real IP Node!!");
            this.oamVlan = etSMo.getEnableVlan(null);
            if (this.oamVlan) {
                MessageLog.info(SELF, "The  vLan config from EthernetSwitchMo:" + this.oamVlan);
                this.oamVid = this.ethernetSwitchPortMo.getUntaggedIngressVid(null);
            } else {
                MessageLog.info(SELF, "The  vLan is not configured!");
                this.oamVid = 0;
            }
            EthernetLinkMo mo = (EthernetLinkMo)this.getMo("EthernetLink");
            this.oamIpAddress = mo.getIpAddress(null);
            this.oamSubnetMask = mo.getSubnetMask(null);
            this.networkPrefixLength = IpAddressHandler.getNetworkPrefixLength(this.oamSubnetMask);
            this.oamDefaultRouter0 = this.calculateDefaultRouter0();
        }
    }

    private String calculateDefaultRouter0() throws Exception {
        int routeMetric = 999999999;
        int indexOfStaticRoute = -1;
        List useableRoutes = this.getUseableRoutes();
        String oamDefaultRouter0 = DEF_IP_ADDR;
        if (useableRoutes.size() > 0) {
            Struct[] useableRoutesArray = useableRoutes.toArray(new Struct[useableRoutes.size()]);
            for (int i = 0; i < useableRoutesArray.length; ++i) {
                int metric = (Integer)useableRoutesArray[i].getValue("routeMetric");
                int index = (Integer)useableRoutesArray[i].getValue("indexOfStaticRoute");
                String nextHopIpAddr = (String)useableRoutesArray[i].getValue("nextHopIpAddr");
                if (metric < routeMetric) {
                    routeMetric = metric;
                    indexOfStaticRoute = -1;
                    oamDefaultRouter0 = nextHopIpAddr;
                    continue;
                }
                if (metric != routeMetric || index <= indexOfStaticRoute) continue;
                indexOfStaticRoute = index;
                oamDefaultRouter0 = nextHopIpAddr;
            }
        } else {
            MessageLog.traceError(SELF, "Could not found any static routes that can be used to determine the oamDefaultRouter0, the node is not configured correct!");
            throw new Exception("Could not found any static routes that can be used to determine the oamDefaultRouter0, the node is not configured correct!");
        }
        return oamDefaultRouter0;
    }

    private List getUseableRoutes() throws Exception {
        this.oamSubnet = IpAddressHandler.calculateMinAddress(this.oamIpAddress, this.oamSubnetMask);
        List oamSubnetRoutes = this.getStaticRoutesThatBelongToOamSubnet();
        MessageLog.trace(9, SELF, "Fond " + oamSubnetRoutes.size() + " static routes that belong" + "to the oamSubnet " + this.oamSubnet);
        List filteredRoutes = this.getStaticRoutesWithZeroIpAndMask(oamSubnetRoutes);
        MessageLog.trace(9, SELF, "Fond " + filteredRoutes.size() + " static routes that have" + "ipAddress and mask set to 0.0.0.0 and belongs to the" + "oamSubnet");
        if (filteredRoutes.size() == 0) {
            return oamSubnetRoutes;
        }
        return filteredRoutes;
    }

    private List getStaticRoutesThatBelongToOamSubnet() throws Exception {
        Struct[] staticRouteList = ((IpRoutingTableMo)this.getMo("IpRoutingTable")).getStaticRoutes(null);
        if (staticRouteList == null) {
            MessageLog.traceError(SELF, "Could not get static routes from node (null)");
            throw new Exception("Unable to fetch static routes from node");
        }
        ArrayList<Struct> useableRoutes = new ArrayList<Struct>();
        for (int i = 0; i < staticRouteList.length; ++i) {
            String nextHopIpAddr = (String)staticRouteList[i].getValue("nextHopIpAddr");
            String subnetIpAddress = IpAddressHandler.calculateMinAddress(nextHopIpAddr, this.oamSubnetMask);
            if (!subnetIpAddress.equals(this.oamSubnet)) continue;
            useableRoutes.add(staticRouteList[i]);
        }
        return useableRoutes;
    }

    private List getStaticRoutesWithZeroIpAndMask(List routes) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        ArrayList<Struct> useableRoutes = new ArrayList<Struct>();
        Iterator iter = routes.iterator();
        while (iter.hasNext()) {
            Struct staticRoute = (Struct)iter.next();
            String destinationIpAddr = (String)staticRoute.getValue("ipAddress");
            String destinationNetworkMask = (String)staticRoute.getValue("networkMask");
            if (!destinationIpAddr.equals(ZERO_IP_ADDRESS) || !destinationNetworkMask.equals(ZERO_IP_ADDRESS)) continue;
            useableRoutes.add(staticRoute);
        }
        return useableRoutes;
    }

    private void deleteEthernetSwitchPort(Coordinator context) throws Exception {
        MessageLog.traceEnter(SELF, "deleteEthernetSwitchPort()");
        this.ethernetSwitchPortMo.delete(context);
    }

    private IpInterfaceMo createIpInterface(Coordinator context) throws Exception {
        MessageLog.traceEnter(SELF, "createIpInterface() ");
        MoIterator ipIfList = BoamHelper.findMOs("IpInterface");
        this.nextIpIfId = ipIfList.size();
        InternalEthernetPortMo internalEthernetPortMo = (InternalEthernetPortMo)this.getMo("InternalEthernetPort");
        MoFactory ipInterfaceFactory = MoFactoryMgr.instance().lookup("IpInterface");
        AttrListImpl attrs = new AttrListImpl();
        attrs.insert("defaultRouter0", this.oamDefaultRouter0);
        attrs.insert("networkPrefixLength", new Integer(this.networkPrefixLength));
        attrs.insert("vLan", this.oamVlan);
        attrs.insert("vid", new Integer(this.oamVid));
        if (this.mtu > -1) {
            attrs.insert("mtu", new Integer(this.mtu));
        }
        attrs.insert("rps", false);
        return (IpInterfaceMo)ipInterfaceFactory.createMo((ManagedObject)internalEthernetPortMo, (AttrList)attrs, Integer.toString(++this.nextIpIfId), null, context);
    }

    private IpInterfaceMo getAvialableIpInterface(Coordinator context) throws Exception {
        MessageLog.traceEnter(SELF, "getAvialableIpInterface()");
        MoIterator moList = BoamHelper.findMOs("IpInterface");
        if (!moList.hasMoreElements()) {
            MessageLog.trace(9, SELF, "No IpInterfaceMo found!");
            return null;
        }
        IpInterfaceMo ipIfMo = (IpInterfaceMo)moList.nextElement();
        boolean ipifvLan = ipIfMo.getVLan(context);
        int ipifVid = ipIfMo.getVid(context);
        this.mtu = ipIfMo.getMtu(context);
        String ipifSubnet = ipIfMo.getSubnet(context);
        MessageLog.info(SELF, "The IpInterfaceMo vLan: " + ipifvLan + ",vid:" + ipifVid + ", Subnet:" + ipifSubnet);
        String oamSubnet = IpAddressHandler.calculateMinAddress(this.oamIpAddress, this.oamSubnetMask);
        MessageLog.info(SELF, "The OAM vLan: " + this.oamVlan + ", vid:" + this.oamVid + ", oamIpAddress: " + this.oamIpAddress + ", oamSubnetMask:" + this.oamSubnetMask + ", oamSubnet:" + oamSubnet);
        if (this.oamVlan == ipifvLan && !this.oamVlan && ipifSubnet.equalsIgnoreCase(oamSubnet)) {
            MessageLog.trace(9, SELF, "The IpInterfaceMo matchs the OAM IpInterface. IpInterfaceMo:" + ipIfMo.getFullDistinguishedName());
            return ipIfMo;
        }
        if (this.oamVlan == ipifvLan && this.oamVlan && this.oamVid == ipifVid && ipifSubnet.equalsIgnoreCase(oamSubnet)) {
            MessageLog.trace(9, SELF, "The IpInterfaceMo matchs the OAM IpInterface. IpInterfaceMo:" + ipIfMo.getFullDistinguishedName());
            return ipIfMo;
        }
        MessageLog.trace(9, SELF, "The IpInterfaceMo can't be used for OAM IPHostLink . IpInterfaceMo:" + ipIfMo.getFullDistinguishedName());
        return null;
    }

    private ManagedObject createIPHostLink(ManagedObject ipInterface, Coordinator context) throws Exception {
        MessageLog.traceEnter(SELF, "createIPHostLink() ");
        IpMo ipHostLinkParentMo = (IpMo)this.getMo("Ip");
        MoFactory ipHostLinkFactory = MoFactoryMgr.instance().lookup("IpHostLink");
        AttrListImpl attrs = new AttrListImpl();
        attrs.insert("ipAddress", ZERO_IP_ADDRESS);
        attrs.insert("ipInterfaceMoRef", ipInterface);
        return ipHostLinkFactory.createMo((ManagedObject)ipHostLinkParentMo, (AttrList)attrs, Integer.toString(++this.nextIpHostLinkId), null, context);
    }

    private void updateVlanMemEthernetSwitch(Coordinator context) throws Exception {
        MessageLog.traceEnter(SELF, "updateVlanMemEthernetSwitch() ");
        if (!this.oamVlan) {
            MessageLog.trace(9, SELF, "updateVlanMemEthernetSwitch(), The O&M VLAN is not konfigured, nothing to do!");
            return;
        }
        EthernetSwitchMo mo = (EthernetSwitchMo)this.getMo("EthernetSwitch");
        if (mo != null) {
            Struct[] vlanMemList = mo.getVlanMembership(context);
            int myVlanMembershipPoss = -1;
            for (int i = 0; i < vlanMemList.length; ++i) {
                Integer oriVid = (Integer)vlanMemList[i].getValue("vid");
                if (this.oamVid == oriVid) {
                    MessageLog.trace(9, SELF, "updateVlanMemEthernetSwitch(), No update is needed. The O&M oamVlan: " + this.oamVid + " is part of EthernetSwitchMo.vlanMembership");
                    return;
                }
                if (0 != oriVid) continue;
                myVlanMembershipPoss = i;
            }
            if (myVlanMembershipPoss == -1) {
                if (vlanMemList.length < 8) {
                    MessageLog.trace(9, SELF, "updateVlanMemEthernetSwitch(), The O&M VID: " + this.oamVid + " is added to EthernetSwitchMo.vlanMembership!");
                    StructImpl[] newVlanMemList = new StructImpl[vlanMemList.length + 1];
                    for (int i = 0; i < vlanMemList.length; ++i) {
                        newVlanMemList[i] = vlanMemList[i];
                    }
                    newVlanMemList[vlanMemList.length] = new StructImpl(new String[]{"egressUntag", "vid"}, new Object[]{false, new Integer(this.oamVid)});
                    mo.setVlanMembership((Struct[])newVlanMemList, context);
                } else {
                    MessageLog.traceError(SELF, "updateVlanMemEthernetSwitch(),Couldn't add the O&M VID: " + this.oamVid + "  to EthernetSwitchMo.vlanMembership!, no emty vlanMembership elemnt!");
                }
            } else {
                MessageLog.trace(9, SELF, "updateVlanMemEthernetSwitch(), The O&M VID: " + this.oamVid + " is added to EthernetSwitchMo.vlanMembership!");
                vlanMemList[myVlanMembershipPoss] = new StructImpl(new String[]{"egressUntag", "vid"}, new Object[]{false, new Integer(this.oamVid)});
                mo.setVlanMembership(vlanMemList, context);
            }
        }
    }

    private void updateVlanMemEthernetSystemPorts(Coordinator context) throws Exception {
        MessageLog.traceEnter(SELF, "updateVlanMemEthernetSystemPorts() ");
        if (!this.oamVlan) {
            MessageLog.trace(9, SELF, "updateVlanMemEthernetSystemPorts(), The O&M VLAN is not konfigured, nothing to do!");
            return;
        }
        MoIterator moList = BoamHelper.findMOs("EthernetSwitchPort");
        while (moList.hasMoreElements()) {
            EthernetSwitchPortMo etSwPort = (EthernetSwitchPortMo)moList.nextElement();
            if (!etSwPort.getSystemPort(context)) continue;
            Struct[] vlanMemList = etSwPort.getVlanMembership(context);
            int myVlanMembershipPoss = -1;
            boolean isUpdateNeeded = true;
            for (int i = 0; i < vlanMemList.length; ++i) {
                Integer oriVid = (Integer)vlanMemList[i].getValue("vid");
                if (this.oamVid == oriVid) {
                    MessageLog.trace(9, SELF, "updateVlanMemEthernetSystemPorts(), No update is needed. The O&M oamVlan: " + this.oamVid + " is part of EthernetSwitchPortMo.vlanMembership. System port:" + etSwPort.getFullDistinguishedName());
                    isUpdateNeeded = false;
                    continue;
                }
                if (0 != oriVid) continue;
                myVlanMembershipPoss = i;
            }
            if (isUpdateNeeded && myVlanMembershipPoss > -1) {
                MessageLog.trace(9, SELF, "updateVlanMemEthernetSystemPorts(), The O&M oamVlan: " + this.oamVid + " is added to EthernetSwitchPortMo.vlanMembership! System port:" + etSwPort.getFullDistinguishedName());
                vlanMemList[myVlanMembershipPoss] = new StructImpl(new String[]{"egressUntag", "vid"}, new Object[]{false, new Integer(this.oamVid)});
                etSwPort.setVlanMembership(vlanMemList, context);
            }
            if (!isUpdateNeeded || myVlanMembershipPoss != -1) continue;
            if (vlanMemList.length < 256) {
                MessageLog.trace(9, SELF, "updateVlanMemEthernetSystemPorts(), The O&M oamVlan: " + this.oamVid + " is added to EthernetSwitchPortMo.vlanMembership!System port:" + etSwPort.getFullDistinguishedName());
                StructImpl[] newVlanMemList = new StructImpl[vlanMemList.length + 1];
                for (int i = 0; i < vlanMemList.length; ++i) {
                    newVlanMemList[i] = vlanMemList[i];
                }
                newVlanMemList[vlanMemList.length] = new StructImpl(new String[]{"egressUntag", "vid"}, new Object[]{false, new Integer(this.oamVid)});
                etSwPort.setVlanMembership((Struct[])newVlanMemList, context);
                continue;
            }
            MessageLog.traceError(SELF, "updateVlanMemEthernetSystemPorts(),Couldn't add the O&M VID: " + this.oamVid + "  to EthernetSwitchPortMo.vlanMembership!, no emty vlanMembership elemnt! System port:" + etSwPort.getFullDistinguishedName());
        }
    }

    private void setIpMoAttributes(Coordinator context) throws Exception {
        MessageLog.traceEnter(SELF, "setIpMoAttributes() ");
        IpMo ipMo = (IpMo)this.getMo("Ip");
        boolean HOST_MODE = false;
        String NODE_IF_NAME = "lh0";
        ipMo.setWorkingMode(0, context);
        ipMo.setNodeInterfaceName("lh0", context);
    }

    private void updateIpHostLink(IpInterfaceMo ipInterface, Coordinator context) throws Exception {
        MessageLog.traceEnter(SELF, "updateIpHostLink()");
        IpHostLinkMo ipHostLink = (IpHostLinkMo)this.getMo("IpHostLink");
        MessageLog.info(SELF, "updateIpHostLink(), oamIpAddress: " + this.oamIpAddress + " networkPrefixLength: " + this.networkPrefixLength + " oamDefaultRouter0: " + this.oamDefaultRouter0 + " defaultRouter1: " + ipInterface.getDefaultRouter1(context) + " defaultRouter2: " + ipInterface.getDefaultRouter2(context) + " ownIpAddressActive: " + ipInterface.getOwnIpAddressActive(context));
        ipHostLink.actionAssignIpAddress(this.oamIpAddress, this.networkPrefixLength, this.getOamDefaultRouter0(), ipInterface.getDefaultRouter1(context), ipInterface.getDefaultRouter2(context), ipInterface.getOwnIpAddressActive(context), context);
    }

    private void updateLink(Coordinator context) throws Exception {
        MessageLog.traceEnter(SELF, "updateLink() ");
        String APIPA_IP_ADD = "169.254.1.1";
        String LOCAL_OAM_SUBNET_MASK = "255.255.0.0";
        String LOCAL_OAM_BROADCAST = "169.254.255.255";
        EthernetLinkMo etLinkmo = (EthernetLinkMo)this.getMo("EthernetLink");
        etLinkmo.actionAssignAllIpAddresses("169.254.1.1", "255.255.0.0", "169.254.255.255", context);
    }

    private ManagedObject findEthernetSwitchPort(String port) throws Exception {
        MessageLog.traceEnter(SELF, "findEthernetSwitchPort()");
        int portNoToDelete = Integer.parseInt(port);
        MoIterator moList = BoamHelper.findMOs("EthernetSwitchPort");
        while (moList.hasMoreElements()) {
            EthernetSwitchPortMo mo = (EthernetSwitchPortMo)moList.nextElement();
            if (portNoToDelete != mo.getPortNo(null)) continue;
            this.ethernetSwitchPortMo = mo;
            return this.ethernetSwitchPortMo;
        }
        throw new Exception("findEthernetSwitchPort(), Couldn't find MO :EthernetSwitchPort, with portNo: " + portNoToDelete);
    }

    private ManagedObject getMo(String name) throws Exception {
        MoIterator moList = BoamHelper.findMOs(name);
        if (moList.hasMoreElements()) {
            return (ManagedObject)moList.nextElement();
        }
        if (name.equals("IpHostLink") || name.equals("IpAtmLink")) {
            return null;
        }
        throw new Exception("Couldn't find MO :" + name);
    }

    private static void rollback(TransactionWrapper tx) {
        MessageLog.traceEnter(SELF, "rollback()");
        if (tx == null) {
            return;
        }
        try {
            tx.rollback();
            MessageLog.trace(9, SELF, "transaction rolled back: " + tx);
        }
        catch (InactiveTransactionException e) {
            MessageLog.traceError(SELF, "failed to roll back transaction '" + tx + "'", e);
        }
    }

    private String getOamSwitchPort(EthernetSwitchMo etSMo) {
        String oamSwitchPort;
        MessageLog.traceEnter(SELF, "getOamSwitchPort()");
        String PORT = "port";
        try {
            String portname = etSMo.getUserLabel(null);
            StringTokenizer st = new StringTokenizer(portname, "=");
            String name = st.nextToken();
            oamSwitchPort = st.nextToken();
            int value = Integer.parseInt(oamSwitchPort);
            if (!"port".equalsIgnoreCase(name)) {
                oamSwitchPort = "2";
            } else if (value < 1 || value > 7) {
                oamSwitchPort = "2";
            }
        }
        catch (Exception e) {
            oamSwitchPort = "2";
        }
        return oamSwitchPort;
    }

    private String[] getUserLabelInfo(String userLabel) {
        if (userLabel == null) {
            return new String[0];
        }
        MessageLog.traceEnter(SELF, "getUserLabelInfo(), userLabel: " + userLabel);
        StringTokenizer st = new StringTokenizer(userLabel, ",");
        int noOfToken = st.countTokens();
        if (noOfToken != 4 && noOfToken != 3) {
            return new String[0];
        }
        String ipAdressToken = st.nextToken();
        String networkPrefixLengthToken = st.nextToken();
        String defaultRouter0Token = st.nextToken();
        String vidToken = "vid=0";
        if (noOfToken == 4) {
            vidToken = st.nextToken();
        }
        if (!(ipAdressToken.startsWith("ipAddress=") && networkPrefixLengthToken.startsWith("networkPrefixLength=") && defaultRouter0Token.startsWith("defaultRouter0=") && vidToken.startsWith("vid="))) {
            return new String[0];
        }
        String[] userLabelInfo = new String[]{ipAdressToken.substring(ipAdressToken.indexOf("=") + 1), networkPrefixLengthToken.substring(networkPrefixLengthToken.indexOf("=") + 1), defaultRouter0Token.substring(defaultRouter0Token.indexOf("=") + 1), vidToken.substring(vidToken.indexOf("=") + 1)};
        this.isLabFix = true;
        return userLabelInfo;
    }

    public String getOamDefaultRouter0() {
        return this.oamDefaultRouter0;
    }
}

