/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.common;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsBasicHwPidT;

public class ProductDataUtil {
    private static final String YEAR_WEEK_DAY_FORMAT = "yyyyMMdd";
    private static final String NEW_DATE_FORMAT = "yyyyMMdd";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH.mm.ss";
    public static final String DEFAULT_PRODUCT_DATE = "00000000";
    private static final int NUM_DAYS_FIRST_WEEK = 4;

    public static boolean isYearWeekFormat(String inDate) {
        MessageLog.traceEnter(ProductDataUtil.class, "isYearWeekFormat(): '" + inDate + "'");
        String inDateTrimmed = inDate.trim();
        return inDateTrimmed.length() == 5 && Character.isDigit(inDateTrimmed.charAt(0)) && Character.isDigit(inDateTrimmed.charAt(1)) && (inDateTrimmed.charAt(2) == 'W' || inDateTrimmed.charAt(2) == 'w') && Character.isDigit(inDateTrimmed.charAt(3)) && Character.isDigit(inDateTrimmed.charAt(4));
    }

    public static boolean isYearMonthDayFormat(String inDate) {
        MessageLog.traceEnter(ProductDataUtil.class, "isYearWeekDayFormat(): " + inDate);
        return ProductDataUtil.parseDate(inDate, "yyyyMMdd") != null;
    }

    public static boolean isDateTimeFormat(String inDate) {
        MessageLog.traceEnter(ProductDataUtil.class, "isDateTimeFormat(): " + inDate);
        return ProductDataUtil.parseDate(inDate, DATE_TIME_FORMAT) != null;
    }

    public static String verifyDateFormat(String inDate) {
        if (inDate == null) {
            return DEFAULT_PRODUCT_DATE;
        }
        if (ProductDataUtil.isYearMonthDayFormat(inDate)) {
            return inDate;
        }
        if (ProductDataUtil.isYearWeekFormat(inDate)) {
            return ProductDataUtil.convertOldToNewDateFormat(inDate);
        }
        if (ProductDataUtil.isDateTimeFormat(inDate)) {
            return ProductDataUtil.convertDateTimeToNewDateFormat(inDate);
        }
        return DEFAULT_PRODUCT_DATE;
    }

    public static String verifyDateFormat(RbsBasicHwPidT rbsBasicHwPidT) {
        return rbsBasicHwPidT == null ? DEFAULT_PRODUCT_DATE : ProductDataUtil.verifyDateFormat(rbsBasicHwPidT.hwProductionDate);
    }

    public static String convertOldToNewDateFormat(String inDate) {
        MessageLog.traceEnter(ProductDataUtil.class, "convertOldToNewDateFormat(): " + inDate);
        if (inDate.length() == 5 || inDate.length() == 4) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.setFirstDayOfWeek(2);
            cal.setMinimalDaysInFirstWeek(4);
            try {
                int year = Integer.parseInt(inDate.substring(0, 2)) >= 70 ? Integer.parseInt("19" + inDate.substring(0, 2)) : Integer.parseInt("20" + inDate.substring(0, 2));
                cal.set(1, year);
                int week = inDate.length() == 5 ? Integer.parseInt(inDate.substring(3, 5)) : (inDate.length() == 4 ? Integer.parseInt(inDate.substring(2, 4)) : 0);
                cal.set(3, week);
                cal.set(7, 2);
            }
            catch (NumberFormatException nfe) {
                MessageLog.traceError(ProductDataUtil.class, "Wrong format on retreived date: " + inDate, nfe);
            }
            String sYear = Integer.toString(cal.get(1));
            int aMonth = cal.get(2) + 1;
            String sMonth = aMonth < 10 ? "0" + Integer.toString(aMonth) : Integer.toString(aMonth);
            int aDay = cal.get(5);
            String sDay = aDay < 10 ? "0" + Integer.toString(aDay) : Integer.toString(aDay);
            return sYear + sMonth + sDay;
        }
        MessageLog.trace(2, ProductDataUtil.class, "convertOldToNewDateFormat: Failed to convert " + inDate);
        return DEFAULT_PRODUCT_DATE;
    }

    public static String convertDateTimeToNewDateFormat(String inDate) {
        MessageLog.traceEnter(ProductDataUtil.class, "convertDateTimeToNewDateFormat(): " + inDate);
        Date dateTime = ProductDataUtil.parseDate(inDate, DATE_TIME_FORMAT);
        if (dateTime == null) {
            MessageLog.trace(2, ProductDataUtil.class, "Could not parse date: " + inDate + ". It is not in correct format: " + DATE_TIME_FORMAT);
            return DEFAULT_PRODUCT_DATE;
        }
        return ProductDataUtil.formatDate(dateTime, "yyyyMMdd");
    }

    private static synchronized String formatDate(Date dateTime, String format) {
        SimpleDateFormat outFormat = new SimpleDateFormat(format);
        String outDate = outFormat.format(dateTime);
        return outDate;
    }

    private static synchronized Date parseDate(String inDate, String format) {
        if (inDate.length() != format.length()) {
            return null;
        }
        SimpleDateFormat inFormat = new SimpleDateFormat(format);
        inFormat.setLenient(false);
        Date dateTime = inFormat.parse(inDate, new ParsePosition(0));
        return dateTime;
    }
}

