/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.common;

import java.util.Enumeration;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.common.InvalidReferenceException;
import se.ericsson.wcdma.rbs.boam.mao.common.MoNotReservedByUserException;
import se.ericsson.wcdma.rbs.boam.mao.common.MoReservedByOtherUserException;

public class ReservableImpl {
    private static boolean isAcceptedClass(Object object, String[] validClasses) throws MoAccessException {
        boolean accepted = false;
        for (int i = 0; i < validClasses.length; ++i) {
            if (!object.getClass().getName().equals(validClasses[i])) continue;
            accepted = true;
        }
        return accepted;
    }

    private static ReferenceAttribute findReserver(ManagedObject userId, Coordinator context, MoData data, SequenceAttribute reservedBy) throws MoAccessException {
        data.handleTransaction(context, MoData.READ_ACCESS);
        Enumeration enumList = reservedBy.elements();
        while (enumList.hasMoreElements()) {
            ReferenceAttribute element = (ReferenceAttribute)enumList.nextElement();
            if (!userId.equals(element.getValue(context))) continue;
            return element;
        }
        return null;
    }

    public static SequenceAttribute reserve(ManagedObject userId, Coordinator context, String moType, MoData data, SequenceAttribute reservedBy) throws MoAccessException {
        if (userId == null) {
            throw new InvalidReferenceException(moType, null);
        }
        if (ReservableImpl.findReserver(userId, context, data, reservedBy) == null) {
            data.handleTransaction(context, MoData.WRITE_ACCESS);
            ReferenceAttribute newElement = new ReferenceAttribute("", false);
            newElement.setValue(userId);
            reservedBy.addElement((Attribute)newElement);
        } else {
            MessageLog.trace(2, ReservableImpl.class, "reserve(): userId (" + userId + ") already reserved by " + moType + "/another MO.");
        }
        return reservedBy;
    }

    public static SequenceAttribute reserve(ManagedObject userId, Coordinator context, String moType, MoData data, SequenceAttribute reservedBy, String[] validClasses) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass(userId, validClasses)) {
            throw new InvalidReferenceException(moType, userId);
        }
        return ReservableImpl.reserve(userId, context, moType, data, reservedBy);
    }

    public static SequenceAttribute release(ManagedObject userId, Coordinator context, String moType, MoData data, SequenceAttribute reservedBy) throws MoAccessException {
        data.handleTransaction(context, MoData.WRITE_ACCESS);
        if (userId == null) {
            throw new InvalidReferenceException(moType, null);
        }
        ReferenceAttribute foundMo = ReservableImpl.findReserver(userId, context, data, reservedBy);
        if (foundMo == null) {
            MessageLog.trace(2, ReservableImpl.class, "release(): userId (" + userId + ") is not reserver/has already released ");
        } else {
            reservedBy.removeElement((Attribute)foundMo);
            foundMo.setValue(null);
        }
        return reservedBy;
    }

    public static SequenceAttribute release(ManagedObject userId, Coordinator context, String moType, MoData data, SequenceAttribute reservedBy, String[] validClasses) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass(userId, validClasses)) {
            throw new InvalidReferenceException(moType, userId);
        }
        return ReservableImpl.release(userId, context, moType, data, reservedBy);
    }

    public static ReferenceAttribute reserve(ManagedObject userId, Coordinator context, String moType, MoData data, ReferenceAttribute reservedBy) throws MoAccessException {
        if (userId == null) {
            throw new InvalidReferenceException(moType, null);
        }
        data.handleTransaction(context, MoData.READ_ACCESS);
        ManagedObject reserver = reservedBy.getValue(context);
        if (reserver == null) {
            data.handleTransaction(context, MoData.WRITE_ACCESS);
            reservedBy.setValue(userId);
        } else if (reserver == userId) {
            MessageLog.trace(2, ReservableImpl.class, "reserve(): userId (" + userId + ") already reserved by " + moType);
        } else {
            throw new MoReservedByOtherUserException(userId.getType(), reserver.getType());
        }
        return reservedBy;
    }

    public static ReferenceAttribute reserve(ManagedObject userId, Coordinator context, String moType, MoData data, ReferenceAttribute reservedBy, String[] validClasses) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass(userId, validClasses)) {
            throw new InvalidReferenceException(moType, userId);
        }
        return ReservableImpl.reserve(userId, context, moType, data, reservedBy);
    }

    public static ReferenceAttribute release(ManagedObject userId, Coordinator context, String moType, MoData data, ReferenceAttribute reservedBy) throws MoAccessException {
        if (userId == null) {
            throw new InvalidReferenceException(moType, null);
        }
        data.handleTransaction(context, MoData.READ_ACCESS);
        ManagedObject reserver = reservedBy.getValue(context);
        if (reserver == userId) {
            data.handleTransaction(context, MoData.WRITE_ACCESS);
            reservedBy.setValue(null);
        } else if (reserver == null) {
            MessageLog.trace(2, ReservableImpl.class, "release(): userId (" + userId + ") has already released " + moType);
        } else {
            throw new MoNotReservedByUserException(userId.getType(), reserver.getType());
        }
        return reservedBy;
    }

    public static ReferenceAttribute release(ManagedObject userId, Coordinator context, String moType, MoData data, ReferenceAttribute reservedBy, String[] validClasses) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass(userId, validClasses)) {
            throw new InvalidReferenceException(moType, userId);
        }
        return ReservableImpl.release(userId, context, moType, data, reservedBy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reserve(ManagedObject userId, Coordinator context, MoData data, String attrName) throws MoAccessException {
        if (userId == null) {
            throw new InvalidReferenceException(data.getMoTypeName(), null);
        }
        data.handleTransaction(context, MoData.READ_ACCESS);
        Attribute reservedBy = data.getAttribute(attrName);
        if (reservedBy.getClass().equals(SequenceAttribute.class)) {
            SequenceAttribute seq = (SequenceAttribute)data.getAttribute(attrName);
            if (ReservableImpl.findReserver(userId, context, data, seq) == null) {
                data.handleTransaction(context, MoData.WRITE_ACCESS);
                ReferenceAttribute newElement = new ReferenceAttribute("", false);
                newElement.setValue(userId);
                seq.addElement((Attribute)newElement);
                return;
            } else {
                MessageLog.trace(2, ReservableImpl.class, "reserve(): userId (" + userId + ") already reserved by " + data.getMoTypeName() + "/another MO.");
            }
            return;
        } else {
            if (!reservedBy.getClass().equals(ReferenceAttribute.class)) throw new WrongAttributeTypeException(attrName, data.getMoTypeName());
            ManagedObject reserver = ((ReferenceAttribute)data.getAttribute(attrName)).getValue(context);
            if (reserver == null) {
                data.handleTransaction(context, MoData.WRITE_ACCESS);
                ((ReferenceAttribute)data.getAttribute(attrName)).setValue(userId);
                return;
            } else {
                if (reserver != userId) throw new MoReservedByOtherUserException(userId.getType(), reserver.getType());
                MessageLog.trace(2, ReservableImpl.class, "reserve(): userId (" + userId + ") already reserved by " + data.getMoTypeName());
            }
        }
    }

    public static void reserve(ManagedObject userId, Coordinator context, MoData data, String attrName, String[] validClasses) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass(userId, validClasses)) {
            throw new InvalidReferenceException(data.getMoTypeName(), userId);
        }
        ReservableImpl.reserve(userId, context, data, attrName);
    }

    public static void release(ManagedObject userId, Coordinator context, MoData data, String attrName) throws MoAccessException {
        if (userId == null) {
            throw new InvalidReferenceException(data.getMoTypeName(), null);
        }
        data.handleTransaction(context, MoData.READ_ACCESS);
        Attribute reservedBy = data.getAttribute(attrName);
        if (reservedBy.getClass().equals(SequenceAttribute.class)) {
            SequenceAttribute seq = (SequenceAttribute)data.getAttribute(attrName);
            ReferenceAttribute foundMo = ReservableImpl.findReserver(userId, context, data, seq);
            if (foundMo == null) {
                MessageLog.trace(2, ReservableImpl.class, "release(): userId (" + userId + ") is not reserver/has already released " + data.getMoTypeName());
            } else {
                seq.removeElement((Attribute)foundMo);
                foundMo.setValue(null);
            }
        } else if (reservedBy.getClass().equals(ReferenceAttribute.class)) {
            ManagedObject reserver = ((ReferenceAttribute)data.getAttribute(attrName)).getValue(context);
            if (reserver == userId) {
                data.handleTransaction(context, MoData.WRITE_ACCESS);
                ((ReferenceAttribute)data.getAttribute(attrName)).setValue(null);
            } else if (reserver == null) {
                MessageLog.trace(2, ReservableImpl.class, "release(): userId (" + userId + ") has already released ");
            } else {
                throw new MoNotReservedByUserException(userId.getType(), reserver.getType());
            }
        }
    }

    public static void release(ManagedObject userId, Coordinator context, MoData data, String attrName, String[] validClasses) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass(userId, validClasses)) {
            throw new InvalidReferenceException(data.getMoTypeName(), userId);
        }
        ReservableImpl.release(userId, context, data, attrName);
    }

    public static int noOfReservers(SequenceAttribute reservedBy, String className, Coordinator context) throws MoAccessException {
        int tmp = 0;
        if (reservedBy == null) {
            return 0;
        }
        Attribute[] arr = reservedBy.getValue(context);
        for (int index = 0; index < reservedBy.size(); ++index) {
            ManagedObject obj = ((ReferenceAttribute)arr[index]).getValue(context);
            if (!obj.getClass().getName().equals(className)) continue;
            ++tmp;
        }
        return tmp;
    }

    public static ManagedObject[] retrieveRefArrayFromSequence(SequenceAttribute refSequence, Coordinator context) throws MoAccessException {
        Attribute[] refAttribArray = refSequence.getValue(context);
        ManagedObject[] refArray = new ManagedObject[refSequence.size()];
        ReferenceAttribute refAttrib = null;
        for (int index = 0; index < refSequence.size(); ++index) {
            refAttrib = (ReferenceAttribute)refAttribArray[index];
            refArray[index] = refAttrib.getValue(context);
        }
        return refArray;
    }
}

