/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.alarm;

import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAlmParametersRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.PerceivedSeverity;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.ProbableCause;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AlmDeviceMo;

public class AlmDeviceMoImpl
extends AuxDeviceMoImpl
implements AlmDeviceMo {
    private static final int NO_ALARM = 0;
    private static final int ALARM_PRESENT = 1;
    private static final int CAUSE_MAX_LENGTH = 3;
    private static final int CAUSE_MIN_LENGTH = 0;
    public static final int MO_DATA_REVISION = 3050001;

    public AlmDeviceMoImpl(ManagedObject parent, String thisMoName, int deviceFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, 15, deviceFroId, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "AlmDevice Normal constructor");
        this.initAlarmStatus(0, context);
        this.bcmStoreAndRegisterStringAttribute("alarmSlogan", "");
        Integer probableCause = new Integer(550);
        this.bcmStoreAndRegisterStringAttribute("probableCause", probableCause.toString());
        this.bcmStoreAndRegisterIntAttribute("perceivedSeverity", 4);
        this.addObservers(15, context);
        this.myData.setRevision(3050001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public AlmDeviceMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "AlmDevice: Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(15, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public int getAdministrativeState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAdministrativeState()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        int result2 = 0;
        try {
            EqcGetAlmParametersRspS cfmSig = eqcDeviceProxy.getAlmParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDeviceFroId(context));
            result2 = cfmSig.admState;
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "getadministrativeState() NOT OK");
            throw e;
        }
        return result2;
    }

    public void setAdministrativeState(int newAdminState, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAdministrativeState()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if ((newAdminState & 0xFFFFFFFE) != 0) {
            throw new ValueOutOfRangeException("administrativeState", this.getType());
        }
        try {
            eqcDeviceProxy.setDeviceAdmState(this.getTxIdTransactional(context), 0L, this.getAuxDeviceFroId(context), newAdminState);
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "setAdministrativeState Failed");
            throw e;
        }
        this.sendAVC("administrativeState", newAdminState, context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        int admState = this.getAdministrativeState(context);
        if (admState != 0) {
            String msg = " UserLabel can not be set over Mub, because AlmDevice is unlocked! ";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public boolean getNormallyOpen(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNormallyOpen()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        boolean result2 = false;
        try {
            EqcGetAlmParametersRspS cfmSig = eqcDeviceProxy.getAlmParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDeviceFroId(context));
            if (cfmSig.normallyOpen != 0) {
                result2 = true;
            }
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "EqcGetAlmParametersRspS NOT OK");
            throw e;
        }
        return result2;
    }

    public void setNormallyOpen(boolean open, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setNormallyOpen()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int normallyOpen = 0;
        if (open) {
            normallyOpen = 1;
        }
        if ((normallyOpen & 0xFFFFFFFE) != 0) {
            throw new ValueOutOfRangeException("normallyOpen", this.getType());
        }
        int admState = this.getAdministrativeState(context);
        if (admState != 0) {
            String msg = " NormallyOpen can not be set over Mub, because AlmDevice is unlocked! ";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        eqcDeviceProxy.setDeviceNormallyOpen(this.getTxIdTransactional(context), 0L, this.getAuxDeviceFroId(context), normallyOpen);
        this.sendAVC("normallyOpen", open, context);
    }

    public int getAlmDeviceStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAlmDeviceStatus()");
        int alarm = this.getAlarmStatus(context) & 0xFFFE;
        if (alarm > 0) {
            return 1;
        }
        return 0;
    }

    public String getAlarmSlogan(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAlarmSlogan() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetStringAttribute("alarmSlogan", context);
    }

    public void setAlarmSlogan(String slogan, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAlarmSlogan()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int admState = this.getAdministrativeState(context);
        if (admState != 0) {
            String msg = " AlarmSlogan can not be set over Mub, because AlmDevice is unlocked! ";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        this.bcmSetStringAttribute("alarmSlogan", slogan, 0, 63, "AlmDevice", context);
        this.sendAVC("alarmSlogan", slogan, context);
    }

    public void setAlarmStatus(int newStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAlarmStatus()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int admState = this.getAdministrativeState(context);
        if (admState != 0) {
            String msg = " AlarmStatus can not be set over Mub, because AlmDevice is unlocked! ";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        super.setAlarmStatus(newStatus, context);
    }

    public int getPerceivedSeverity(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPerceivedSeverity()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetIntAttribute("perceivedSeverity", context);
    }

    public void setPerceivedSeverity(int severity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPerceivedSeverity()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int admState = this.getAdministrativeState(context);
        if (admState != 0) {
            String msg = " PerceivedSeverity can not be set over Mub, because AlmDevice is unlocked! ";
            throw new AttrNotSettableException(this.getType(), " PerceivedSeverity can not be set over Mub, because AlmDevice is unlocked! ");
        }
        ValidateAttributes.intValueInEnumerationCheck("perceivedSeverity", severity, PerceivedSeverity.class, this.getType());
        this.bcmSetIntAttribute("perceivedSeverity", severity, 2, 5, this.getType(), context);
        this.myMoAlarms.setAlarmSeverity(Integer.toString(severity));
        this.sendAVC("perceivedSeverity", severity, context);
    }

    public int getProbableCause(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProbableCause()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        String cause = this.bcmGetStringAttribute("probableCause", context);
        int pCause = new Integer(cause);
        MessageLog.trace(2, this.getClass(), "ProbableCause has been converted to int  " + pCause);
        return pCause;
    }

    public void setProbableCause(int cause, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setProbableCause()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int admState = this.getAdministrativeState(context);
        if (admState != 0) {
            String msg = " ProbableCause can not be set over Mub, because AlmDevice is unlocked! ";
            throw new AttrNotSettableException(this.getType(), " ProbableCause can not be set over Mub, because AlmDevice is unlocked! ");
        }
        String proCause = Integer.toString(cause);
        ValidateAttributes.intValueInEnumerationCheck("probableCause", cause, ProbableCause.class, this.getType());
        this.bcmSetStringAttribute("probableCause", proCause, 0, 3, "AlmDevice", context);
        this.sendAVC("probableCause", cause, context);
    }

    public String getAlmDeviceId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAlmDeviceId()");
        return super.getIdentity(c);
    }

    public String getType() {
        return "AlmDevice";
    }
}

