/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu;

import java.util.ArrayList;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ConfigurationNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.gmo.GenSectorMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BfuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CluDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ExternalAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.FcuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.FuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PauDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PsuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSlotMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RetuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SaiuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;

public abstract class AuxPlugInUnitAttributesChecker {
    private static final Class THIS_CLASS = AuxPlugInUnitAttributesChecker.class;

    public static boolean moHasChildren(ManagedObject mo) {
        MoIterator moIterator;
        MessageLog.traceEnter(THIS_CLASS, "moHasChildren()<---");
        boolean status = false;
        if (mo != null && (moIterator = mo.getChildren()) != null && moIterator.size() > 0) {
            MessageLog.trace(2, THIS_CLASS, "Ldn: " + mo.getLocalDistinguishedName() + "has children");
            status = true;
        }
        return status;
    }

    public static ManagedObject checkAndGetPiuType(AttrList attributes, int auType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "checkAndGetPiuType()<---");
        int index = attributes.indexOf("piuType");
        if (index == -1) {
            throw new AttrMissingAtCreateException("piuType", "AuxPlugInUnit");
        }
        ManagedObject piuType = (ManagedObject)attributes.getValue(index);
        if (!(piuType instanceof PiuTypeMo)) {
            throw new WrongAttributeTypeException("piuType", "AuxPlugInUnit");
        }
        attributes.removeElementAt(index);
        return piuType;
    }

    public static void checkMoRefType(ManagedObject moRef, String moTypeName, String attrName, String ownerName) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "checkMoRefType()<---");
        if (!moRef.getType().equalsIgnoreCase(moTypeName)) {
            throw new WrongAttributeTypeException(attrName, ownerName);
        }
    }

    public static ManagedObject checkAndGetPlugInUnitRef(AttrList attributes, String attrName, String attrMandatory, int auType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "checkAndGetPlugInUnitRef()<---");
        int index = attributes.indexOf(attrName);
        ManagedObject moRef = null;
        String mandatory = "mandatory";
        if (index == -1) {
            if (attrMandatory.equals("mandatory")) {
                throw new AttrMissingAtCreateException(attrName, "AuxPlugInUnit");
            }
        } else {
            moRef = (ManagedObject)attributes.getValue(index);
            if (!(moRef instanceof PiuDeviceMo || moRef instanceof PlugInUnitMo || moRef instanceof AuxPlugInUnitMo)) {
                throw new WrongAttributeTypeException(attrName, "AuxPlugInUnit");
            }
            if (auType == 12 ? moRef.getType().equals("AuxPlugInUnit") && ((AuxPlugInUnitMo)moRef).getAuType(context) != 11 : auType == 28 && moRef.getType().equals("AuxPlugInUnit") && ((AuxPlugInUnitMo)moRef).getAuType(context) != 27) {
                throw new WrongAttributeTypeException(attrName, "AuxPlugInUnit");
            }
            attributes.removeElementAt(index);
        }
        return moRef;
    }

    public static void checkAuTypeUnicityWithinSector(ManagedObject parent, int auType, Coordinator c) throws ConfigurationNotSupportedException, MoAccessException {
        SectorMo sector = null;
        if (!parent.getType().equals("SectorAntenna")) {
            MessageLog.trace(1, THIS_CLASS, "parent is not SectorAntennaMo");
            return;
        }
        ManagedObject[] sectorByList = ((SectorAntennaMo)parent).getReservedBy(c);
        if (sectorByList != null && sectorByList.length > 0) {
            for (int i = 0; i < sectorByList.length; ++i) {
                if (!(sectorByList[i] instanceof SectorMo)) continue;
                sector = (SectorMo)sectorByList[i];
            }
        }
        if (null == sector) {
            MessageLog.trace(1, THIS_CLASS, "can not find the sector");
            return;
        }
        ArrayList<Integer> incompatibleAuTypes = new ArrayList<Integer>();
        MoIterator moIter = null;
        switch (auType) {
            case 7: {
                incompatibleAuTypes.add(new Integer(17));
                incompatibleAuTypes.add(new Integer(18));
                incompatibleAuTypes.add(new Integer(25));
                AuxPlugInUnitAttributesChecker.checkIncompatibleCoExistingTypes(sector, auType, incompatibleAuTypes, c);
                break;
            }
            case 17: 
            case 18: {
                moIter = BoamHelper.findMOs("AiuDeviceGroup");
                if (moIter != null && moIter.size() > 0) {
                    throw new ConfigurationNotSupportedException("RBS 3 Configuration with " + (auType == 18 ? "ARETU" : "ATMAU") + "and AIU not supported");
                }
                incompatibleAuTypes.add(new Integer(7));
                AuxPlugInUnitAttributesChecker.checkIncompatibleCoExistingTypes(sector, auType, incompatibleAuTypes, c);
                break;
            }
            case 25: {
                moIter = BoamHelper.findMOs("AiuDeviceGroup");
                if (moIter != null && moIter.size() > 0) {
                    throw new ConfigurationNotSupportedException("RBS 3 Configuration with " + (auType == 25) + "and AIU not supported");
                }
                moIter = BoamHelper.findMOs("RuifDeviceGroup");
                if (moIter != null && moIter.size() > 0) {
                    throw new ConfigurationNotSupportedException("RBS 3 Configuration with " + (auType == 25) + "and RUIF not supported");
                }
                moIter = BoamHelper.findMOs("ObifDeviceGroup");
                if (moIter != null && moIter.size() > 0) {
                    throw new ConfigurationNotSupportedException("RBS 3 Configuration with " + (auType == 25) + "and OBIF not supported");
                }
                incompatibleAuTypes.add(new Integer(7));
                AuxPlugInUnitAttributesChecker.checkIncompatibleCoExistingTypes(sector, auType, incompatibleAuTypes, c);
                break;
            }
        }
    }

    private static void checkIncompatibleCoExistingTypes(ManagedObject sector, int auType, ArrayList incompatibleAuTypes, Coordinator c) throws ConfigurationNotSupportedException, MoAccessException {
        MessageLog.trace(1, THIS_CLASS, "Checking for auType <" + auType + "> that " + sector.getFullDistinguishedName() + "does not have auType(s) such as " + incompatibleAuTypes);
        ManagedObject[] sectorAntennas = ((SectorMo)sector).getSectorAntennasRef(c);
        for (int i = 0; i < sectorAntennas.length; ++i) {
            MoIterator auxPiuIter = BoamHelper.findMOs("AuxPlugInUnit", sectorAntennas[i], 1);
            if (auxPiuIter == null || auxPiuIter.size() == 0) continue;
            while (auxPiuIter.hasMoreElements()) {
                AuxPlugInUnitMo anAuxPiu = (AuxPlugInUnitMo)auxPiuIter.nextMo();
                if (!incompatibleAuTypes.contains(new Integer(anAuxPiu.getAuType(c)))) continue;
                throw new ConfigurationNotSupportedException("auType <" + auType + "> cannot co-exist with auType <" + anAuxPiu.getAuType(c) + "> on the same Sector " + sector.getFullDistinguishedName());
            }
        }
    }

    public static void checkParentCompatibilityWithAuType(ManagedObject parent, int auType) throws IllegalParentException, MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "checkParentCompatibilityWithAuType(" + auType + ")<---");
        if (parent != null) {
            switch (auType) {
                case 1: {
                    if (parent.getType().equals("RbsSlot")) {
                        if (parent.getParent().getType().equals("McpaSubrack")) {
                            MessageLog.trace(1, THIS_CLASS, "correct parent (RbsSlot) and grandparent (McpaSubrack) was selected");
                            break;
                        }
                        MessageLog.trace(1, THIS_CLASS, "Illegal parentparent");
                        throw new IllegalParentException("Expecting RbsSubrack Mo, received:" + parent.getParent().getClass().getName());
                    }
                    MessageLog.trace(1, THIS_CLASS, "Illegal parent");
                    throw new IllegalParentException("Expecting RbsSlotMo, received:" + parent.getClass().getName());
                }
                case 4: {
                    if (parent.getType().equals("RbsSlot")) {
                        if (parent.getParent().getType().equals("PowerSupplySubrack")) {
                            MessageLog.trace(1, THIS_CLASS, "correct parent (RbsSlot) and grandparent (PowerSupplySubrack) was selected");
                            break;
                        }
                        MessageLog.trace(1, THIS_CLASS, "Illegal parentparent");
                        throw new IllegalParentException("Expecting RbsSubrack Mo, received:" + parent.getParent().getClass().getName());
                    }
                    MessageLog.trace(1, THIS_CLASS, "Illegal parent");
                    throw new IllegalParentException("Expecting RbsSlotMo, received:" + parent.getClass().getName());
                }
                case 2: {
                    if (parent.getType().equals("CuSubrack")) {
                        MessageLog.trace(1, THIS_CLASS, " correct parent was selected:  CuSubrack ");
                        break;
                    }
                    MessageLog.trace(1, THIS_CLASS, "Illegal parent");
                    throw new IllegalParentException("Expecting CuSubrackMo, received:" + parent.getClass().getName());
                }
                case 11: 
                case 12: {
                    MessageLog.trace(1, THIS_CLASS, "No parent/parent-parent check done for types RU and FU : see 2_1594-FCP1036557, section 3.7.3");
                    break;
                }
                case 14: {
                    if (parent.getType().equals("RbsSlot")) {
                        if (parent.getParent().getType().equals("RbsSubrack")) {
                            MessageLog.trace(1, THIS_CLASS, "  correct parent was selected: RbsSubrack");
                            break;
                        }
                        MessageLog.trace(1, THIS_CLASS, "Illegal parentparent");
                        throw new IllegalParentException("Expecting RbsSubrack Mo, received:" + parent.getParent().getClass().getName());
                    }
                    if (parent.getType().equals("RbsSubrack")) {
                        if (parent.getParent().getType().equals("Equipment")) {
                            MessageLog.trace(1, THIS_CLASS, "  correct parent parent was selected: Equipment");
                            break;
                        }
                        MessageLog.trace(1, THIS_CLASS, "Illegal parent parent");
                        throw new IllegalParentException("Expecting Equipment Mo, received:" + parent.getParent().getClass().getName());
                    }
                    MessageLog.trace(1, THIS_CLASS, "Illegal parent");
                    throw new IllegalParentException("Expecting RbsSlotMo, received:" + parent.getClass().getName());
                }
                case 3: {
                    if (parent.getType().equals("Subrack")) {
                        MessageLog.trace(1, THIS_CLASS, " correct parent was selected:  BB/RF Subrack");
                        break;
                    }
                    if (parent.getType().equals("McpaSubrack")) {
                        MessageLog.trace(1, THIS_CLASS, "  correct parent was selected: MCPA Subrack");
                        break;
                    }
                    if (parent.getType().equals("PowerSupplySubrack")) {
                        MessageLog.trace(1, THIS_CLASS, " correct parent was selected:  PWR Subrack");
                        break;
                    }
                    MessageLog.trace(1, THIS_CLASS, "Illegal parent");
                    throw new IllegalParentException("Expecting BB/RF, MCPA or PWR subrack, received:" + parent.getClass().getName());
                }
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 13: 
                case 15: {
                    MessageLog.trace(1, THIS_CLASS, "Parent/parent-parent check removed for BFU, XALM, FCU, ASC, RETU, RRU. Wanja P5 shipment 4, reduced O & M dependencies.");
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    MessageLog.trace(1, THIS_CLASS, "Parent/parent-parent check not performed for ARETU, ATMAU, RUW, SCU, SAU, RRUW, XCU, TMF, AIR, IRU.");
                    break;
                }
                case 8: 
                case 9: 
                case 16: {
                    if (parent.getType().equals("Equipment")) {
                        MessageLog.trace(1, THIS_CLASS, " correct parent was selected: Equipment");
                        break;
                    }
                    MessageLog.trace(1, THIS_CLASS, "Illegal parent");
                    throw new IllegalParentException("Expecting EquipmentMoImpl, received:" + parent.getClass().getName());
                }
                case 28: {
                    if (parent.getType().equals("SectorAntenna")) {
                        MessageLog.trace(1, THIS_CLASS, " correct parent was selected: SectorAntenna");
                        break;
                    }
                    MessageLog.trace(1, THIS_CLASS, "Illegal parent");
                    throw new IllegalParentException("Expecting SectorAntennaMoImpl, received:" + parent.getClass().getName());
                }
                default: {
                    MessageLog.trace(1, THIS_CLASS, "Illegal parent:" + parent.getClass().getName());
                    throw new IllegalParentException("Unknown parent received:" + parent.getClass().getName());
                }
            }
        }
    }

    public static int getAdditionalInfo(ManagedObject parent, String id, int auType, Coordinator context) throws IllegalParentException, MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getAdditionalInfo  " + auType);
        int froId = 0;
        int slotPosition = 0;
        int subrackType = 0;
        int notValid = -1;
        int result2 = 0;
        int radioBuildingBlockType = 0;
        switch (auType) {
            case 1: 
            case 14: {
                if (parent.getType().equals("RbsSlot")) {
                    MessageLog.trace(1, THIS_CLASS, "  rbsSlot position requested");
                    slotPosition = ((RbsSlotMo)parent).getSlotPosition(context);
                    MessageLog.trace(1, THIS_CLASS, "slotPosition: " + slotPosition);
                }
                result2 = slotPosition;
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 15: {
                if (parent.getType().equals("RbsSlot")) {
                    MessageLog.trace(1, THIS_CLASS, "  no additionalInformation for AU type " + auType + ", returned notValid: " + -1);
                }
                result2 = -1;
                break;
            }
            case 2: {
                if (parent.getType().equals("CuSubrack")) {
                    MessageLog.trace(1, THIS_CLASS, "  no additionalInformation for AU type CU, returned notValid: -1");
                }
                result2 = -1;
                break;
            }
            case 3: {
                if (parent.getType().equals("Subrack") || parent.getType().equals("McpaSubrack") || parent.getType().equals("PowerSupplySubrack")) {
                    MessageLog.trace(1, THIS_CLASS, "subrack Type  requested");
                    subrackType = AuxPlugInUnitAttributesChecker.getSubrackType(parent, auType, context);
                    MessageLog.trace(1, THIS_CLASS, "  subrack Type  returned subrackType " + subrackType);
                }
                result2 = subrackType;
                break;
            }
            case 5: 
            case 7: 
            case 17: 
            case 18: 
            case 25: {
                if (parent.getType().equals("SectorAntenna")) {
                    MessageLog.trace(1, THIS_CLASS, "Sector's froId  requested");
                    SectorAntennaMo sectorAntenna = (SectorAntennaMo)parent;
                    ManagedObject[] mos = sectorAntenna.getReservedBy(context);
                    SectorMo sectorMoRef = (SectorMo)mos[0];
                    froId = sectorMoRef.getFroId(context);
                    MessageLog.trace(1, THIS_CLASS, "Sector's froId  returned :" + froId);
                } else if (parent.getType().equals("ExternalAntenna")) {
                    MessageLog.trace(1, THIS_CLASS, "Sector's froId  requested");
                    ExternalAntennaMo externalAntennaMo = (ExternalAntennaMo)parent;
                    froId = ((SectorMo)externalAntennaMo.getSectorRef(context)).getFroId(context);
                    MessageLog.trace(1, THIS_CLASS, "Sector's froId  returned :" + froId);
                }
                result2 = froId;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 27: {
                if (parent.getType().equals("Equipment")) {
                    MessageLog.trace(1, THIS_CLASS, "  no additionalInformation for AU type " + auType + ", returned notValid: " + -1);
                }
                result2 = -1;
                break;
            }
            case 28: {
                if (parent.getType().equals("SectorAntenna")) {
                    MessageLog.trace(1, THIS_CLASS, "  no additionalInformation for AU type " + auType + ", returned notValid: " + -1);
                }
                result2 = -1;
                break;
            }
            case 26: {
                if (parent.getType().equals("SectorAntenna")) {
                    MessageLog.trace(1, THIS_CLASS, "Rbb Type requested!");
                    SectorAntennaMo sectorAntenna = (SectorAntennaMo)parent;
                    ManagedObject[] mos = sectorAntenna.getReservedBy(context);
                    GenSectorMo sectorMoRef = null;
                    for (int index = 0; index < mos.length; ++index) {
                        if (!(mos[index] instanceof SectorMo)) continue;
                        sectorMoRef = (SectorMo)mos[index];
                        break;
                    }
                    if (sectorMoRef != null) {
                        radioBuildingBlockType = sectorMoRef.getRadioBuildingBlock(context);
                    }
                }
                result2 = radioBuildingBlockType;
                break;
            }
        }
        return result2;
    }

    public static int checkExternalAntenna(ManagedObject parent, Coordinator context) throws IllegalParentException, MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "checkExternalAntenna() parent: " + parent.getFullDistinguishedName());
        boolean perantTypeExternalAntenna = true;
        boolean perantTypeNotExternalAntenna = false;
        int result2 = 0;
        if (parent.getType().equals("ExternalAntenna")) {
            result2 = 1;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public static int auType2FroObjectType(int auType) throws ValueOutOfRangeException {
        void var1_1;
        MessageLog.traceEnter(THIS_CLASS, "auType2FroObjectType()<---");
        switch (auType) {
            case 1: {
                int froType = 49153;
                break;
            }
            case 2: {
                int froType = 49154;
                break;
            }
            case 3: {
                int froType = 49155;
                break;
            }
            case 4: {
                int froType = 49156;
                break;
            }
            case 5: {
                int froType = 49157;
                break;
            }
            case 6: {
                int froType = 49158;
                break;
            }
            case 7: {
                int froType = 49159;
                break;
            }
            case 8: {
                int froType = 49160;
                break;
            }
            case 9: {
                int froType = 49161;
                break;
            }
            case 10: {
                int froType = 49162;
                break;
            }
            case 11: {
                int froType = 49163;
                break;
            }
            case 12: {
                int froType = 49164;
                break;
            }
            case 13: {
                int froType = 49165;
                break;
            }
            case 14: {
                int froType = 49166;
                break;
            }
            case 15: {
                int froType = 49167;
                break;
            }
            case 16: {
                int froType = 49168;
                break;
            }
            case 18: {
                int froType = 49170;
                break;
            }
            case 17: {
                int froType = 49169;
                break;
            }
            case 19: {
                int froType = 49171;
                break;
            }
            case 20: {
                int froType = 49174;
                break;
            }
            case 24: {
                int froType = 49175;
                break;
            }
            case 25: {
                int froType = 49176;
                break;
            }
            case 26: {
                int froType = 49177;
                break;
            }
            case 27: {
                int froType = 49178;
                break;
            }
            case 28: {
                int froType = 49180;
                break;
            }
            default: {
                throw new ValueOutOfRangeException("auType", "AuxPlugInUnit", "FRO object type for auType=" + auType + " not defined in " + THIS_CLASS.getName() + ".auType2FroObjectType()");
            }
        }
        return (int)var1_1;
    }

    public static boolean isUpgradeablePlugInUnit(ManagedObject auxPiu, Coordinator context) {
        MessageLog.traceEnter(THIS_CLASS, "isUpgradeablePlugInUnit()<---");
        boolean bool = true;
        MoIterator moIter = auxPiu.getChildren();
        while (moIter.hasMoreElements()) {
            ManagedObject mo = moIter.nextMo();
            if (!(mo instanceof RetuDeviceGroupMo) && !(mo instanceof PauDeviceGroupMo) && !(mo instanceof SaiuDeviceGroupMo) && !(mo instanceof FuDeviceGroupMo) && !(mo instanceof FcuDeviceGroupMo) && !(mo instanceof PsuDeviceGroupMo) && !(mo instanceof CluDeviceGroupMo) && !(mo instanceof BfuDeviceGroupMo) && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "ATMAU") && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "RETU") && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "PAU") && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "SAIU") && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "FU") && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "FCU") && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "PSU") && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "CLU") && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "BFU") && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "TMF") && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "RD")) continue;
            MessageLog.trace(1, THIS_CLASS, "aux units: " + mo.getType() + " without loadable software shall not be upgradable");
            bool = false;
        }
        return bool;
    }

    private static int getSubrackType(ManagedObject parent, int auType, Coordinator context) throws IllegalParentException, MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getSubrackType  " + auType);
        int subrackType = 0;
        switch (auType) {
            case 1: {
                if (!parent.getType().equals("RbsSlot")) break;
                MessageLog.trace(1, THIS_CLASS, " McpaSubrack ");
                subrackType = 1;
                break;
            }
            case 2: {
                if (!parent.getType().equals("CuSubrack")) break;
                MessageLog.trace(1, THIS_CLASS, "  CuSubrack ");
                subrackType = 2;
                break;
            }
            case 4: {
                if (!parent.getType().equals("RbsSlot")) break;
                MessageLog.trace(1, THIS_CLASS, "  PowersupplySubrack");
                subrackType = 3;
                break;
            }
            case 3: {
                if (parent.getType().equals("Subrack")) {
                    MessageLog.trace(1, THIS_CLASS, "  BB/RF Subrack");
                    subrackType = 5;
                }
                if (parent.getType().equals("McpaSubrack")) {
                    MessageLog.trace(1, THIS_CLASS, "  MCPA Subrack");
                    subrackType = 1;
                }
                if (!parent.getType().equals("PowerSupplySubrack")) break;
                MessageLog.trace(1, THIS_CLASS, "  PWR Subrack");
                subrackType = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 17: 
            case 18: 
            case 25: {
                if (!parent.getType().equals("SectorAntenna")) break;
                MessageLog.trace(1, THIS_CLASS, "  Sector Subrack");
                subrackType = 5;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                if (!parent.getType().equals("Equipment")) break;
                MessageLog.trace(1, THIS_CLASS, " This AU type has no subrack");
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                MessageLog.trace(1, THIS_CLASS, " Rbs subrack ");
                subrackType = 8;
                break;
            }
        }
        return subrackType;
    }
}

