/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.device;

import enea.ose.system.InSignal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMaoi;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.MoTypeCheckMoTypeAndIdFilter;
import se.ericsson.wcdma.rbs.boam.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSetGrpPiuPositionRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetFanGroupParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetGroupParametersRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetTxGroupParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupHwLogConfigIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupStartedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcTestGroupEndIndS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.common.MoHelper;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupInfo;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.AscDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.DownlinkBaseBandPoolMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.UplinkBaseBandPoolMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyInitiatedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoNotLockedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ParameterValueErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.TestBoardDependencyException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CuSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbccDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.FcuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.HsDbchDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.McpaSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSlotMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSynchronizationMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.pnp.PlugAndPlay;

public class DeviceGroupMoImpl
extends BoamManagedObjectWithAlarms
implements DeviceGroupMo {
    public static final int MO_DATA_REVISION = 5020001;
    protected static final int SUP_CLIENT_ID = 0;
    public static final String GROUP_FRO_ID = "groupFroId";
    private static boolean AUX_DEVICE_GROUP = true;
    private static boolean DB_DEVICE_GROUP = false;
    private static HashMap supportedDeviceGroups = new HashMap();
    private boolean lockedARETs;
    protected MoEvents myMoEvents;
    protected PlugAndPlay myPnP = null;
    protected int thisFroId = 0;
    protected EqcDeviceGroupProxy eqcDeviceGroupProxy = EqcDeviceGroupProxy.instance();
    protected EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();

    public DeviceGroupMoImpl(ManagedObject parent, AttrList attributes, String userLabel, int checkedAlarmStatus, String identity, Coordinator context) throws MoAccessException, FroRequestFailedException {
        super(parent, "DeviceGroup", identity, context);
        if (identity == null) {
            identity = "";
        }
        String strIdentityUpperCase = identity.toUpperCase(Locale.ENGLISH);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        DeviceGroupInfo devGroupInfo = (DeviceGroupInfo)supportedDeviceGroups.get(strIdentityUpperCase);
        if (devGroupInfo == null) {
            throw new ValueOutOfRangeException("Device Group name is not valid!! MO identity: " + identity, this.getType());
        }
        EqcCreateGroupRspS createGroupRsp = this.createDeviceGroupResourceRsps(parent, devGroupInfo.deviceGroupFroObjectType, devGroupInfo.deviceGroupType, context);
        this.createMoDataAndInitAlarmStatus(userLabel, checkedAlarmStatus, (int)createGroupRsp.groupFroInfo.groupFroId, context);
        if (devGroupInfo.deviceGroupType == DB_DEVICE_GROUP) {
            DeviceGroupMoFactory.instance(devGroupInfo.deviceGroupTypeFromRbsTypes).createDeviceGroupMoTree(this, createGroupRsp, "", context);
        } else {
            AuxDeviceGroupMoFactory.instance(devGroupInfo.deviceGroupTypeFromRbsTypes).createDeviceGroupMoTree((ManagedObject)this, createGroupRsp, "", context);
        }
        if (strIdentityUpperCase.equals("FCU")) {
            this.extraInitActionForFCU(attributes, context);
        } else if (strIdentityUpperCase.equals("ASC")) {
            this.verifyThatThereIsNoExternalTma(context);
        } else if (strIdentityUpperCase.equals("TX")) {
            this.extraInitActionForTX(attributes, context);
        }
        this.addObservers(49552, context);
    }

    public DeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        String strIdentityUpperCase;
        DeviceGroupInfo dgInfo;
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        this.thisFroId = this.getGroupFroId(null);
        IntegerAttribute tmpIntegerAttr = new IntegerAttribute("hwTestResult", false);
        tmpIntegerAttr.setValue(3);
        this.myData.registerTransientAttr((Attribute)tmpIntegerAttr);
        String identity = this.getNamingAttributeValue();
        if (identity == null) {
            identity = "";
        }
        if ((dgInfo = (DeviceGroupInfo)supportedDeviceGroups.get(strIdentityUpperCase = identity.toUpperCase(Locale.ENGLISH))) == null) {
            MessageLog.traceError(this.getClass(), "illegal MO ID for Generic Device Group, this should never happen");
        }
        try {
            this.addObservers(49552, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
    }

    private void extraInitActionForFCU(AttrList attributes, Coordinator context) throws MoAccessException {
        int[] checkedCabinetParameters = ValidateAttributes.checkAndGetIntSeqAttribute(attributes, "cabinetParameters", "optional", FcuDeviceGroupMo.CABINET_PARAMETERS_DEF_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, 50, "DeviceGroup");
        this.setCabinetParameters(checkedCabinetParameters, context);
    }

    private void extraInitActionForTX(AttrList attributes, Coordinator context) throws MoAccessException {
        int checkedNumHsCodeResources = ValidateAttributes.checkAndGetIntAttribute(attributes, "numHsCodeResources", "optional", 0, TxDeviceGroupMo.NUM_HS_CODE_RESOURCES_MIN_VALUES, TxDeviceGroupMo.NUM_HS_CODE_RESOURCES_MAX_VALUES, "DeviceGroup");
        this.setNumHsCodeResources(checkedNumHsCodeResources, context);
    }

    private void createMoDataAndInitAlarmStatus(String userLabel, int checkedAlarmStatus, int gropuFroId, Coordinator context) throws TransactionRequiredException, MoAccessException {
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        IntegerAttribute tmpIntegerAttr = new IntegerAttribute("hwTestResult", false);
        tmpIntegerAttr.setValue(3);
        this.myData.registerTransientAttr((Attribute)tmpIntegerAttr);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute(GROUP_FRO_ID, gropuFroId);
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(5020001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(DeviceGroupMoImpl.class, "create()");
        if (parent == null || !(parent instanceof PlugInUnitMo) && !(parent instanceof PiuDeviceMo) && !(parent instanceof AuxPlugInUnitMo)) {
            String errMsg = parent == null ? "null" : parent.getClass().getName();
            throw new IllegalParentException("Expected parent is Cello PlugInUnit, PiuDeviceMo or Boam AuxPlugInUnit, received " + errMsg);
        }
        DeviceGroupMoImpl.checkTransaction(context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "DeviceGroup");
        int checkedAlarmStatus = DeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "DeviceGroup", context);
        ValidateAttributes.checkOtherAttributes(attributes, "DeviceGroup");
        return new DeviceGroupMoImpl(parent, attributes, checkedUserLabel, checkedAlarmStatus, identity, context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        return DeviceGroupMoImpl.create(parent, attributes, identity, context);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        ValidateAttributes.checkTransaction(context);
        String strIdentityUpperCase = this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH);
        if (strIdentityUpperCase.equals("RUIF") || strIdentityUpperCase.equals("OBIF") || strIdentityUpperCase.equals("STRX") || strIdentityUpperCase.equals("DUI")) {
            this.deleteUplinkDownlingBaseBandPool(context);
        } else if (strIdentityUpperCase.equals("TX")) {
            this.deleteExtraStepsFroTxDeviceGroup(context);
        } else if (strIdentityUpperCase.equals("TU")) {
            this.deleteExtraCheckForTuDeviceGroup(context);
        }
        if (this.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        MoIterator iter = this.getChildren();
        MessageLog.trace(1, this.getClass(), "delete device sets");
        if (iter != null) {
            while (iter.hasMoreElements()) {
                ManagedObject child = iter.nextMo();
                if (child instanceof DeviceSetMo) {
                    ((DeviceSetMo)child).sysDelete(context);
                    continue;
                }
                if (child instanceof AuxDeviceSetMo) {
                    ((AuxDeviceSetMo)child).sysDelete(context);
                    continue;
                }
                child.delete(context);
            }
        }
        this.eqcDeviceGroupProxy.deleteGroup(this.getTxIdTransactional(context), 0L, this.getGroupFroId(context));
        this.removeObservers(context);
        if (this.isAnyChildReserved(context)) {
            throw new ResourceLockedException("this MO has a child that is reserved");
        }
        super.delete(context);
    }

    public void deleteExtraCheckForTuDeviceGroup(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteExtraCheckForTuDeviceGroup");
        int admState = 0;
        ManagedObject parent = this.getParent();
        if (parent.getType().equals("PlugInUnit")) {
            admState = ((PlugInUnitMo)parent).getAdministrativeState(context);
        } else {
            MessageLog.traceError(this.getClass(), "Configuration not supported, Tu Device group should allways have PlugInUnit Mo as parent!! the parent: " + parent.getType());
        }
        if (admState != 0) {
            String errMsg = "To delete TU, PIU must be locked.";
            MessageLog.trace(1, this.getClass(), errMsg);
            throw new UndeletableMoException((ManagedObject)this);
        }
    }

    public void deleteExtraStepsFroTxDeviceGroup(Coordinator context) throws MoAccessException {
        HsDbchDeviceSetMo hsDbchDevSetMo;
        MessageLog.traceEnter(this.getClass(), "deleteExtraStepsFroTxDeviceGroup");
        if (this.isAnyChildReserved(context)) {
            SubrackMo subrack = (SubrackMo)DeviceGroupMoImpl.getAncestor(this, "Subrack");
            if (this.otherTxDeviceGroupExistsInSubrack(subrack)) {
                this.informCarriersAtDelete(context);
            } else {
                MessageLog.trace(1, this.getClass(), " A child MO is reserved and the subtree cannot be deleted.");
                throw new UndeletableMoException((ManagedObject)this);
            }
        }
        if ((hsDbchDevSetMo = this.getHsDbchDeviceSetMoIfIsInPlace(context)) != null) {
            hsDbchDevSetMo.sysDelete(context);
        }
    }

    private void deleteUplinkDownlingBaseBandPool(Coordinator context) throws MoAccessException {
        ManagedObject existingMo;
        MessageLog.trace(1, this.getClass(), "deleteUplinkDownlingBaseBandPool()");
        MoIterator MoTypeExistsItr = MoRepository.instance().lookupType("DownlinkBaseBandPool");
        if (MoTypeExistsItr != null) {
            while (MoTypeExistsItr.hasMoreElements()) {
                existingMo = MoTypeExistsItr.nextMo();
                ((DownlinkBaseBandPoolMoImpl)existingMo).sysDelete(this, context);
            }
        }
        if ((MoTypeExistsItr = MoRepository.instance().lookupType("UplinkBaseBandPool")) != null) {
            while (MoTypeExistsItr.hasMoreElements()) {
                existingMo = MoTypeExistsItr.nextMo();
                ((UplinkBaseBandPoolMoImpl)existingMo).sysDelete(this, context);
            }
        }
    }

    protected void checkNumberOfChildren(MoFilter myCriteria, ManagedObject startMo, int maxNoOfChildren, String typeName, Coordinator context) throws MoAccessException {
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getUsageState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUsageState()");
        EqcGetGroupParametersRspS rspSig = this.eqcDeviceGroupProxy.getGroupParameters(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context));
        return rspSig.usageState;
    }

    public void actionStartHwTest(String testId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartHwTest()");
        ValidateAttributes.stringValueRangeCheck("actionStartHwTest::testId", testId, 32, this.getType());
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.boardDependencyCheckUc1Fs(context);
        try {
            this.lockedARETs = this.lockAretWhenAirHwTestStart(context);
        }
        catch (MoAccessException e) {
            this.updateHwTestResult(1);
            throw new OperationFailedException();
        }
        try {
            this.eqcDeviceGroupProxy.startDeviceGroupHwTest(0L, this.getGroupFroId(context), testId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 13) {
                this.updateHwTestResult(2);
                throw new AlreadyInitiatedException();
            }
            this.unlockAretWhenAirHwTest();
            if (e.getOrgErrorCode() == 9) {
                throw new MoNotLockedException();
            }
            if (e.getOrgErrorCode() == 25) {
                throw new FunctionNotSupportedException();
            }
            this.updateHwTestResult(3);
            if (e.getOrgErrorCode() == 39) {
                throw new TestBoardDependencyException();
            }
            throw new OperationFailedException();
        }
        catch (MoAccessException e) {
            this.unlockAretWhenAirHwTest();
            throw e;
        }
        this.updateHwTestResult(2);
    }

    private boolean lockAretWhenAirHwTestStart(Coordinator context) throws MoAccessException {
        AuxPlugInUnitMo auxPiuMo;
        MessageLog.traceEnter(this.getClass(), "lockAretWhenAirHwTestStart()");
        boolean isAretLocked = false;
        if (this.getParent() instanceof AuxPlugInUnitMo) {
            auxPiuMo = (AuxPlugInUnitMo)this.getParent();
            if (auxPiuMo.getAuType(context) != 26) {
                return isAretLocked;
            }
        } else {
            return isAretLocked;
        }
        ArrayList auxPiuMoForAretList = this.findAretListFromAir(auxPiuMo, context);
        if (auxPiuMoForAretList.isEmpty()) {
            return isAretLocked;
        }
        try {
            TransactionWrapper tw = new TransactionWrapper();
            Coordinator twContext = tw.getCoordinator();
            Iterator itAretList = auxPiuMoForAretList.iterator();
            while (itAretList.hasNext()) {
                AuxPlugInUnitMo auxPiuMoForAret = (AuxPlugInUnitMo)itAretList.next();
                if (auxPiuMoForAret.getAdministrativeState(context) == 0) continue;
                auxPiuMoForAret.setAdministrativeState(0, twContext);
            }
            tw.commit();
            isAretLocked = true;
        }
        catch (TransactionRolledBackException e) {
            MessageLog.traceError(this.getClass(), "fail to create a transaction to lock aret!");
            e.printStackTrace();
            throw new OperationFailedException();
        }
        catch (InactiveTransactionException e) {
            MessageLog.traceError(this.getClass(), "fail to commit transaction when lock aret!");
            e.printStackTrace();
            throw new OperationFailedException();
        }
        return isAretLocked;
    }

    private ArrayList findAretListFromAir(AuxPlugInUnitMo auxPiuMo, Coordinator context) throws MoAccessException {
        ArrayList<AuxPlugInUnitMo> result2 = new ArrayList<AuxPlugInUnitMo>();
        if (auxPiuMo.getAuType(context) != 26) {
            return result2;
        }
        SectorAntennaMo sectorAntennaMo = (SectorAntennaMo)auxPiuMo.getParent();
        SectorMo sectorMo = this.getSectorMoRef(sectorAntennaMo, context);
        ManagedObject[] reservedBySector = sectorMo.getReservedBy(context);
        for (int j = 0; j < reservedBySector.length; ++j) {
            ManagedObject mo = reservedBySector[j];
            String antMoRDN = mo.getRelativeDistinguishedName();
            if (-1 == antMoRDN.indexOf("ExternalAntenna")) continue;
            MoIterator it = mo.getChildren();
            while (it.hasMoreElements()) {
                ManagedObject ChildMo = it.nextMo();
                String childMoRDN = ChildMo.getRelativeDistinguishedName();
                if (-1 == childMoRDN.indexOf("AuxPlugInUnit")) continue;
                AuxPlugInUnitMo auxPiuMoForAret = (AuxPlugInUnitMo)ChildMo;
                result2.add(auxPiuMoForAret);
            }
        }
        return result2;
    }

    private void unlockAretWhenAirHwTest() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "unlockAretWhenAirHwTest()");
        if (!this.lockedARETs) {
            return;
        }
        AuxPlugInUnitMo auxPiuMoForAir = (AuxPlugInUnitMo)this.getParent();
        try {
            TransactionWrapper tw = new TransactionWrapper();
            Coordinator context = tw.getCoordinator();
            ArrayList auxPiuMoForAretList = this.findAretListFromAir(auxPiuMoForAir, context);
            if (auxPiuMoForAretList.isEmpty()) {
                this.lockedARETs = false;
                return;
            }
            Iterator itAretList = auxPiuMoForAretList.iterator();
            while (itAretList.hasNext()) {
                AuxPlugInUnitMo auxPiuMoForAret = (AuxPlugInUnitMo)itAretList.next();
                if (auxPiuMoForAret.getAdministrativeState(context) == 1) continue;
                auxPiuMoForAret.setAdministrativeState(1, context);
            }
            tw.commit();
            this.lockedARETs = false;
        }
        catch (TransactionRolledBackException e) {
            MessageLog.traceError(this.getClass(), "fail to create a transaction to unlock aret!");
            e.printStackTrace();
            throw new OperationFailedException();
        }
        catch (InactiveTransactionException e) {
            MessageLog.traceError(this.getClass(), "fail to commit transaction when unlock aret!");
            e.printStackTrace();
            throw new OperationFailedException();
        }
    }

    private void checkRfifState(String identity, Coordinator context) throws MoAccessException {
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs(),Start precondition 5");
        if ("TRX".equalsIgnoreCase(identity)) {
            ManagedElementMo me = (ManagedElementMo)MibMgr.instance().getMib().getRootMo();
            String rbsType = me.getProductName(context);
            SlotMo slotMo = (SlotMo)DeviceGroupMoImpl.getAncestor(this, "Slot");
            SlotMo slotMoNr2 = null;
            SlotMo slotMoNr3 = null;
            ManagedObject rfifMo = null;
            ManagedObject deviceGroupRfifMo = null;
            SubrackMo srMo = (SubrackMo)slotMo.getParent();
            MoIterator moIter = BoamHelper.findMOs("Slot", (ManagedObject)srMo, 1);
            while (moIter.hasMoreElements() && slotMoNr2 == null && slotMoNr3 == null) {
                SlotMo element = (SlotMo)moIter.nextMo();
                if (2 == element.getSlotNumber(context)) {
                    slotMoNr2 = element;
                    continue;
                }
                if (3 != element.getSlotNumber(context)) continue;
                slotMoNr3 = element;
            }
            int trxSlotNo = slotMo.getSlotNumber(context);
            if ("3101".equalsIgnoreCase(rbsType) || "3202".equalsIgnoreCase(rbsType)) {
                if (trxSlotNo == 4 || trxSlotNo == 7 || trxSlotNo == 10) {
                    rfifMo = BoamHelper.getFirstMatchingMo(slotMoNr2, "RfifDeviceGroup");
                    deviceGroupRfifMo = BoamHelper.getMatchingMo((ManagedObject)slotMoNr2, "DeviceGroup", "RFIF");
                } else if (trxSlotNo == 5 || trxSlotNo == 8 || trxSlotNo == 11) {
                    rfifMo = BoamHelper.getFirstMatchingMo((ManagedObject)slotMoNr3, "RfifDeviceGroup");
                    deviceGroupRfifMo = BoamHelper.getMatchingMo((ManagedObject)slotMoNr3, "DeviceGroup", "RFIF");
                }
            } else if ("3103".equalsIgnoreCase(rbsType) || "3104".equalsIgnoreCase(rbsType)) {
                rfifMo = BoamHelper.getFirstMatchingMo("RfifDeviceGroup");
                deviceGroupRfifMo = BoamHelper.getFirstMatchingMo("DeviceGroup", "RFIF");
            }
            if (rfifMo != null && !this.checkRefState(rfifMo, context)) {
                this.throwTestBoardDependencyException("The Rfif must be unlocked and enabled !!rfifMo:" + rfifMo.getLocalDistinguishedName());
            }
            if (deviceGroupRfifMo != null && !this.checkRefState(deviceGroupRfifMo, context)) {
                MessageLog.trace(2, this.getClass(), "startHwTest refused: The Rfif must be unlocked and enabled !!rfifMo:" + rfifMo.getLocalDistinguishedName());
                this.throwTestBoardDependencyException("The Rfif must be unlocked and enabled !!rfifMo:" + deviceGroupRfifMo.getLocalDistinguishedName());
            }
        }
    }

    private void boardDependencyCheckUc1Fs(Coordinator context) throws MoAccessException, TestBoardDependencyException {
        RbsSynchronizationMo rbsSync;
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs(), Start precondition 1");
        if (this.getHwTestResult(context) == 2) {
            MessageLog.trace(2, this.getClass(), "startHwTest refused: The test is already initiated!!");
            throw new AlreadyInitiatedException();
        }
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs(), Start precondition 2");
        String identity = this.getNamingAttributeValue();
        if ("RD".equals(identity) || "PAU".equals(identity) || "SAIU".equals(identity)) {
            MessageLog.trace(2, this.getClass(), "startHwTest refused: function is not supported for type: " + this.getLocalDistinguishedName());
            throw new FunctionNotSupportedException("startHwTest refused: function is not supported for type: " + this.getLocalDistinguishedName());
        }
        if (this.isDuw() && ("RAX".equals(identity) || "TX".equals(identity))) {
            this.updateHwTestResult(3);
            throw new FunctionNotSupportedException("startHwTest refused: function is not supported on DUW for type: " + this.getLocalDistinguishedName());
        }
        if ("AuxPlugInUnit".equalsIgnoreCase(this.getParent().getType())) {
            ManagedObject mo1 = ((AuxPlugInUnitMo)this.getParent()).getPlugInUnitRef1(context);
            ManagedObject mo2 = ((AuxPlugInUnitMo)this.getParent()).getPlugInUnitRef2(context);
            if (mo2 == null && !this.checkRefState(mo1, context) || mo2 != null && !this.checkRefState(mo1, context) && !this.checkRefState(mo2, context)) {
                this.throwTestBoardDependencyException("Precondition on referred PIUs (piuRef1/piuRef2) not met. At least one of the PIUs with the ATF must be unlocked/enabled!!");
            }
        }
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs(), Start precondition 3");
        if (("TX".equalsIgnoreCase(identity) || "RAX".equalsIgnoreCase(identity) || "RFIF".equalsIgnoreCase(identity) || "TRX".equalsIgnoreCase(identity) || "AIU".equalsIgnoreCase(identity) || "RU".equalsIgnoreCase(identity) || "RRU".equalsIgnoreCase(identity) || "OBIF".equalsIgnoreCase(identity) || "DUI".equalsIgnoreCase(identity) || "RUW".equalsIgnoreCase(identity) || "RRUW".equalsIgnoreCase(identity)) && !(rbsSync = (RbsSynchronizationMo)BoamHelper.getFirstMatchingMo("RbsSynchronization")).getNodeIsSynchronized(context) && !rbsSync.getNodeIsStable(context)) {
            this.throwTestBoardDependencyException("The base band clock must be distributed. Attribute NodeIsSynchronized or NodeIsStable on the RbsSynchronizationMo must be true! !!");
        }
        if (!this.isDuw()) {
            this.checkRfifState(identity, context);
        }
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs(),Start precondition 6");
        if ("ASC".equalsIgnoreCase(identity) || "ATMAU".equalsIgnoreCase(identity) || "RETU".equalsIgnoreCase(identity) || "TMF".equalsIgnoreCase(identity)) {
            if (!MoHelper.checkMosOpState("SaiuDeviceGroup", context)) {
                this.throwTestBoardDependencyException("The sAIU of all instances must be enabled !!");
            }
            if (!MoHelper.checkMosOpState("AiuDeviceGroup", context)) {
                this.throwTestBoardDependencyException("The AIU of all instances must be enabled !!");
            }
            if (!MoHelper.checkMosOpState("RuDeviceGroup", context)) {
                this.throwTestBoardDependencyException("The RU of all instances must be enabled !!");
            }
            if (!MoHelper.checkMosOpState("FuDeviceGroup", context)) {
                this.throwTestBoardDependencyException("The FU of all instances must be enabled !!");
            }
        }
    }

    private void throwTestBoardDependencyException(String message) throws TestBoardDependencyException {
        String longMessage = "startHwTest refused: " + message;
        MessageLog.trace(2, this.getClass(), longMessage);
        throw new TestBoardDependencyException(longMessage);
    }

    private boolean checkRefState(ManagedObject moRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkRefState()");
        if (moRef instanceof PlugInUnitMo) {
            PlugInUnitMo piu = (PlugInUnitMo)moRef;
            MessageLog.trace(2, this.getClass(), "Instance of PlugInUnitMo" + moRef + " with OperationalState: " + piu.getOperationalState(context) + " and administrativeState " + piu.getAdministrativeState(context));
            if (piu.getOperationalState(context) == 1 && piu.getAdministrativeState(context) == 1) {
                return true;
            }
        } else if (moRef instanceof AuxPlugInUnitMo) {
            AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)moRef;
            MessageLog.trace(2, this.getClass(), "Instance of AuxPlugInUnitMo" + moRef + " with OperationalState: " + auxPiu.getOperationalState(context) + " and administrativeState " + auxPiu.getAdministrativeState(context));
            if (auxPiu.getOperationalState(context) == 1 && auxPiu.getAdministrativeState(context) == 1) {
                return true;
            }
        }
        return false;
    }

    public int getHwTestResult(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getHwTestResult()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute("hwTestResult");
        int result2 = attribute.getValue(context);
        return result2;
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        EqcGetGroupParametersRspS rspSig = this.eqcDeviceGroupProxy.getGroupParameters(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context));
        return rspSig.opState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        EqcGetGroupParametersRspS rspSig = this.eqcDeviceGroupProxy.getGroupParameters(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.availStatus);
    }

    public int getGroupFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getGroupFroId()");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute(GROUP_FRO_ID);
        MessageLog.traceEnter(this.getClass(), "getGroupFroId() returned" + attribute.getValue(context));
        return attribute.getValue(context);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.getGroupFroId(context);
    }

    public int getParentFroId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getParentFroId()");
        ManagedObject parent = this.getParent();
        if (parent.getType().equals("PlugInUnit")) {
            return ((PlugInUnitMo)parent).getFroId(c);
        }
        if (parent.getType().equals("PiuDevice")) {
            return ((PiuDeviceMo)parent).getFroId(c);
        }
        if (parent instanceof MaoHasFro) {
            return ((MaoHasFro)parent).getFroId(c);
        }
        throw new IllegalParentException("parent " + parent.getType() + " is not supported by generic device group");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void eventRaised(InSignal eventInd) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        String objectClass = this.getType();
        String managedObjectInstance = this.getFullDistinguishedName();
        String unknownEventType = "0";
        String emptyEventTime = "";
        if (eventInd instanceof EqcGroupEventIndS) {
            String specificEvent;
            MessageLog.trace(6, this.getClass(), "EqcGroupEventIndS received");
            EqcGroupEventIndS recSig = (EqcGroupEventIndS)eventInd;
            int groupEventType = recSig.groupEventType;
            String additionalText = this.bcmGetMEUserLabel();
            if (groupEventType == 49153) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedBoardRestart";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (groupEventType == 49154) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedWarmReset";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (groupEventType == 49157) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedSwitchedClockSource";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (groupEventType == 49156) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedReestablishLink";
                additionalText = recSig.additionalTextEvent;
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (groupEventType == 49158) {
                specificEvent = this.getType() + "_PreloadFailed";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (groupEventType == 49160 && this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH).equals("RUW")) {
                specificEvent = this.getType() + "_MaintenanceButtonInitiatedBoardRestart";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else {
                MessageLog.traceError(this.getClass(), "Unknown event received");
                return;
            }
            new Event(objectClass, managedObjectInstance, "0", "", specificEvent, additionalText, null);
            MessageLog.trace(6, this.getClass(), "Event raised MO = " + objectClass + " " + "eventType = " + "0" + " " + "specificEvent = " + specificEvent);
        } else if (eventInd instanceof EqcTestGroupEndIndS) {
            MessageLog.trace(6, this.getClass(), "EqcTestGroupEndIndS received");
            EqcTestGroupEndIndS recSig = (EqcTestGroupEndIndS)eventInd;
            if ((long)this.thisFroId == recSig.groupFroId) {
                try {
                    String specificEvent = this.getType() + "_HardwareTestEndIndication";
                    String additionalText = recSig.testId.name;
                    AdditionalInfo[] additionalInfoList = new AdditionalInfo[4];
                    this.updateTestResult(additionalInfoList, recSig);
                    new Event(objectClass, managedObjectInstance, "0", "", specificEvent, additionalText, additionalInfoList);
                    this.updateHwTestResult(recSig.testResult);
                    this.unlockAretWhenAirHwTest();
                }
                catch (MoAccessException ignoredException) {
                    MessageLog.trace(6, this.getClass(), "Can not update HW Test Result.");
                }
            }
        } else if (eventInd instanceof EqcGroupStartedIndS) {
            try {
                if ((long)this.thisFroId == ((EqcGroupStartedIndS)eventInd).groupFroId) {
                    this.updateHwLogSiteConfig();
                }
            }
            catch (MoAccessException ignoredException) {
                MessageLog.trace(6, this.getClass(), "Can not update HW Log.");
            }
        } else if (eventInd instanceof EqcGroupHwLogConfigIndS) {
            try {
                if ((long)this.thisFroId == ((EqcGroupHwLogConfigIndS)eventInd).groupFroId) {
                    MoHelper.updateHwLogConfig(this.thisFroId, 0, this);
                }
            }
            catch (MoAccessException ignoredException) {
                MessageLog.trace(6, this.getClass(), "Can not update HW Log.");
            }
        }
    }

    public void updateHwLogSiteConfig() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "updateHwLogSiteConfig()");
        ManagedElementMo rootmo = (ManagedElementMo)MibMgr.instance().getMib().getRootMo();
        String rbstype = rootmo.getProductName(null);
        String logName = rootmo.getLogicalName(null);
        StringBuffer freeText = new StringBuffer(rbstype + ";" + "Site " + logName + "; ");
        ManagedObject grandParent = null;
        ManagedObject greatGrandParent = null;
        if (this.getParent().getType().equals("PiuDevice")) {
            grandParent = this.getParent().getParent().getParent();
            greatGrandParent = grandParent.getParent();
        } else {
            grandParent = this.getParent().getParent();
            greatGrandParent = grandParent.getParent();
        }
        if (grandParent instanceof SlotMo && greatGrandParent instanceof SubrackMo) {
            freeText.append("subrack " + ((SubrackMo)greatGrandParent).getSubrackPosition(null));
            freeText.append("; slot " + ((SlotMo)grandParent).getSlotNumber(null));
        } else if (grandParent instanceof RbsSlotMo) {
            if (greatGrandParent instanceof PowerSupplySubrackMo) {
                freeText.append("power supply subrack " + ((PowerSupplySubrackMo)greatGrandParent).getSubrackPosition(null));
            } else if (greatGrandParent instanceof McpaSubrackMo) {
                freeText.append("MCPA subrack " + ((McpaSubrackMo)greatGrandParent).getSubrackPosition(null));
            } else if (greatGrandParent instanceof RbsSubrackMo) {
                freeText.append("RBS subrack " + ((RbsSubrackMo)greatGrandParent).getSubrackPosition(null));
            } else {
                freeText.append("subrack info not supported");
            }
            freeText.append("; slot " + ((RbsSlotMo)grandParent).getSlotPosition(null));
        } else if (grandParent instanceof PowerSupplySubrackMo) {
            freeText.append("power supply subrack " + ((PowerSupplySubrackMo)grandParent).getSubrackPosition(null));
            freeText.append("; slot N/A");
        } else if (grandParent instanceof McpaSubrackMo) {
            freeText.append("MCPA subrack " + ((McpaSubrackMo)grandParent).getSubrackPosition(null));
            freeText.append("; slot N/A");
        } else if (grandParent instanceof RbsSubrackMo) {
            freeText.append("RBS subrack " + ((RbsSubrackMo)grandParent).getSubrackPosition(null));
            freeText.append("; slot N/A");
        } else if (grandParent instanceof CuSubrackMo) {
            freeText.append("CU subrack " + ((CuSubrackMo)grandParent).getSubrackPosition(null));
            freeText.append("; slot N/A");
        } else if (grandParent instanceof SubrackMo) {
            freeText.append("subrack " + ((SubrackMo)grandParent).getSubrackPosition(null));
            freeText.append("; slot N/A");
        } else {
            freeText.append("subrack N/A; slot N/A");
        }
        this.eqcDeviceGroupProxy.updateGroupHwLog(0L, this.getGroupFroId(null), 0L, freeText.toString());
    }

    public void updateHwTestResult(int newResult) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "updateHwTestResult()");
        IntegerAttribute intAttribute = (IntegerAttribute)this.myData.getAttribute("hwTestResult");
        intAttribute.setValue(newResult);
        String[] attrArr = new String[]{"hwTestResult"};
        Object[] valArr = new Object[]{new Integer(newResult)};
        NotificationSender.instance().pushAVC((ManagedObject)this, attrArr, valArr);
    }

    protected void updateTestResult(AdditionalInfo[] infoList, EqcTestGroupEndIndS recSig) throws MoAccessException {
        if (recSig.testResult == 2) {
            recSig.testResult = 3;
        }
        switch (recSig.testResult) {
            case 0: {
                infoList[0] = new AdditionalInfo("Result", "Passed");
                break;
            }
            case 1: {
                infoList[0] = new AdditionalInfo("Result", "Failed");
                break;
            }
            case 3: {
                infoList[0] = new AdditionalInfo("Result", "Undetermined");
                break;
            }
            default: {
                infoList[0] = new AdditionalInfo("Result", "Unknown");
            }
        }
        infoList[1] = new AdditionalInfo("Test Time", Integer.toString(recSig.testTime == 0 ? 1 : recSig.testTime) + " sec");
        infoList[2] = new AdditionalInfo("Start Test Time", recSig.startTestTime);
        infoList[3] = new AdditionalInfo("Stop Test Time", recSig.stopTestTime);
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcBdhIndProxy, froType, this.getFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.eqcBdhIndProxy, this.getFroId(context), context);
        this.myPnP = new PlugAndPlay(this, this.eqcBdhIndProxy, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        if (this.myMoAlarms != null) {
            this.myMoAlarms.delete(context);
        }
        if (this.myMoEvents != null) {
            this.myMoEvents.delete(context);
        }
        if (this.myPnP != null) {
            this.myPnP.delete(context);
        }
    }

    public String getType() {
        return "DeviceGroup";
    }

    public EqcCreateGroupRspS createDeviceGroupResourceRsps(ManagedObject parent, int groupType, boolean deviceGroupType, Coordinator context) throws MoAccessException {
        int slotNo;
        int subrackId;
        MessageLog.traceEnter(this.getClass(), "createDeviceGroupResourceRsps()");
        int parentFroId = this.getParentFroId(context);
        ManagedObject positionRef = null;
        String boardLDN = parent.getLocalDistinguishedName();
        if (deviceGroupType == DB_DEVICE_GROUP) {
            SlotMo slotMo = (SlotMo)DeviceGroupMoImpl.getAncestor(this, "Slot");
            SubrackMo subrackMo = (SubrackMo)slotMo.getParent();
            subrackId = subrackMo.getResourceId(context);
            slotNo = slotMo.getSlotNumber(context);
            ManagedObject grandParent = parent.getParent();
            if (parent instanceof PlugInUnitMo) {
                PlugInUnitMo plugInUnit = (PlugInUnitMo)parent;
                positionRef = plugInUnit.getPositionRef(context);
            } else if (grandParent instanceof PlugInUnitMo) {
                PlugInUnitMo plugInUnit = (PlugInUnitMo)grandParent;
                positionRef = plugInUnit.getPositionRef(context);
            }
        } else {
            subrackId = this.findSubrackFroIdforAuxDeviceGroup(parent, context);
            slotNo = this.findSlotNumberForAuxDeviceGroup(parent, context);
            if (parent instanceof AuxPlugInUnitMo) {
                AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)parent;
                positionRef = auxPiu.getPositionRef(context);
                if (auxPiu.getAuType(context) == 27) {
                    boardLDN = auxPiu.getLocalDistinguishedName();
                }
            }
        }
        String posRef = "";
        if (positionRef != null) {
            posRef = positionRef.getLocalDistinguishedName();
        }
        EqcCreateGroupRspS rsp = this.eqcDeviceGroupProxy.createGroup(this.getTxIdTransactional(context), 0L, groupType, parentFroId, subrackId, slotNo, posRef, boardLDN);
        this.thisFroId = (int)rsp.groupFroInfo.groupFroId;
        MessageLog.trace(1, this.getClass(), "Device Group created with groupFroId = " + this.thisFroId);
        return rsp;
    }

    private int findSubrackFroIdforAuxDeviceGroup(ManagedObject thisMo, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "findSubrackFroIdforAuxDeviceGroup()");
        int resFroId = -1;
        ManagedObject sr = null;
        sr = thisMo.getParent() instanceof RbsSlotMo ? thisMo.getParent().getParent() : thisMo.getParent();
        if (sr instanceof RbsSubrackMo) {
            return ((RbsSubrackMo)sr).getRbsSubrackFroId(context);
        }
        if (sr instanceof McpaSubrackMo) {
            return ((McpaSubrackMo)sr).getMcpaSubrackFroId(context);
        }
        if (sr instanceof CuSubrackMo) {
            return ((CuSubrackMo)sr).getCuSubrackFroId(context);
        }
        if (sr instanceof PowerSupplySubrackMo) {
            return ((PowerSupplySubrackMo)sr).getPowerSupplySubrackFroId(context);
        }
        if (sr instanceof SubrackMaoi) {
            return ((SubrackMaoi)sr).getResourceId(context);
        }
        if (sr instanceof SectorAntennaMo) {
            return this.getSectorMoRef((SectorAntennaMo)sr, context).getSectorFroId(context);
        }
        return resFroId;
    }

    private int findSlotNumberForAuxDeviceGroup(ManagedObject thisMo, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "findSlotNumberForAuxDeviceGroup()");
        int resFroId = -1;
        if (thisMo.getParent() instanceof RbsSlotMo) {
            return ((RbsSlotMo)thisMo.getParent()).getSlotPosition(context);
        }
        return resFroId;
    }

    public int getAuxGroupFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAuxGroupFroId()");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute(GROUP_FRO_ID);
        return attribute.getValue(context);
    }

    public int getAuxPiuFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAuxPiuFroId()");
        DeviceGroupInfo devGroupInfo = (DeviceGroupInfo)supportedDeviceGroups.get(this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH));
        if (devGroupInfo.deviceGroupType == DB_DEVICE_GROUP) {
            throw new NoSuchAttributeException("This attribute is only valid for Aux device group.", "DeviceGroup");
        }
        return ((AuxPlugInUnitMo)this.getParent()).getAuxPlugInUnitFroId(context);
    }

    public void startupAuxDevGr(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "startupAuxDevGr()");
        this.eqcDeviceGroupProxy.startupGroup(0L, this.getAuxGroupFroId(context));
        MessageLog.trace(4, this.getClass(), "startupAuxDevGr executed ");
    }

    public void setCabinetParameters(int[] cabinetParameters, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCabinetParameters() <---");
        if (!this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH).equals("FCU")) {
            throw new NoSuchAttributeException("This operation is only valid for FCU device group.", "DeviceGroup");
        }
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (cabinetParameters == null) {
            throw new ParameterValueErrorException();
        }
        if (cabinetParameters.length > 50) {
            throw new ValueOutOfRangeException("cabinetParameters", this.getType());
        }
        for (int i = 0; i < cabinetParameters.length; ++i) {
            ValidateAttributes.intValueRangeCheck("cabinetParameters", cabinetParameters[i], FcuDeviceGroupMo.CABINET_PARAMETERS_MIN_VALUES, FcuDeviceGroupMo.CABINET_PARAMETERS_MAX_VALUES, this.getType());
        }
        this.eqcDeviceGroupProxy.setCabinetParameters(0, cabinetParameters, c.getTransactionID());
    }

    public int getFanUnitSpeedSetting(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFanUnitSpeedSetting()");
        if (!this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH).equals("FAN")) {
            throw new NoSuchAttributeException("This operation is only valid for FAN device group.", "DeviceGroup");
        }
        EqcGetFanGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getFanParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxGroupFroId(context));
        return rspSig.fanUnitSpeedSetting;
    }

    public int getSupplyAirTemperature(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSupplyAirTemperature()");
        if (!this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH).equals("FAN")) {
            throw new NoSuchAttributeException("This operation is only valid for FAN device group.", "DeviceGroup");
        }
        EqcGetFanGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getFanParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxGroupFroId(context));
        return rspSig.supplyAirTemperature;
    }

    private void verifyThatThereIsNoExternalTma(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(AscDeviceGroupMoImpl.class, "searchForExternalTma() <---");
        AuxPlugInUnitMo auxPlugInUnitMo = (AuxPlugInUnitMo)DeviceGroupMoImpl.getAncestor(this, "AuxPlugInUnit");
        ManagedObject antenna = auxPlugInUnitMo.getParent();
        MoIterator moIter = MoRepository.instance().select(antenna, 2, (MoFilter)new MoTypeFilter("ExternalTma"));
        int noOfExternalTma = moIter.size();
        if (noOfExternalTma > 0) {
            String msg = " AscDeviceGroup, TmaDeviceSet and TmaDevice MOs cannot be created because ExternalTma already exist. ExternalTma and AscDeviceGroup MOs exclude each other ";
            MessageLog.trace(1, AscDeviceGroupMoImpl.class, msg);
            throw new MoCanNotBeCreatedException(msg);
        }
    }

    public void setNumHsCodeResources(int value, Coordinator c) throws MoAccessException, FroRequestFailedException {
        MessageLog.traceEnter(this.getClass(), "setNumHsCodeResources()<---");
        if (!this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH).equals("TX")) {
            throw new NoSuchAttributeException("This operation is only valid for TX device group.", "DeviceGroup");
        }
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("numHsCodeResources", value, TxDeviceGroupMo.NUM_HS_CODE_RESOURCES_MIN_VALUES, TxDeviceGroupMo.NUM_HS_CODE_RESOURCES_MAX_VALUES, "TxDeviceGroup");
        int tpcMode = -1;
        int validParameter = 2;
        int l1AckMonitoring = -1;
        int numEulResources = -1;
        if (value < this.getNumHsCodeResources(c)) {
            this.checkHsNumCodeResourcesIdGreaterHsNumCodeResources(c, value);
        }
        this.eqcDeviceGroupProxy.setTxGroupParam(this.getTxIdTransactional(c), 0L, this.getGroupFroId(c), 2, -1, value, -1, -1);
        this.sendAVC("numHsCodeResources", value, c);
    }

    public int getNumHsCodeResources(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNumHsCodeResources()<---");
        if (!this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH).equals("TX")) {
            throw new NoSuchAttributeException("This operation is only valid for TX device group.", "DeviceGroup");
        }
        EqcGetTxGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getTxGroupParam(this.getTxIdNonTransactional(c), 0L, this.getGroupFroId(c));
        return rspSig.numHsCodeResources;
    }

    public int getNumEulResources(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNumEulResources()<---");
        if (!this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH).equals("TX")) {
            throw new NoSuchAttributeException("This operation is only valid for TX device group.", "DeviceGroup");
        }
        EqcGetTxGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getTxGroupParam(this.getTxIdNonTransactional(c), 0L, this.getGroupFroId(c));
        return rspSig.numEulResources;
    }

    public void setNumEulResources(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setNumEulResources()<---");
        if (!this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH).equals("TX")) {
            throw new NoSuchAttributeException("This operation is only valid for TX device group.", "DeviceGroup");
        }
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("numEulResources", value, TxDeviceGroupMo.NUM_EUL_RESOURCES_MIN_VALUES, TxDeviceGroupMo.NUM_EUL_RESOURCES_MAX_VALUES, "TxDeviceGroup");
        int tpcMode = -1;
        int validParameter = 4;
        int l1AckMonitoring = -1;
        int numHsCodeResources = -1;
        this.eqcDeviceGroupProxy.setTxGroupParam(this.getTxIdTransactional(c), 0L, this.getGroupFroId(c), 4, -1, -1, -1, value);
        this.sendAVC("numEulResources", value, c);
    }

    public boolean getIsHiMonitoringStarted(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIsHiMonitoringStarted()<---");
        if (!this.getNamingAttributeValue().toUpperCase(Locale.ENGLISH).equals("TX")) {
            throw new NoSuchAttributeException("This operation is only valid for TX device group.", "DeviceGroup");
        }
        return this.eqcDeviceGroupProxy.getHiMonitoring((int)0, (int)this.getGroupFroId((Coordinator)c)).isHiMonitoringStarted == 1;
    }

    public static boolean checkIfMoIsGenericDeviceGroupOfType(ManagedObject target, String strGenericDeviceMoId) {
        MessageLog.traceEnter(DeviceGroupMoImpl.class, "checkIfMoIsGenericDeviceGroupOfType()<---");
        return target != null && target instanceof DeviceGroupMo && target.getNamingAttributeValue().equalsIgnoreCase(strGenericDeviceMoId);
    }

    private void checkHsNumCodeResourcesIdGreaterHsNumCodeResources(Coordinator c, int v) throws MoAccessException {
        int sumHsNumCodeResources = v;
        ManagedObject carrier = null;
        ManagedObject rbsLocalCell = null;
        ManagedObject dbccDevice = null;
        MoIterator allTxDeviceGroupIter = BoamHelper.findMOs("DeviceGroup", "TX");
        while (allTxDeviceGroupIter.hasMoreElements()) {
            ManagedObject currMo = allTxDeviceGroupIter.nextMo();
            if (currMo.getFullDistinguishedName().equals(this.getFullDistinguishedName())) continue;
            sumHsNumCodeResources += ((TxDeviceGroupMo)currMo).getNumHsCodeResources(c);
        }
        MoIterator dbccDeviceIter = BoamHelper.findMOs("DbccDevice", this, 2);
        if (dbccDeviceIter != null) {
            while (dbccDeviceIter.hasMoreElements()) {
                dbccDevice = dbccDeviceIter.nextMo();
                if (((DbccDeviceMo)dbccDevice).getReservedBy(c).length <= 0 || ((CarrierMo)(carrier = ((DbccDeviceMo)dbccDevice).getReservedBy(c)[0])).getReservedBy(c).length <= 0 || sumHsNumCodeResources >= ((RbsLocalCellMo)(rbsLocalCell = ((CarrierMo)carrier).getReservedBy(c)[0])).getHsCodeResourceId(c)) continue;
                throw new ValueOutOfRangeException("numHsCodeResources", this.getType());
            }
        }
    }

    private boolean otherTxDeviceGroupExistsInSubrack(SubrackMo subrack) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "otherTxDeviceGroupExistsInSubrack()");
        MoIterator moIter = MoRepository.instance().select((ManagedObject)subrack, 4, (MoFilter)new MoTypeCheckMoTypeAndIdFilter("DeviceGroup", "TX"));
        while (moIter.hasMoreElements()) {
            if (moIter.nextMo() == this) continue;
            return true;
        }
        return false;
    }

    private void informCarriersAtDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "informCarriersAtDelete()");
        MoIterator dbccIter = MoRepository.instance().select((ManagedObject)this, 2, (MoFilter)new MoTypeFilter("DbccDevice"));
        while (dbccIter.hasMoreElements()) {
            DbccDeviceMo dbccDev = (DbccDeviceMo)dbccIter.nextMo();
            ManagedObject[] carriers = ((BoamManagedObject)((Object)dbccDev)).getReservedBy(context);
            for (int i = 0; i < carriers.length; ++i) {
                CarrierMo carrier = (CarrierMo)carriers[i];
                MessageLog.trace(1, this.getClass(), " Informing " + carrier.getLocalDistinguishedName() + " on deletion of " + dbccDev.getLocalDistinguishedName());
                carrier.deletingDbccDevice(dbccDev, context);
            }
        }
    }

    private HsDbchDeviceSetMo getHsDbchDeviceSetMoIfIsInPlace(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getHsDbchDeviceSetMoIfIsInPlace()");
        MoIterator iter = this.getChildren();
        HsDbchDeviceSetMo result2 = null;
        while (iter.hasMoreElements()) {
            Object child = iter.nextElement();
            if (!(child instanceof HsDbchDeviceSetMo)) continue;
            result2 = (HsDbchDeviceSetMo)child;
        }
        return result2;
    }

    private SectorMo getSectorMoRef(SectorAntennaMo sr, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSectorMoRef() ");
        SectorMo sectorMoref = null;
        ManagedObject[] reservers = null;
        try {
            reservers = sr.getReservedBy(context);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Not possible to get reservedBy attribute", e);
            throw e;
        }
        if (reservers != null) {
            for (int i = 0; i < reservers.length; ++i) {
                String type = reservers[i].getType();
                if (type.compareTo("Sector") != 0) continue;
                sectorMoref = (SectorMo)reservers[i];
            }
        }
        return sectorMoref;
    }

    private boolean isDuw() {
        return this.getParent().getType().equals("PiuDevice");
    }

    public EcSetGrpPiuPositionRspS setGrpPiuPositionReq(String positionRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(DeviceGroupMoImpl.class, "setGrpPiuPositionReq()");
        DeviceGroupMoImpl.checkTransaction(context);
        EcSetGrpPiuPositionRspS rsp = null;
        int groupFroId = this.getFroId(context);
        rsp = this.eqcDeviceGroupProxy.setGrpPiuPositionReq(this.getTxIdTransactional(context), 0L, groupFroId, positionRef);
        return rsp;
    }

    static {
        supportedDeviceGroups.put("OBIF", new DeviceGroupInfo(49576, 49576, DB_DEVICE_GROUP));
        supportedDeviceGroups.put("RUIF", new DeviceGroupInfo(49577, 49577, DB_DEVICE_GROUP));
        supportedDeviceGroups.put("RFIF", new DeviceGroupInfo(49574, 49574, DB_DEVICE_GROUP));
        supportedDeviceGroups.put("TU", new DeviceGroupInfo(49569, 49569, DB_DEVICE_GROUP));
        supportedDeviceGroups.put("AIU", new DeviceGroupInfo(49570, 49570, DB_DEVICE_GROUP));
        supportedDeviceGroups.put("RAX", new DeviceGroupInfo(49571, 49571, DB_DEVICE_GROUP));
        supportedDeviceGroups.put("STRX", new DeviceGroupInfo(49575, 49575, DB_DEVICE_GROUP));
        supportedDeviceGroups.put("TRX", new DeviceGroupInfo(49572, 49572, DB_DEVICE_GROUP));
        supportedDeviceGroups.put("TX", new DeviceGroupInfo(49573, 49573, DB_DEVICE_GROUP));
        supportedDeviceGroups.put("DUI", new DeviceGroupInfo(49582, 49582, DB_DEVICE_GROUP));
        supportedDeviceGroups.put("XALM", new DeviceGroupInfo(49558, 49558, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("CLU", new DeviceGroupInfo(49568, 49568, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("FAN", new DeviceGroupInfo(49555, 49555, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("FCU", new DeviceGroupInfo(49565, 49565, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("BFU", new DeviceGroupInfo(49567, 49567, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("CU", new DeviceGroupInfo(49554, 49554, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("PAU", new DeviceGroupInfo(49560, 49560, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("PCU", new DeviceGroupInfo(49556, 49556, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("PSU", new DeviceGroupInfo(49566, 49566, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("RRU", new DeviceGroupInfo(49562, 49562, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("ASC", new DeviceGroupInfo(800004, 49557, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("FU", new DeviceGroupInfo(49564, 49564, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("MCPA", new DeviceGroupInfo(49553, 49553, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("RETU", new DeviceGroupInfo(49559, 49559, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("RU", new DeviceGroupInfo(49563, 49563, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("SAIU", new DeviceGroupInfo(49561, 49561, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("ATMAU", new DeviceGroupInfo(49578, 49578, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("RUW", new DeviceGroupInfo(49579, 49579, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("XCU", new DeviceGroupInfo(49583, 49583, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("TMF", new DeviceGroupInfo(49578, 49578, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("AIR", new DeviceGroupInfo(49584, 49584, AUX_DEVICE_GROUP));
        supportedDeviceGroups.put("RD", new DeviceGroupInfo(49588, 49588, AUX_DEVICE_GROUP));
    }
}

