/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.device;

import enea.ose.system.InSignal;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.MoEventable;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcMeasurementProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceSetProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDevSetEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetDevSetParametersRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceSetMo;

public abstract class DeviceSetMoImpl
extends BoamManagedObjectWithAlarms
implements DeviceSetMo,
MoEventable,
MaoHasFro {
    public static final String DEV_SET_FRO_ID = "devSetFroId";
    private static final String USER_LABEL = "userLabel";
    private static final int USER_LABEL_MIN_LENGTH = 0;
    private static final int USER_LABEL_MAX_LENGTH = 128;
    protected static final int CLIENT_ID = 0;
    protected MoEvents myMoEvents;
    protected EqcDeviceSetProxy eqcDeviceSetProxy = EqcDeviceSetProxy.instance();
    protected EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();
    protected ChcMeasurementProxy chcMeasurementProxy = ChcMeasurementProxy.instance();

    public DeviceSetMoImpl(ManagedObject parent, String thisMoName, int devSetFroId, String identity, Coordinator context, String userlabel) throws MoAccessException {
        super(parent, thisMoName, identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.bcmStoreAndRegisterIntAttribute(DEV_SET_FRO_ID, devSetFroId);
        this.bcmStoreAndRegisterStringAttribute(USER_LABEL, userlabel);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public DeviceSetMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()<---");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete() device set");
        if (this.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (this.getParent().getType().equals("Cbu")) {
            this.eqcDeviceSetProxy.deleteDevSet(this.getTxIdTransactional(context), 0L, this.getDevSetFroId(context));
        }
        MoIterator iter = this.getChildren();
        MessageLog.trace(1, this.getClass(), "delete devices");
        while (iter.hasMoreElements()) {
            Object child = iter.nextElement();
            if (!(child instanceof DeviceMo)) continue;
            ((DeviceMo)child).sysDelete(context);
        }
        this.myData.delete(context);
        this.removeObservers(context);
        super.delete(context);
        if (this.getParent().getType().equals("PlugInUnit")) {
            this.eqcDeviceSetProxy.deleteDevSet(this.getTxIdTransactional(context), 0L, this.getDevSetFroId(context));
        }
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        EqcGetDevSetParametersRspS rspSig = this.eqcDeviceSetProxy.getDevSetParameters(this.getTxIdNonTransactional(context), 0L, this.getDevSetFroId(context));
        return rspSig.opState;
    }

    public int getUsageState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getUsageState()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        EqcGetDevSetParametersRspS rspSig = this.eqcDeviceSetProxy.getDevSetParameters(this.getTxIdNonTransactional(context), 0L, this.getDevSetFroId(context));
        return rspSig.usageState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        EqcGetDevSetParametersRspS rspSig = this.eqcDeviceSetProxy.getDevSetParameters(this.getTxIdNonTransactional(context), 0L, this.getDevSetFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.availStatus);
    }

    public int getDevSetFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getDevSetFroId()");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute(DEV_SET_FRO_ID);
        return attribute.getValue(c);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.getDevSetFroId(context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetStringAttribute(USER_LABEL, context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute(USER_LABEL, value, 0, 128, this.getType(), context);
        this.sendAVC(USER_LABEL, value, context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void eventRaised(InSignal eventInd) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        String objectClass = this.getType();
        String managedObjectInstance = this.getFullDistinguishedName();
        String eventType = "0";
        String eventTime = "";
        if (eventInd instanceof EqcDevSetEventIndS) {
            MessageLog.trace(6, this.getClass(), "EqcDevSetEventIndS received");
            EqcDevSetEventIndS recSig = (EqcDevSetEventIndS)eventInd;
            String specificEvent = "";
            int eventIs = recSig.devSetEventType;
            if (eventIs == 49153) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedBoardRestart";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedBoardRestart");
            } else if (eventIs == 49154) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedWarmReset";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedWarmReset");
            } else if (eventIs == 49157) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedSwitchedClockSource";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedSwitchedClockSource");
            } else if (eventIs == 49156) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedReestablishLink";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedReestablishLink");
            } else {
                MessageLog.traceError(this.getClass(), "Unknown event received");
                return;
            }
            String additionalText = this.bcmGetMEUserLabel();
            new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, null);
            MessageLog.trace(6, this.getClass(), "Event raised MO = " + objectClass + " " + "eventType = " + eventType + " " + "specificEvent = " + specificEvent);
        }
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcBdhIndProxy, froType, this.getFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.eqcBdhIndProxy, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }
}

