/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.FuDeviceGroupMo;

public class FuDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements FuDeviceGroupMo {
    public static final int ALTERNATIVE_TMA = 0;
    public static final int ALTERNATIVE_EXT_TMA = 2;
    public static final int FEEDER_MODEM_ENABLE = 1;
    public static final int FEEDER_MODEM_DISABLE = 0;
    public static final int POWER_ENABLE = 1;
    public static final int POWER_DISABLE = 0;
    public static final int MO_DATA_REVISION = 3010001;

    public FuDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "FuDeviceGroupMoImpl recovery constructor() <---");
        ErrorMgr.shotDownIfNull((StringAttribute)recoveredData.getAttribute("userLabel"), "userLabel");
        ErrorMgr.shotDownIfNull((IntegerAttribute)recoveredData.getAttribute("auxGroupFroId"), "auxGroupFroId");
        ErrorMgr.shotDownIfNull((IntegerAttribute)recoveredData.getAttribute("alarmStatus"), "alarmStatus");
        try {
            this.addObservers(49564, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private FuDeviceGroupMoImpl(ManagedObject parent, String userLabel, int checkedAlarmStatus, String identity, Coordinator context) throws MoAccessException {
        super(parent, "FuDeviceGroup", identity, context, 1);
        MessageLog.traceEnter(this.getClass(), "FuDeviceGroupMoImpl() <---");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49564, context);
        RbsGroupFroInfoT groupFroInfo = rsp.groupFroInfo;
        int auxGroupFroId = (int)rsp.groupFroInfo.groupFroId;
        this.initMoData(userLabel, auxGroupFroId, context);
        this.initAlarmStatus(checkedAlarmStatus, context);
        AuxDeviceGroupMoFactory.instance(49564).createDeviceGroupMoTree((ManagedObject)this, groupFroInfo, "", context);
        this.addObservers(49564, context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(FuDeviceGroupMoImpl.class, "create() <---");
        ValidateAttributes.checkTransaction(context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "FuDeviceGroup");
        int checkedAlarmStatus = FuDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "FuDeviceGroup", context);
        ValidateAttributes.checkOtherAttributes(attributes, "FuDeviceGroup");
        return new FuDeviceGroupMoImpl(parent, checkedUserLabel, checkedAlarmStatus, identity, context);
    }

    public String getType() {
        return "FuDeviceGroup";
    }

    private void initMoData(String userLabel, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() <---");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.getMyMoData().setRevision(3010001);
    }
}

