/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import enea.ose.system.InSignal;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetTxGroupParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupEventIndS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DbDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoDisabledException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbccDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.HsDbchDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TxDeviceGroupMo;

public class TxDeviceGroupMoImpl
extends DbDeviceGroupMoImpl
implements TxDeviceGroupMo {
    public static final int MO_DATA_REVISION = 3040001;

    public TxDeviceGroupMoImpl(ManagedObject parent, AttrList attributes, String checkedUserLabel, int checkedAlarmStatus, int checkedNumHsCodeResources, String identity, Coordinator context) throws MoAccessException {
        super(parent, "TxDeviceGroup", attributes, identity, context, 1);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.initMoData(checkedUserLabel, context);
        this.initAlarmStatus(checkedAlarmStatus, context);
        EqcCreateGroupRspS RspS = this.createDeviceGroupResourceRsps(parent, 49573, context);
        DeviceGroupMoFactory.instance(49573).createDeviceGroupMoTree(this, RspS, "", context);
        this.setNumHsCodeResources(checkedNumHsCodeResources, context);
        this.myData.setRevision(3040001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(49573, context);
    }

    public TxDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        try {
            this.addObservers(49573, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(TxDeviceGroupMoImpl.class, "create()");
        ValidateAttributes.checkTransaction(context);
        TxDeviceGroupMoImpl.checkParent(parent, "TxDeviceGroup");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "TxDeviceGroup");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, TxDeviceGroupMo.ALARM_STATUS_MIN_VALUES, TxDeviceGroupMo.ALARM_STATUS_MAX_VALUES, "TxDeviceGroup");
        int checkedNumHsCodeResources = ValidateAttributes.checkAndGetIntAttribute(attributes, "numHsCodeResources", "optional", 0, TxDeviceGroupMo.NUM_HS_CODE_RESOURCES_MIN_VALUES, TxDeviceGroupMo.NUM_HS_CODE_RESOURCES_MAX_VALUES, "TxDeviceGroup");
        ValidateAttributes.checkAndGetIntAttribute(attributes, "numEulResources", "optional", 0, TxDeviceGroupMo.NUM_EUL_RESOURCES_MIN_VALUES, TxDeviceGroupMo.NUM_EUL_RESOURCES_MAX_VALUES, "TxDeviceGroup");
        ValidateAttributes.checkOtherAttributes(attributes, "TxDeviceGroup");
        return new TxDeviceGroupMoImpl(parent, attributes, checkedUserLabel, checkedAlarmStatus, checkedNumHsCodeResources, identity, context);
    }

    public void delete(Coordinator context) throws MoAccessException {
        HsDbchDeviceSetMo hsDbchDevSetMo;
        MessageLog.traceEnter(this.getClass(), "delete() mo:" + this.getFullDistinguishedName());
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (this.isAnyChildReserved(context)) {
            ManagedObject mo = TxDeviceGroupMoImpl.getAnotherTxDeviceGroupFromSameBBP(this, context);
            if (mo != null) {
                TxDeviceGroupMoImpl.informCarriersAtDelete(this, mo, context);
            } else {
                MessageLog.trace(1, this.getClass(), " A child MO is reserved and the subtree cannot be deleted.");
                throw new UndeletableMoException((ManagedObject)this);
            }
        }
        if ((hsDbchDevSetMo = this.getHsDbchDeviceSetMoIfIsInPlace(context)) != null) {
            hsDbchDevSetMo.sysDelete(context);
        }
        super.delete(context);
    }

    public static void extraActivityAfterCreate(ManagedObject targetMO, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(TxDeviceGroupMoImpl.class, "extraActivityAfterCreate()<---");
        ManagedObject anotherTxRef = TxDeviceGroupMoImpl.getAnotherTxDeviceGroupFromSameBBP(targetMO, c);
        if (anotherTxRef != null) {
            TxDeviceGroupMoImpl.informCarriersAtCreate(targetMO, anotherTxRef, c);
        } else {
            MessageLog.trace(1, TxDeviceGroupMoImpl.class, "No other TX present on same BBP, no share loading possible");
        }
    }

    private static void informCarriersAtCreate(ManagedObject targetMO, ManagedObject mo, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(TxDeviceGroupMoImpl.class, "informCarriersAtCreate()<---");
        TxDeviceGroupMoImpl.informCarriersForCreationOrDeletion(targetMO, mo, true, c);
    }

    private static void informCarriersAtDelete(ManagedObject targetMO, ManagedObject mo, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(TxDeviceGroupMoImpl.class, "informCarriersAtDelete()<---");
        TxDeviceGroupMoImpl.informCarriersForCreationOrDeletion(targetMO, mo, false, c);
    }

    private static void informCarriersForCreationOrDeletion(ManagedObject targetMO, ManagedObject mo, boolean creation, Coordinator c) throws MoAccessException {
        MoIterator dbccDevicesIter;
        int txDeviceGroupToDbccDeviceDepth = 2;
        MoIterator moIterator = dbccDevicesIter = creation ? BoamHelper.findMOs("DbccDevice", mo, 2) : BoamHelper.findMOs("DbccDevice", targetMO, 2);
        if (dbccDevicesIter.size() != 0) {
            while (dbccDevicesIter.hasMoreElements()) {
                DbccDeviceMo dbccDeviceRef = (DbccDeviceMo)dbccDevicesIter.nextMo();
                ManagedObject[] carriersForThatDbccDevice = dbccDeviceRef.getReservedBy(c);
                if (carriersForThatDbccDevice != null && carriersForThatDbccDevice.length != 0) {
                    for (int i = 0; i < carriersForThatDbccDevice.length; ++i) {
                        if (creation) {
                            if (((SectorMo)carriersForThatDbccDevice[i].getParent()).isSectorInitialized(c)) {
                                ((CarrierMo)carriersForThatDbccDevice[i]).addingTxGroup(targetMO, c);
                                continue;
                            }
                            MessageLog.trace(1, TxDeviceGroupMoImpl.class, "As precondition for load sharing, initSector is not performed yet for : " + carriersForThatDbccDevice[i].getParent().getLocalDistinguishedName());
                            return;
                        }
                        ((CarrierMo)carriersForThatDbccDevice[i]).deletingDbccDevice(dbccDeviceRef, c);
                    }
                    continue;
                }
                MessageLog.trace(1, class$se$ericsson$wcdma$rbs$boam$mao$dmo$tr$TxDeviceGroupMoImpl == null ? TxDeviceGroupMoImpl.class$("se.ericsson.wcdma.rbs.boam.mao.dmo.tr.TxDeviceGroupMoImpl") : class$se$ericsson$wcdma$rbs$boam$mao$dmo$tr$TxDeviceGroupMoImpl, dbccDeviceRef.getLocalDistinguishedName() + " is not reserved by any Carrier");
            }
        } else {
            MessageLog.trace(1, TxDeviceGroupMoImpl.class, "No DbccDevice for :" + mo.getLocalDistinguishedName());
        }
    }

    private static ManagedObject getAnotherTxDeviceGroupFromSameBBP(ManagedObject mo, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(TxDeviceGroupMoImpl.class, "getAnotherTxDeviceGroupFromSameBBP()<---");
        boolean duwConfiguration = mo.getParent().getType().equals("PiuDevice");
        if (duwConfiguration) {
            return null;
        }
        ManagedObject subrackRef = BoamManagedObject.getAncestor(mo, "Subrack");
        int groupDepthFromSubrack = duwConfiguration ? 4 : 3;
        int dbccDepthFromGroup = 2;
        MoIterator ruifDeviceGroupIter = BoamHelper.findMOs("RuifDeviceGroup", subrackRef, groupDepthFromSubrack);
        MoIterator txDeviceGroupIter = BoamHelper.findMOs("TxDeviceGroup", subrackRef, groupDepthFromSubrack);
        int currentSlotNr = ((SlotMo)BoamManagedObject.getAncestor(mo, "Slot")).getSlotNumber(c);
        int boundaryBBPSlot = ((SubrackMo)subrackRef).getNumberOfSlots(c);
        int minSlot = 1;
        int maxSlot = boundaryBBPSlot;
        int twoBBP = 2;
        if (ruifDeviceGroupIter.size() != 0) {
            boundaryBBPSlot = ((SlotMo)BoamManagedObject.getAncestor(ruifDeviceGroupIter.nextMo(), "Slot")).getSlotNumber(c);
            if (currentSlotNr > boundaryBBPSlot) {
                minSlot = boundaryBBPSlot;
            } else {
                maxSlot = boundaryBBPSlot;
            }
            if (ruifDeviceGroupIter.size() == 2) {
                MessageLog.trace(1, TxDeviceGroupMoImpl.class, "Info : RBS with large configuration (2 BBP)!");
            }
        } else {
            MessageLog.trace(1, TxDeviceGroupMoImpl.class, "Info : RBS with no large configuration !");
        }
        if (txDeviceGroupIter.size() == 0) {
            return null;
        }
        MessageLog.trace(1, TxDeviceGroupMoImpl.class, "Info : look up of another TX from Slot " + minSlot + " to Slot " + maxSlot);
        while (txDeviceGroupIter.hasMoreElements()) {
            ManagedObject txRef = txDeviceGroupIter.nextMo();
            int txSlotNr = ((SlotMo)BoamManagedObject.getAncestor(txRef, "Slot")).getSlotNumber(c);
            if (txRef.equals(mo) || txSlotNr <= minSlot || txSlotNr >= maxSlot || BoamHelper.findMOs("DbccDevice", txRef, 2) == null || BoamHelper.findMOs("DbccDevice", txRef, 2).size() == 0) continue;
            MessageLog.trace(1, TxDeviceGroupMoImpl.class, "Another TX on same BBP found : " + txRef.getLocalDistinguishedName() + " for current : " + mo.getLocalDistinguishedName());
            return txRef;
        }
        return null;
    }

    public HsDbchDeviceSetMo getHsDbchDeviceSetMoIfIsInPlace(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getHsDbchDeviceSetMoIfIsInPlace()");
        MoIterator iter = this.getChildren();
        HsDbchDeviceSetMo result2 = null;
        while (iter.hasMoreElements()) {
            Object child = iter.nextElement();
            if (!(child instanceof HsDbchDeviceSetMo)) continue;
            result2 = (HsDbchDeviceSetMo)child;
        }
        return result2;
    }

    public String getType() {
        return "TxDeviceGroup";
    }

    public int getTpcMode(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTpcMode()");
        EqcGetTxGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getTxGroupParam(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context));
        return rspSig.tpcMode;
    }

    public void actionAttachRdbtAal5(ManagedObject aal5Ref, Coordinator c) throws MoAccessException, InternalErrorException, MoDisabledException {
        MessageLog.traceEnter(this.getClass(), "actionAttachRdbtAal5() is not in use !");
    }

    public void actionDetachRdbtAal5(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionDetachRdbtAal5() is not in use !");
    }

    public boolean getRdbtAal5Attached(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRdbtAal5Attached() is not in use !");
        return false;
    }

    public void actionStartL1AckMonitor(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartL1AckMonitor()");
        if (this.getParent().getType().equals("PiuDevice")) {
            throw new FunctionNotSupportedException();
        }
        int tpcMode = -1;
        int validParameter = 3;
        int numHsCodeResources = -1;
        int l1AckMonitoring = 16;
        int numEulResources = -1;
        try {
            this.eqcDeviceGroupProxy.setTxGroupParam(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context), validParameter, tpcMode, numHsCodeResources, 16, -1);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 29) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 12) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 27) {
                throw new MoDisabledException();
            }
            throw e;
        }
    }

    public void actionStartTpcMonitor(Coordinator context) throws MoAccessException, FroRequestFailedException {
        MessageLog.traceEnter(this.getClass(), "actionStartTpcMonitor()");
        if (this.getParent().getType().equals("PiuDevice")) {
            throw new FunctionNotSupportedException();
        }
        int tpcMode = 15;
        int validParameter = 1;
        int numHsCodeResources = -1;
        int l1AckMonitoring = -1;
        int numEulResources = -1;
        try {
            this.eqcDeviceGroupProxy.setTxGroupParam(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context), validParameter, tpcMode, numHsCodeResources, -1, -1);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 29) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 12) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 27) {
                throw new MoDisabledException();
            }
            throw e;
        }
    }

    public void actionStartHwTest(String testId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartHwTest()");
        super.actionStartHwTest(testId, context);
    }

    public void actionInitL1AckNormal(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionInitL1AckNormal()");
        if (this.getParent().getType().equals("PiuDevice")) {
            throw new FunctionNotSupportedException();
        }
        int tpcMode = -1;
        int validParameter = 3;
        int numHsCodeResources = -1;
        boolean l1AckMonitoring = false;
        int numEulResources = -1;
        try {
            this.eqcDeviceGroupProxy.setTxGroupParam(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context), validParameter, tpcMode, numHsCodeResources, 0, -1);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 29) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 12) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public void actionInitTpcNormal(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionInitTpcNormal()");
        if (this.getParent().getType().equals("PiuDevice")) {
            throw new FunctionNotSupportedException();
        }
        int tpcMode = 0;
        int validParameter = 1;
        int numHsCodeResources = -1;
        int l1AckMonitoring = -1;
        int numEulResources = -1;
        try {
            this.eqcDeviceGroupProxy.setTxGroupParam(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context), validParameter, tpcMode, numHsCodeResources, -1, -1);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 29) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 12) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public boolean getL1AckMonitorIsActive(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getL1AckMonitorIsActive()");
        EqcGetTxGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getTxGroupParam(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context));
        return rspSig.l1AckMonitorIsActive != 0;
    }

    public int getBbBusState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBbBusState()");
        EqcGetTxGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getTxGroupParam(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context));
        return rspSig.bbBusState;
    }

    private void initMoData(String checkedUserLabel, Coordinator context) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        MessageLog.traceEnter(this.getClass(), "initMoData() <---");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        MoDataHelper.createAndRegisterPersistentStringAttribute(this.getMyMoData(), "userLabel", checkedUserLabel, true);
        this.getMyMoData().setRevision(3040001);
    }

    public int getNumHsCodeResources(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNumHsCodeResources()<---");
        EqcGetTxGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getTxGroupParam(this.getTxIdNonTransactional(c), 0L, this.getGroupFroId(c));
        return rspSig.numHsCodeResources;
    }

    public void setNumHsCodeResources(int value, Coordinator c) throws MoAccessException, FroRequestFailedException {
        MessageLog.traceEnter(this.getClass(), "setNumHsCodeResources()<---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("numHsCodeResources", value, TxDeviceGroupMo.NUM_HS_CODE_RESOURCES_MIN_VALUES, TxDeviceGroupMo.NUM_HS_CODE_RESOURCES_MAX_VALUES, "TxDeviceGroup");
        int validParameter = 2;
        int tpcMode = -1;
        int l1AckMonitoring = -1;
        int numEulResources = -1;
        if (value < this.getNumHsCodeResources(c)) {
            this.checkHsNumCodeResourcesIdGreaterHsNumCodeResources(c, value);
        }
        try {
            this.eqcDeviceGroupProxy.setTxGroupParam(this.getTxIdTransactional(c), 0L, this.getGroupFroId(c), 2, -1, value, -1, -1);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 7) {
                throw new ValueOutOfRangeException("numHsCodeResources", "TxDeviceGroup");
            }
            throw e;
        }
        this.sendAVC("numHsCodeResources", value, c);
    }

    private void checkHsNumCodeResourcesIdGreaterHsNumCodeResources(Coordinator c, int v) throws MoAccessException {
        MoIterator dbccDeviceIter;
        int sumHsNumCodeResources = v;
        ManagedObject carrier = null;
        ManagedObject rbsLocalCell = null;
        ManagedObject dbccDevice = null;
        boolean duwConfiguration = this.getParent().getType().equals("PiuDevice");
        if (!duwConfiguration) {
            MoIterator allTxDeviceGroupIter = BoamHelper.findMOs("TxDeviceGroup");
            while (allTxDeviceGroupIter.hasMoreElements()) {
                ManagedObject currMo = allTxDeviceGroupIter.nextMo();
                if (currMo.getFullDistinguishedName().equals(this.getFullDistinguishedName())) continue;
                sumHsNumCodeResources += ((TxDeviceGroupMo)currMo).getNumHsCodeResources(c);
            }
        }
        if ((dbccDeviceIter = BoamHelper.findMOs("DbccDevice", this, 2)) != null) {
            while (dbccDeviceIter.hasMoreElements()) {
                dbccDevice = dbccDeviceIter.nextMo();
                if (((DbccDeviceMo)dbccDevice).getReservedBy(c).length <= 0 || ((CarrierMo)(carrier = ((DbccDeviceMo)dbccDevice).getReservedBy(c)[0])).getReservedBy(c).length <= 0 || sumHsNumCodeResources >= ((RbsLocalCellMo)(rbsLocalCell = ((CarrierMo)carrier).getReservedBy(c)[0])).getHsCodeResourceId(c)) continue;
                throw new ValueOutOfRangeException("numHsCodeResources", this.getType());
            }
        }
    }

    public int getNumEulResources(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNumEulResources()<---");
        EqcGetTxGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getTxGroupParam(this.getTxIdNonTransactional(c), 0L, this.getGroupFroId(c));
        return rspSig.numEulResources;
    }

    public void setNumEulResources(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setNumEulResources()<---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("numEulResources", value, TxDeviceGroupMo.NUM_EUL_RESOURCES_MIN_VALUES, TxDeviceGroupMo.NUM_EUL_RESOURCES_MAX_VALUES, "TxDeviceGroup");
        int validParameter = 4;
        int tpcMode = -1;
        int l1AckMonitoring = -1;
        int numHsCodeResources = -1;
        try {
            this.eqcDeviceGroupProxy.setTxGroupParam(this.getTxIdTransactional(c), 0L, this.getGroupFroId(c), 4, -1, -1, -1, value);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 7) {
                throw new ValueOutOfRangeException("numEulResources", "TxDeviceGroup");
            }
            throw e;
        }
        this.sendAVC("numEulResources", value, c);
    }

    public boolean getIsHiMonitoringStarted(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIsHiMonitoringStarted()<---");
        return this.eqcDeviceGroupProxy.getHiMonitoring((int)0, (int)this.getGroupFroId((Coordinator)c)).isHiMonitoringStarted == 1;
    }

    public int getStaticNumEulResources(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getStaticNumEulResources()<---");
        EqcGetTxGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getTxGroupParam(this.getTxIdNonTransactional(c), 0L, this.getGroupFroId(c));
        return rspSig.staticNumEulResources;
    }

    public int getStaticNumHsCodeResources(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getStaticNumHsCodeResources()<---");
        EqcGetTxGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getTxGroupParam(this.getTxIdNonTransactional(c), 0L, this.getGroupFroId(c));
        return rspSig.staticNumHsCodeResources;
    }

    public void actionStartHiMonitoring(Coordinator c) throws MoAccessException, AlreadyActiveException, InternalErrorException, FunctionNotSupportedException, MoDisabledException {
        MessageLog.traceEnter(this.getClass(), "actionStartHiMonitoring()<---");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        if (this.getParent().getType().equals("PiuDevice")) {
            throw new FunctionNotSupportedException();
        }
        try {
            this.eqcDeviceGroupProxy.startHiMonitoring(0, this.getGroupFroId(c));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 29) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 12) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 27) {
                throw new MoDisabledException();
            }
            if (e.getOrgErrorCode() == 25) {
                throw new FunctionNotSupportedException();
            }
            throw e;
        }
    }

    public void actionStopHiMonitoring(Coordinator c) throws MoAccessException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStopHiMonitoring()<---");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        try {
            this.eqcDeviceGroupProxy.stopHiMonitoring(0, this.getGroupFroId(c));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 14) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public void eventRaised(InSignal eventInd) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        if (eventInd instanceof EqcGroupEventIndS) {
            MessageLog.trace(6, this.getClass(), "EqcGroupEventIndS received");
            EqcGroupEventIndS recSig = (EqcGroupEventIndS)eventInd;
            String specificEvent = "";
            int eventIs = recSig.groupEventType;
            if (eventIs == 49153) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedBoardRestart";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
                AdditionalInfo[] additionalInfoList = new AdditionalInfo[]{new AdditionalInfo("Restart reason", recSig.additionalTextEvent)};
                String additionalText = this.bcmGetMEUserLabel();
                String objectClass = this.getType();
                String managedObjectInstance = this.getFullDistinguishedName();
                String eventType = "0";
                String eventTime = "";
                new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, additionalInfoList);
                MessageLog.trace(6, this.getClass(), "Event raised MO = " + objectClass + " " + "eventType = " + eventType + " " + "specificEvent = " + specificEvent);
            } else {
                super.eventRaised(eventInd);
            }
        } else {
            super.eventRaised(eventInd);
        }
    }
}

