/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.bb;

import enea.ose.system.InSignal;
import java.util.Enumeration;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcBbpProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcCreateDlbbpRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.InvalidReferenceException;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.DownlinkBaseBandPoolMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ConfigurationNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationNotAllowedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DownlinkBaseBandPoolMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NodeBFunctionMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsConst;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class DownlinkBaseBandPoolMoImpl
extends BoamManagedObjectWithAlarms
implements DownlinkBaseBandPoolMo {
    public static final int MO_DATA_REVISION = 5020000;
    protected ChcBbpProxy chcBbpProxy = ChcBbpProxy.instance();
    private final MoScanner myScanner;
    private int thisFroId = 0;
    private MoEvents myMoEvents;

    public DownlinkBaseBandPoolMoImpl(ManagedObject parent, AttrList attributes, String identity, String checkedUserLabel, int alarmStatus, Coordinator context) throws MoAccessException {
        super(parent, "DownlinkBaseBandPool", identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.initMoData(checkedUserLabel, attributes, context);
        this.initAlarmStatus(alarmStatus, context);
        EqcCreateDlbbpRspS rsp = this.chcBbpProxy.createDlbbp(this.getTxIdTransactional(context), 0L, Integer.parseInt(identity));
        this.thisFroId = (int)rsp.dlbbpFroId;
        IntegerAttribute tmpIntAttr = new IntegerAttribute("froId", false);
        tmpIntAttr.setValue(this.thisFroId);
        this.myData.registerPersistentAttr((Attribute)tmpIntAttr);
        this.myScanner = this.createMoScanner(false, context);
        this.addObservers(43, context);
    }

    public DownlinkBaseBandPoolMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        this.thisFroId = this.getFroId(null);
        try {
            this.addObservers(43, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        this.myScanner = this.createMoScanner();
        MessageLog.trace(1, this.getClass(), "Recovered PM as well");
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
    }

    protected static void checkParent(ManagedObject parent, String moTypeName) throws IllegalParentException {
        if (!(parent instanceof SubrackMo)) {
            IllegalParentException e = new IllegalParentException(moTypeName);
            throw e;
        }
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(DownlinkBaseBandPoolMoImpl.class, "create()");
        MessageLog.trace(1, DownlinkBaseBandPoolMoImpl.class, "Invalid Create attempt, this is a System Created MO");
        throw new OperationNotAllowedException();
    }

    public static synchronized ManagedObject createSystemMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(DownlinkBaseBandPoolMoImpl.class, "createSystemMo()");
        DownlinkBaseBandPoolMoImpl thisMo = null;
        DownlinkBaseBandPoolMoImpl.checkTransaction(context);
        DownlinkBaseBandPoolMoImpl.checkParent(parent, "DownlinkBaseBandPool");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "DownlinkBaseBandPool");
        int checkedAlarmStatus = DownlinkBaseBandPoolMoImpl.checkAndGetAlarmStatus(attributes, 0, "DownlinkBaseBandPool", context);
        ValidateAttributes.checkAndGetBooleanAttribute(attributes, "dlLimitedByLicenseLevel", "optional", true, false, true, "DownlinkBaseBandPool");
        ValidateAttributes.checkOtherAttributes(attributes, "DownlinkBaseBandPool");
        thisMo = new DownlinkBaseBandPoolMoImpl(parent, attributes, identity, checkedUserLabel, checkedAlarmStatus, context);
        return thisMo;
    }

    public void cleanAfterCommitDelete() {
        MessageLog.traceEnter(this.getClass(), "cleanAfterCommitDelete()");
    }

    private MoScanner createMoScanner(boolean recovery, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMoScanner()");
        int[] additionalInfo = new int[]{1};
        return new MoScanner(this, this.chcBbpProxy, this.thisFroId, 0, DownlinkBaseBandPoolMoFactory.instance().getCounters(), additionalInfo, recovery, context);
    }

    private MoScanner createMoScanner() {
        try {
            return this.createMoScanner(true, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't setup Counters!!", e);
            return null;
        }
    }

    public int[] getScannerValue(String name) throws MoAccessException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        if (this.getBaseBandPoolState(null) == 0) {
            return PmsConst.getCounterDefaultArray(name);
        }
        return this.myScanner.getValue(name);
    }

    public MoScanner getMoScannerForTest() {
        return this.myScanner;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        MessageLog.trace(1, DownlinkBaseBandPoolMoImpl.class, "Invalid Delete attempt, this is operation can only be performed by the System");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(ManagedObject caller, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.releasePool(caller, context);
        SequenceAttribute reservedBySeq = (SequenceAttribute)this.myData.getAttribute("radioInterfaceBoardRef");
        if (reservedBySeq.isEmpty()) {
            if (this.myScanner != null) {
                this.myScanner.delete(context);
            }
            this.chcBbpProxy.deleteDlbbp(this.getTxIdTransactional(context), 0L, this.thisFroId);
            this.removeObservers(context);
            this.myData.delete(context);
            super.delete(context);
            MessageLog.trace(1, this.getClass(), "DownlinkBaseBandPool Mo is Deleted ");
        }
    }

    public String getDownlinkBaseBandPoolId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDownlinkBaseBandPoolId() ");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute("froId");
        return attribute.getValue(context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public String getType() {
        return "DownlinkBaseBandPool";
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetStringAttribute("userLabel", context);
    }

    private void initMoData(String checkedUserLabel, AttrList attributes, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(super.getLocalDistinguishedName(), "DownlinkBaseBandPool", true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        SequenceAttribute radioInterfaceBoardRefAttrList = new SequenceAttribute("radioInterfaceBoardRef", false);
        this.myData.registerPersistentAttr((Attribute)radioInterfaceBoardRefAttrList);
        this.myData.setRevision(5020000);
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "DownlinkBaseBandPool", context);
        this.sendAVC("userLabel", value, context);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.chcBbpProxy, froType, this.getFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.chcBbpProxy, this.getFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }

    public int getDlGraceTimeLeft(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlGraceTimeLeft()");
        return NodeBFunctionMoImpl.getTheOneAndOnly() != null ? NodeBFunctionMoImpl.getTheOneAndOnly().getDlGraceTimeLeft(c) : 0;
    }

    public boolean getDlLimitedByLicenseLevel(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlLimitedByLicenseLevel()");
        return NodeBFunctionMoImpl.getTheOneAndOnly() != null ? NodeBFunctionMoImpl.getTheOneAndOnly().getDlLimitedByLicenseLevel(c) : false;
    }

    private ManagedObject[] getMoRefArray(SequenceAttribute MoRefAttrList, Coordinator context) throws MoAccessException {
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        Attribute[] attrList = MoRefAttrList.getValue(context);
        if (attrList == null) {
            MessageLog.trace(2, this.getClass(), "SequenceAttribute == null !?");
            return new ManagedObject[0];
        }
        int length = attrList.length;
        ManagedObject[] moRefArr = new ManagedObject[length];
        for (int i = 0; i < length; ++i) {
            moRefArr[i] = ((ReferenceAttribute)attrList[i]).getValue(context);
        }
        return moRefArr;
    }

    public ManagedObject[] getRadioInterfaceBoardRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRadioInterfaceBoardRef() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        SequenceAttribute radioInterfaceBoardRefAttrList = (SequenceAttribute)this.myData.getAttribute("radioInterfaceBoardRef");
        return this.getMoRefArray(radioInterfaceBoardRefAttrList, context);
    }

    private static ReferenceAttribute reserverSearch(ManagedObject userId, Coordinator context, MoData data, SequenceAttribute reservedBy) throws MoAccessException {
        data.handleTransaction(context, MoData.READ_ACCESS);
        Enumeration enumList = reservedBy.elements();
        while (enumList.hasMoreElements()) {
            ReferenceAttribute element = (ReferenceAttribute)enumList.nextElement();
            if (!userId.equals(element.getValue(context))) continue;
            return element;
        }
        return null;
    }

    public void reservePool(ManagedObject caller, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(DownlinkBaseBandPoolMoImpl.class, "reservePool()");
        if (caller == null) {
            throw new InvalidReferenceException(this.myData.getMoTypeName(), null);
        }
        SequenceAttribute seq = (SequenceAttribute)this.myData.getAttribute("radioInterfaceBoardRef");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (DownlinkBaseBandPoolMoImpl.reserverSearch(caller, context, this.myData, seq) == null) {
            ReferenceAttribute newRefElement = new ReferenceAttribute("", false);
            newRefElement.setValue(caller);
            seq.addElement((Attribute)newRefElement);
            ((Reservable)caller).reserve((ManagedObject)this, context);
        } else {
            MessageLog.traceError(this.getClass(), "reservePool(): userId (" + caller + ") already reserved by " + this.myData.getMoTypeName() + "/another MO.");
        }
    }

    public void releasePool(ManagedObject caller, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(DownlinkBaseBandPoolMoImpl.class, "releasePool()");
        if (caller == null) {
            throw new InvalidReferenceException(this.myData.getMoTypeName(), null);
        }
        SequenceAttribute reservedBySeq = (SequenceAttribute)this.myData.getAttribute("radioInterfaceBoardRef");
        ReferenceAttribute foundMo = DownlinkBaseBandPoolMoImpl.reserverSearch(caller, context, this.myData, reservedBySeq);
        if (foundMo == null) {
            MessageLog.traceState(this.getClass(), "release(): userId (" + caller + ") is not reserver/has already released ");
        } else {
            reservedBySeq.removeElement((Attribute)foundMo);
            ((Reservable)caller).release((ManagedObject)this, context);
            foundMo.setValue(null);
        }
    }

    public void eventRaised(InSignal receiveSig) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
    }

    public int getMaxNumADchReservation(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMaxNumADchReservation()<---");
        return this.chcBbpProxy.getBbpParam((long)((long)ValidateAttributes.getTxIdNonTransactional((Coordinator)c)), (int)this.thisFroId).maxNumADchReservation;
    }

    public void setMaxNumADchReservation(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setMaxNumADchReservation()<---");
        ValidateAttributes.checkTransaction(c);
        ValidateAttributes.intValueRangeCheck("maxNumADchReservation", value, DownlinkBaseBandPoolMo.MAX_NUM_A_DCH_RESERVATION_MIN_VALUES, DownlinkBaseBandPoolMo.MAX_NUM_A_DCH_RESERVATION_MAX_VALUES, "DownlinkBaseBandPool");
        this.chcBbpProxy.setBbpParam(ValidateAttributes.getTxIdTransactional(c), this.thisFroId, 1, value);
        this.sendAVC("maxNumADchReservation", value, c);
    }

    public int getBaseBandPoolState(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBaseBandPoolState()");
        return this.chcBbpProxy.getBbpParam((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (int)this.getFroId((Coordinator)c)).bbpStatus;
    }

    public int getNumHsCodeResources(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNumHsCodeResources()<---");
        return this.chcBbpProxy.getBbpParam((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (int)this.getFroId((Coordinator)c)).numHsCodeResources;
    }

    public void setNumHsCodeResources(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setNumHsCodeResources()<---");
        ValidateAttributes.checkTransaction(c);
        ValidateAttributes.intValueRangeCheck("numHsCodeResources", value, DownlinkBaseBandPoolMo.NUM_HS_CODE_RESOURCES_MIN_VALUES, DownlinkBaseBandPoolMo.NUM_HS_CODE_RESOURCES_MAX_VALUES, "DownlinkBaseBandPool");
        if (Integer.parseInt(this.getDownlinkBaseBandPoolId(c)) != 1 && Integer.parseInt(this.getDownlinkBaseBandPoolId(c)) != 3) {
            throw new ConfigurationNotSupportedException("The DownlinkBaseBandPool:numHsCodeResources is only taken into consideration when feature IncreasedCellCarrierSupport is ACTIVATED and the DownlinkBaseBandPoolId of this MO is 1 or 3");
        }
        this.chcBbpProxy.setBbpParam(ValidateAttributes.getTxIdTransactional(c), this.thisFroId, 2, value);
        this.sendAVC("numHsCodeResources", value, c);
    }

    public int getAvailableTotalCeDl(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailableTotalCeDl()");
        return this.chcBbpProxy.getBbpParam((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (int)this.getFroId((Coordinator)c)).availableTotalCe;
    }
}

