/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetRdiCableParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.LoPowTxCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RdiCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RruDeviceGroupMo;

public class RdiCableMoImpl
extends BoamManagedObjectWithAlarms
implements RdiCableMo {
    public static final int MO_DATA_REVISION = 24050300;
    private final EqcCableProxy eqcCableProxy = EqcCableProxy.instance();
    private final EqcRrhIndProxy eqcRrhIndProxy = EqcRrhIndProxy.instance();

    public RdiCableMoImpl(ManagedObject parent, AttrList attributes, String identity, Coordinator context, String userLabel, int alarmStatus, ManagedObject objectAConnectorRef, ManagedObject objectBConnectorRef, int objectAConnector) throws MoAccessException {
        super(parent, "RdiCable", identity, context);
        MessageLog.traceEnter(this.getClass(), " RdiCableMoImpl Normal constructor");
        int objAFroId = this.reserveAndGetFroId(objectAConnectorRef, context);
        int objBFroId = this.reserveAndGetFroId(objectBConnectorRef, context);
        this.checkAuxPiu(objectAConnectorRef, context);
        this.checkAuxPiu(objectBConnectorRef, context);
        EqcCreateCableRspS rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50166, 0L, objAFroId, objectAConnector, objBFroId, 0);
        int cableFroId = (int)rspSig.cableFroId;
        this.initMoData(userLabel, alarmStatus, objectAConnectorRef, objectBConnectorRef, cableFroId, context);
        this.addObservers(50166, context);
        MessageLog.trace(1, this.getClass(), this.getType() + " MO is Created ");
    }

    public RdiCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " RdiCableMoImpl Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(50166, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
        MessageLog.trace(1, this.getClass(), "RdiCable MO is Restored ");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RdiCableMoImpl.class, "create()");
        RdiCableMoImpl.checkTransaction(context);
        RdiCableMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "RdiCable");
        String[] acceptedClasses = new String[]{"AuxPlugInUnit"};
        ManagedObject checkedConnectedToObjectARef = ValidateAttributes.checkAndGetReferenceAttribute("connectedToObjectARef", attributes, "mandatory", acceptedClasses, "RdiCable");
        ManagedObject checkedConnectedToObjectBRef = ValidateAttributes.checkAndGetReferenceAttribute("connectedToObjectBRef", attributes, "mandatory", acceptedClasses, "RdiCable");
        int checkedObjectAConnector = ValidateAttributes.checkAndGetIntAttribute(attributes, "objectAConnector", "mandatory", 0, OBJECT_A_CONNECTOR_MIN_VALUES, OBJECT_A_CONNECTOR_MAX_VALUES, "RdiCable");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, LoPowTxCableMo.ALARM_STATUS_MIN_VALUES, LoPowTxCableMo.ALARM_STATUS_MAX_VALUES, "LoPowTxCable");
        ValidateAttributes.checkOtherAttributes(attributes, "RdiCable");
        RdiCableMoImpl createdMo = new RdiCableMoImpl(parent, attributes, identity, context, checkedUserLabel, checkedAlarmStatus, checkedConnectedToObjectARef, checkedConnectedToObjectBRef, checkedObjectAConnector);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.eqcCableProxy.deleteCable(this.getTxIdTransactional(context), 0, this.getFroId(context), 50166);
        ManagedObject connectedToObjectARef = this.getConnectedToObjectARef(context);
        ManagedObject connectedToObjectBRef = this.getConnectedToObjectBRef(context);
        this.releaseMo(connectedToObjectARef, context);
        this.releaseMo(connectedToObjectBRef, context);
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), this.getType() + " Mo is Deleted ");
    }

    public String getType() {
        return "RdiCable";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public int getObjectAConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectAConnector()");
        EqcGetRdiCableParamRspS rspSig = this.eqcCableProxy.getRdiCableParameters(this.getTxIdNonTransactional(context), 0, this.getFroId(context));
        return rspSig.objectAConnectorId;
    }

    public ManagedObject getConnectedToObjectARef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnectedToObjectARef()");
        ReferenceAttribute connectedToObjectARef = null;
        connectedToObjectARef = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectARef");
        return connectedToObjectARef.getValue(context);
    }

    public ManagedObject getConnectedToObjectBRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnectedToObjectBRef()");
        ReferenceAttribute connectedToObjectBRef = null;
        connectedToObjectBRef = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectBRef");
        return connectedToObjectBRef.getValue(context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        StringAttribute userLabelAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        return userLabelAttr.getValue(context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getFroId(Coordinator context) {
        int froId = 0;
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        try {
            froId = this.bcmGetIntAttribute("froId", context);
        }
        catch (MoAccessException moEx) {
            MessageLog.traceError(this.getClass(), "RdiCable Cannot retrive FroId");
        }
        return froId;
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcRrhIndProxy, froType, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        MessageLog.traceEnter(RdiCableMoImpl.class, "checkParent()");
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = " Illegal parent, Expecting EquipmentMo, received for: RdiCable";
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String userLabel, int alarmStatus, ManagedObject aConnectorRef, ManagedObject bConnectorRef, int froId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(24050300);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterReferenceAttribute("connectedToObjectARef", aConnectorRef);
        this.bcmStoreAndRegisterReferenceAttribute("connectedToObjectBRef", bConnectorRef);
        this.bcmStoreAndRegisterIntAttribute("froId", froId);
        this.initAlarmStatus(alarmStatus, context);
    }

    private void checkAuxPiu(ManagedObject auxPiuDevice, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkAuxPiu()");
        if (!this.checkAuxPiuRecursive(auxPiuDevice, c)) {
            throw new MoCanNotBeCreatedException("The necessay IRU,DOT must be created before Rdi cable:" + this.getFullDistinguishedName() + ",\n Please check the XxDeviceGroup/DeviceGroup under the connected Object:" + auxPiuDevice.getFullDistinguishedName());
        }
    }

    private boolean checkAuxPiuRecursive(ManagedObject auxPiuDevice, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkAuxPiuRecursive()");
        ManagedObject mo = null;
        MoIterator iter = auxPiuDevice.getChildren();
        while (iter.hasMoreElements()) {
            mo = iter.nextMo();
            if ((!(mo instanceof RruDeviceGroupMo) || ((AuxPlugInUnitMo)mo.getParent()).getAuType(c) != 27) && (!(mo instanceof DeviceGroupMo) || ((AuxPlugInUnitMo)mo.getParent()).getAuType(c) != 28)) continue;
            return true;
        }
        return false;
    }

    private int reserveAndGetFroId(ManagedObject auxMo, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "reserveAndGetFroId()");
        if (auxMo instanceof AuxPlugInUnitMo) {
            ((AuxPlugInUnitMo)auxMo).reserve(this, context);
            return ((AuxPlugInUnitMo)auxMo).getFroId(context);
        }
        return 0;
    }

    private void releaseMo(ManagedObject mo, Coordinator context) throws MoAccessException {
        if (mo instanceof AuxPlugInUnitMo) {
            ((AuxPlugInUnitMo)mo).release(this, context);
        }
    }
}

