/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.mechanics;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSubrackProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateSubrackRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsSubrackFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.emo.mechanics.RbsSlotMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSlotMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSubrackMo;

public class RbsSubrackMoImpl
extends BoamManagedObject
implements RbsSubrackMo {
    public static final String SUBRACK_FRO_ID = "subrackFroId";
    public static final int MO_DATA_REVISION = 3010001;
    private MoData myData;
    private EqcSubrackProxy eqcSubrackProxy = EqcSubrackProxy.instance();

    public RbsSubrackMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, String checkedSubrackPosition, String checkedCabinetPosition, int checkedNumberOfSlots, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), " RbsSubrackMoImpl()");
        this.initMoData(checkedUserLabel, checkedSubrackPosition, checkedCabinetPosition, checkedNumberOfSlots, identity, context);
        MessageLog.trace(1, this.getClass(), "RbsSubrack MO is Created ");
    }

    public RbsSubrackMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), " RbsSubrackMoImpl()");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "RbsSubrack MO Version " + this.myData.getRevision() + " is Restored ");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RbsSubrackMoImpl.class, "create()");
        RbsSubrackMoImpl.checkTransaction(context);
        RbsSubrackMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "RbsSubrack");
        String checkedSubrackPosition = ValidateAttributes.checkAndGetStringAttribute(attributes, "subrackPosition", "optional", "", Integer.MIN_VALUE, Integer.MAX_VALUE, "RbsSubrack");
        String checkedCabinetPosition = ValidateAttributes.checkAndGetStringAttribute(attributes, "cabinetPosition", "optional", "", 0, 2, "RbsSubrack");
        int checkedNumberOfSlots = ValidateAttributes.checkAndGetIntAttribute(attributes, "noOfSlots", "optional", 7, NO_OF_SLOTS_MIN_VALUES, NO_OF_SLOTS_MAX_VALUES, "RbsSubrack");
        ValidateAttributes.checkOtherAttributes(attributes, "RbsSubrack");
        RbsSubrackMoImpl createdMo = new RbsSubrackMoImpl(parent, "RbsSubrack", identity, context, checkedUserLabel, checkedSubrackPosition, checkedCabinetPosition, checkedNumberOfSlots, source);
        return createdMo;
    }

    public void delete(Coordinator c) throws MoAccessException, MoHasChildrenException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (this.isReserved(c)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.eqcSubrackProxy.deleteSubrack(this.getTxIdTransactional(c), 0, this.getRbsSubrackFroId(c));
        this.deleteSlots(c);
        super.delete(c);
        MessageLog.trace(1, this.getClass(), "RbsSubrack Mo is Deleted ");
    }

    public int getRbsSubrackFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRbsSubrackFroId()");
        return this.bcmGetIntAttribute(SUBRACK_FRO_ID, context);
    }

    public String getType() {
        return "RbsSubrack";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public int getNoOfSlots(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNoOfSlots()");
        return this.bcmGetIntAttribute("noOfSlots", context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "RbsSubrack", context);
        this.sendAVC("userLabel", value, context);
    }

    public void setSubrackPosition(String value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSubrackPosition() ");
        this.bcmSetStringAttribute("subrackPosition", value, Integer.MIN_VALUE, Integer.MAX_VALUE, "RbsSubrack", c);
        this.sendAVC("subrackPosition", value, c);
    }

    public String getSubrackPosition(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSubrackPosition() ");
        return this.bcmGetStringAttribute("subrackPosition", context);
    }

    public void setCabinetPosition(String value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCabinetPosition() ");
        this.bcmSetStringAttribute("cabinetPosition", value, 0, 2, "RbsSubrack", c);
        this.sendAVC("cabinetPosition", value, c);
    }

    public String getCabinetPosition(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCabinetPosition() ");
        return this.bcmGetStringAttribute("cabinetPosition", context);
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = " Illegal parent, Expecting EquipmentMo, received: ";
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String checkedUserLabel, String checkedSubrackPosition, String checkedCabinetPosition, int checkedNumberOfSlots, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(3010001);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterStringAttribute("subrackPosition", checkedSubrackPosition);
        this.bcmStoreAndRegisterStringAttribute("cabinetPosition", checkedCabinetPosition);
        this.bcmStoreAndRegisterIntAttribute("noOfSlots", checkedNumberOfSlots);
        EqcCreateSubrackRspS cfmSig = this.eqcSubrackProxy.createSubrack(this.getTxIdTransactional(context), 0L, 8);
        this.bcmStoreAndRegisterIntAttribute(SUBRACK_FRO_ID, (int)cfmSig.subrackFroInfo.subrackFroId);
        this.createSlots(checkedNumberOfSlots, cfmSig.subrackFroInfo, context);
    }

    private void createSlots(int noOfSlots, RbsSubrackFroInfoT subrackFroInfo, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createSlots() ");
        for (int i = 0; i < noOfSlots; ++i) {
            String identity = Integer.toString(i + 1);
            int slotFroId = (int)subrackFroInfo.slotFroInfo[i].slotFroId;
            MessageLog.trace(1, this.getClass(), "Creating RbsSlot #" + identity + " w. slotFroId=" + slotFroId);
            RbsSlotMoFactory.instance().createTheMo(this, null, identity, null, c, slotFroId);
        }
    }

    private void deleteSlots(Coordinator c) throws MoAccessException {
        MoIterator iter = this.getChildren();
        MessageLog.traceEnter(this.getClass(), "deleteSlots() ");
        while (iter.hasMoreElements()) {
            Object child = iter.nextElement();
            if (!(child instanceof RbsSlotMo)) continue;
            ((RbsSlotMo)child).deleteTheMo(c);
        }
    }
}

