/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.power;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcPowerDistributeProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreatePodsRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetPodsParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PdDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerDistrSystemMo;

public class PowerDistrSystemMoImpl
extends BoamManagedObjectWithAlarms
implements PowerDistrSystemMo {
    private static final String POWER_DISTR_SYSTEM_FRO_ID = "powerDistrSystemFroId";
    private static final int POS_MAX_NO_OF_CHILDREN = 1;
    public static final int MO_DATA_REVISION = 3020001;
    private EcPowerDistributeProxy roProxy = EcPowerDistributeProxy.instance();

    public PowerDistrSystemMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String userLabel, int currentOverloadAlarmLevel, int currentOverloadAlarmCeaseOffset, int inputOvervoltageAlarmLevel, int inputOvervoltageAlarmCeaseOffset, int inputUndervoltageAlarmLevel, int inputUndervoltageAlarmCeaseOffset, int systemOvervoltageAlarmLevel, int systemOvervoltageAlarmCeaseOffset, int systemUndervoltageAlarmLevel, int systemUndervoltageAlarmCeaseOffset, int alarmStatus) throws MoAccessException {
        super(parent, motypeName, identity, context, 1);
        MessageLog.traceEnter(this.getClass(), "PowerDistrSystemMoImpl()");
        this.initMoData(userLabel, alarmStatus, context);
        int podsFroId = this.createRo(currentOverloadAlarmLevel, currentOverloadAlarmCeaseOffset, inputOvervoltageAlarmLevel, inputOvervoltageAlarmCeaseOffset, inputUndervoltageAlarmLevel, inputUndervoltageAlarmCeaseOffset, systemOvervoltageAlarmLevel, systemOvervoltageAlarmCeaseOffset, systemUndervoltageAlarmLevel, systemUndervoltageAlarmCeaseOffset, context);
        this.bcmStoreAndRegisterIntAttribute(POWER_DISTR_SYSTEM_FRO_ID, podsFroId);
        this.addObservers(79, context);
    }

    public PowerDistrSystemMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " PowerDistrSystemMoImpl()");
        this.myData = recoveredData;
        try {
            this.addObservers(79, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(PowerDistrSystemMoImpl.class, "create()");
        PowerDistrSystemMoImpl.checkTransaction(context);
        PowerDistrSystemMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "PowerDistrSystem");
        int checkedCurrentOverloadAlarmLevel = ValidateAttributes.checkAndGetIntAttribute(attributes, "currentOverloadAlarmLevel", "optional", 110, CURRENT_OVERLOAD_ALARM_LEVEL_MIN_VALUES, CURRENT_OVERLOAD_ALARM_LEVEL_MAX_VALUES, "PowerDistrSystem");
        int checkedCurrentOverloadAlarmCeaseOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "currentOverloadAlarmCeaseOffset", "optional", 2, CURRENT_OVERLOAD_ALARM_CEASE_OFFSET_MIN_VALUES, CURRENT_OVERLOAD_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerDistrSystem");
        int checkedInputOvervoltageAlarmLevel = ValidateAttributes.checkAndGetIntAttribute(attributes, "inputOvervoltageAlarmLevel", "optional", -580, INPUT_OVERVOLTAGE_ALARM_LEVEL_MIN_VALUES, INPUT_OVERVOLTAGE_ALARM_LEVEL_MAX_VALUES, "PowerDistrSystem");
        int checkedInputOvervoltageAlarmCeaseOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "inputOvervoltageAlarmCeaseOffset", "optional", 10, INPUT_OVERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, INPUT_OVERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerDistrSystem");
        int checkedInputUndervoltageAlarmLevel = ValidateAttributes.checkAndGetIntAttribute(attributes, "inputUndervoltageAlarmLevel", "optional", -440, INPUT_UNDERVOLTAGE_ALARM_LEVEL_MIN_VALUES, INPUT_UNDERVOLTAGE_ALARM_LEVEL_MAX_VALUES, "PowerDistrSystem");
        int checkedInputUndervoltageAlarmCeaseOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "inputUndervoltageAlarmCeaseOffset", "optional", 30, INPUT_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, INPUT_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerDistrSystem");
        int checkedSystemOvervoltageAlarmLevel = ValidateAttributes.checkAndGetIntAttribute(attributes, "systemOvervoltageAlarmLevel", "optional", -580, SYSTEM_OVERVOLTAGE_ALARM_LEVEL_MIN_VALUES, SYSTEM_OVERVOLTAGE_ALARM_LEVEL_MAX_VALUES, "PowerDistrSystem");
        int checkedSystemOvervoltageAlarmCeaseOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "systemOvervoltageAlarmCeaseOffset", "optional", 5, SYSTEM_OVERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, SYSTEM_OVERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerDistrSystem");
        int checkedSystemUndervoltageAlarmLevel = ValidateAttributes.checkAndGetIntAttribute(attributes, "systemUndervoltageAlarmLevel", "optional", -440, SYSTEM_UNDERVOLTAGE_ALARM_LEVEL_MIN_VALUES, SYSTEM_UNDERVOLTAGE_ALARM_LEVEL_MAX_VALUES, "PowerDistrSystem");
        int checkedSystemUndervoltageAlarmCeaseOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "systemUndervoltageAlarmCeaseOffset", "optional", 5, SYSTEM_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, SYSTEM_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerDistrSystem");
        int checkedAlarmStatus = PowerDistrSystemMoImpl.checkAndGetAlarmStatus(attributes, 0, "PowerDistrSystem", context);
        ValidateAttributes.checkOtherAttributes(attributes, "PowerDistrSystem");
        PowerDistrSystemMoImpl createdMo = new PowerDistrSystemMoImpl(parent, "PowerDistrSystem", identity, context, checkedUserLabel, checkedCurrentOverloadAlarmLevel, checkedCurrentOverloadAlarmCeaseOffset, checkedInputOvervoltageAlarmLevel, checkedInputOvervoltageAlarmCeaseOffset, checkedInputUndervoltageAlarmLevel, checkedInputUndervoltageAlarmCeaseOffset, checkedSystemOvervoltageAlarmLevel, checkedSystemOvervoltageAlarmCeaseOffset, checkedSystemUndervoltageAlarmLevel, checkedSystemUndervoltageAlarmCeaseOffset, checkedAlarmStatus);
        return createdMo;
    }

    public String getPowerDistrSystemId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPowerDistrSystemId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public String getType() {
        return "PowerDistrSystem";
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public int getCurrentOverloadAlarmLevel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCurrentOverloadAlarmLevel()");
        return this.getRoValue("currentOverloadAlarmLevel", context);
    }

    public void setCurrentOverloadAlarmLevel(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCurrentOverloadAlarmLevel()");
        this.setRoValue(0, "currentOverloadAlarmLevel", value, CURRENT_OVERLOAD_ALARM_LEVEL_MIN_VALUES, CURRENT_OVERLOAD_ALARM_LEVEL_MAX_VALUES, context);
        this.sendAVC("currentOverloadAlarmLevel", value, context);
    }

    public int getCurrentOverloadAlarmCeaseOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCurrentOverloadAlarmCeaseOffset()");
        return this.getRoValue("currentOverloadAlarmCeaseOffset", context);
    }

    public void setCurrentOverloadAlarmCeaseOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCurrentOverloadAlarmCeaseOffset()");
        this.setRoValue(1, "currentOverloadAlarmCeaseOffset", value, CURRENT_OVERLOAD_ALARM_CEASE_OFFSET_MIN_VALUES, CURRENT_OVERLOAD_ALARM_CEASE_OFFSET_MAX_VALUES, context);
        this.sendAVC("currentOverloadAlarmCeaseOffset", value, context);
    }

    public int getInputOvervoltageAlarmLevel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getInputOvervoltageAlarmLevel()");
        return this.getRoValue("inputOvervoltageAlarmLevel", context);
    }

    public void setInputOvervoltageAlarmLevel(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setInputOvervoltageAlarmLevel()");
        this.setRoValue(2, "inputOvervoltageAlarmLevel", value, INPUT_OVERVOLTAGE_ALARM_LEVEL_MIN_VALUES, INPUT_OVERVOLTAGE_ALARM_LEVEL_MAX_VALUES, context);
        this.sendAVC("inputOvervoltageAlarmLevel", value, context);
    }

    public int getInputOvervoltageAlarmCeaseOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getInputOvervoltageAlarmCeaseOffset()");
        return this.getRoValue("inputOvervoltageAlarmCeaseOffset", context);
    }

    public void setInputOvervoltageAlarmCeaseOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setInputOvervoltageAlarmCeaseOffset()");
        this.setRoValue(3, "inputOvervoltageAlarmCeaseOffset", value, INPUT_OVERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, INPUT_OVERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, context);
        this.sendAVC("inputOvervoltageAlarmCeaseOffset", value, context);
    }

    public int getInputUndervoltageAlarmLevel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getInputUndervoltageAlarmLevel()");
        return this.getRoValue("inputUndervoltageAlarmLevel", context);
    }

    public void setInputUndervoltageAlarmLevel(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setInputUndervoltageAlarmLevel()");
        this.setRoValue(4, "inputUndervoltageAlarmLevel", value, INPUT_UNDERVOLTAGE_ALARM_LEVEL_MIN_VALUES, INPUT_UNDERVOLTAGE_ALARM_LEVEL_MAX_VALUES, context);
        this.sendAVC("inputUndervoltageAlarmLevel", value, context);
    }

    public int getInputUndervoltageAlarmCeaseOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getInputUndervoltageAlarmCeaseOffset()");
        return this.getRoValue("inputUndervoltageAlarmCeaseOffset", context);
    }

    public void setInputUndervoltageAlarmCeaseOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setInputUndervoltageAlarmCeaseOffset()");
        this.setRoValue(5, "inputUndervoltageAlarmCeaseOffset", value, INPUT_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, INPUT_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, context);
        this.sendAVC("inputUndervoltageAlarmCeaseOffset", value, context);
    }

    public int getSystemOvervoltageAlarmLevel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSystemOvervoltageAlarmLevel()");
        return this.getRoValue("systemOvervoltageAlarmLevel", context);
    }

    public void setSystemOvervoltageAlarmLevel(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSystemOvervoltageAlarmLevel()");
        this.setRoValue(6, "systemOvervoltageAlarmLevel", value, SYSTEM_OVERVOLTAGE_ALARM_LEVEL_MIN_VALUES, SYSTEM_OVERVOLTAGE_ALARM_LEVEL_MAX_VALUES, context);
        this.sendAVC("systemOvervoltageAlarmLevel", value, context);
    }

    public int getSystemOvervoltageAlarmCeaseOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSystemOvervoltageAlarmCeaseOffset()");
        return this.getRoValue("systemOvervoltageAlarmCeaseOffset", context);
    }

    public void setSystemOvervoltageAlarmCeaseOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSystemOvervoltageAlarmCeaseOffset()");
        this.setRoValue(7, "systemOvervoltageAlarmCeaseOffset", value, SYSTEM_OVERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, SYSTEM_OVERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, context);
        this.sendAVC("systemOvervoltageAlarmCeaseOffset", value, context);
    }

    public int getSystemUndervoltageAlarmLevel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSystemUndervoltageAlarmLevel()");
        return this.getRoValue("systemUndervoltageAlarmLevel", context);
    }

    public void setSystemUndervoltageAlarmLevel(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSystemUndervoltageAlarmLevel()");
        this.setRoValue(8, "systemUndervoltageAlarmLevel", value, SYSTEM_UNDERVOLTAGE_ALARM_LEVEL_MIN_VALUES, SYSTEM_UNDERVOLTAGE_ALARM_LEVEL_MAX_VALUES, context);
        this.sendAVC("systemUndervoltageAlarmLevel", value, context);
    }

    public int getSystemUndervoltageAlarmCeaseOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSystemUndervoltageAlarmCeaseOffset()");
        return this.getRoValue("systemUndervoltageAlarmCeaseOffset", context);
    }

    public void setSystemUndervoltageAlarmCeaseOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSystemUndervoltageAlarmCeaseOffset()");
        this.setRoValue(9, "systemUndervoltageAlarmCeaseOffset", value, SYSTEM_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, SYSTEM_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, context);
        this.sendAVC("systemUndervoltageAlarmCeaseOffset", value, context);
    }

    public int getCurrentLoad(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCurrentLoad()");
        return this.getRoValue("currentLoad", context);
    }

    public int getInputVoltage(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getInputVoltage()");
        return this.getRoValue("inputVoltage", context);
    }

    public int getSystemVoltage(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSystemVoltage()");
        return this.getRoValue("systemVoltage", context);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        return this.getRoValue("operationalState", context);
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(this.getRoValue("availabilityStatus", context));
    }

    public ManagedObject getPdDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPdDeviceRef() ");
        return this.bcmGetReferenceAttribute("pdDeviceRef", context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String str, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel()");
        this.bcmSetStringAttribute("userLabel", str, 0, 128, "PowerDistrSystem", context);
        this.sendAVC("userLabel", str, context);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.roProxy.deletePods(this.getTxIdTransactional(context), 0, this.getFroId(context));
        ManagedObject pdDevRef = this.bcmGetReferenceAttribute("pdDeviceRef", context);
        if (pdDevRef != null) {
            ((BoamManagedObject)pdDevRef).release(this, context);
        } else {
            String msg = "Device to be released is missing ";
            MessageLog.trace(1, this.getClass(), msg);
        }
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "PowerDistrSystem Mo is Deleted.");
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        try {
            return this.bcmGetIntAttribute(POWER_DISTR_SYSTEM_FRO_ID, context);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Can't find froId", e);
            return -1;
        }
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = parent != null ? " Illegal parent, Expecting EquipmentMo, received: " + parent.getClass().getName() : "parent is null";
            MessageLog.trace(1, PowerDistrSystemMoImpl.class, msg);
            throw new IllegalParentException(msg);
        }
    }

    private int createRo(int currentOverloadAlarmLevel, int currentOverloadAlarmCeaseOffset, int inputOvervoltageAlarmLevel, int inputOvervoltageAlarmCeaseOffset, int inputUndervoltageAlarmLevel, int inputUndervoltageAlarmCeaseOffset, int systemOvervoltageAlarmLevel, int systemOvervoltageAlarmCeaseOffset, int systemUndervoltageAlarmLevel, int systemUndervoltageAlarmCeaseOffset, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " createRo() ");
        LrsCreatePodsRspS cfmSig = this.roProxy.createPods(this.getTxIdTransactional(context), 0, currentOverloadAlarmLevel, currentOverloadAlarmCeaseOffset, inputOvervoltageAlarmLevel, inputOvervoltageAlarmCeaseOffset, inputUndervoltageAlarmLevel, inputUndervoltageAlarmCeaseOffset, systemOvervoltageAlarmLevel, systemOvervoltageAlarmCeaseOffset, systemUndervoltageAlarmLevel, systemUndervoltageAlarmCeaseOffset);
        int pdDevFroId = cfmSig.pdDevFroId;
        this.findStoreAndReservePdDevMoRef(pdDevFroId, context);
        MessageLog.trace(1, this.getClass(), "Pd Device reserved, fRO ID=" + pdDevFroId);
        int podsFroId = cfmSig.podsFroId;
        MessageLog.trace(1, this.getClass(), " RO is created; PODS fRO ID=" + podsFroId);
        return podsFroId;
    }

    private void findStoreAndReservePdDevMoRef(int roFroId, Coordinator context) throws MoAccessException {
        ManagedObject iterMoRef = null;
        ManagedObject moRef = null;
        int noOfMatchedDev = 0;
        ManagedObject root = this.getParent();
        int deep = 6;
        MessageLog.traceEnter(this.getClass(), " findStoreAndReservePdDevMoRef()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        MoIterator iter = MoRepository.instance().select(root, deep, (MoFilter)new MoTypeFilter("PdDevice"));
        while (iter.hasMoreElements()) {
            iterMoRef = iter.nextMo();
            int iterFroId = ((PdDeviceMo)iterMoRef).getAuxDeviceFroId(context);
            String msg = "Checking a PdDevice MAO, iterFroId : " + iterFroId + "? == ? roFroId : " + roFroId;
            MessageLog.trace(1, this.getClass(), msg);
            if (iterFroId == roFroId) {
                if (noOfMatchedDev < 1) {
                    moRef = iterMoRef;
                    ++noOfMatchedDev;
                    String msg1 = " The allocated PD Device has been found.";
                    MessageLog.trace(1, this.getClass(), msg1);
                    continue;
                }
                String msg2 = " Strange fro values, apparantly several MAOs have identical froId value for PD Device.";
                MessageLog.traceError(this.getClass(), msg2);
                continue;
            }
            MessageLog.trace(1, this.getClass(), "PdDevice MAO found with other froId=" + iterFroId);
        }
        if (moRef == null) {
            throw new MoCanNotBeCreatedException(this.getType());
        }
        ((PdDeviceMo)moRef).reserve(this, context);
        this.bcmStoreAndRegisterReferenceAttribute("pdDeviceRef", moRef);
    }

    private void initMoData(String userLabel, int alarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.initAlarmStatus(alarmStatus, context);
        this.myData.setRevision(3020001);
    }

    private int getRoValue(String attrName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getRoValue() " + attrName);
        LrsGetPodsParamRspS getRsp = this.roProxy.getPodsParam(this.getTxIdNonTransactional(context), 0, this.getFroId(context));
        int attrVal = 0;
        if (attrName.equals("currentOverloadAlarmLevel")) {
            attrVal = getRsp.currentOverloadAlarmLevel;
        } else if (attrName.equals("currentOverloadAlarmCeaseOffset")) {
            attrVal = getRsp.currentOverloadAlarmCeaseOffset;
        } else if (attrName.equals("inputOvervoltageAlarmLevel")) {
            attrVal = getRsp.inputOvervoltageAlarmLevel;
        } else if (attrName.equals("inputOvervoltageAlarmCeaseOffset")) {
            attrVal = getRsp.inputOvervoltageAlarmCeaseOffset;
        } else if (attrName.equals("inputUndervoltageAlarmLevel")) {
            attrVal = getRsp.inputUndervoltageAlarmLevel;
        } else if (attrName.equals("inputUndervoltageAlarmCeaseOffset")) {
            attrVal = getRsp.inputUndervoltageAlarmCeaseOffset;
        } else if (attrName.equals("systemOvervoltageAlarmLevel")) {
            attrVal = getRsp.systemOvervoltageAlarmLevel;
        } else if (attrName.equals("systemOvervoltageAlarmCeaseOffset")) {
            attrVal = getRsp.systemOvervoltageAlarmCeaseOffset;
        } else if (attrName.equals("systemUndervoltageAlarmLevel")) {
            attrVal = getRsp.systemUndervoltageAlarmLevel;
        } else if (attrName.equals("systemUndervoltageAlarmCeaseOffset")) {
            attrVal = getRsp.systemUndervoltageAlarmCeaseOffset;
        } else if (attrName.equals("currentLoad")) {
            attrVal = getRsp.currentLoad;
        } else if (attrName.equals("inputVoltage")) {
            attrVal = getRsp.inputVoltage;
        } else if (attrName.equals("systemVoltage")) {
            attrVal = getRsp.systemVoltage;
        } else if (attrName.equals("operationalState")) {
            attrVal = getRsp.operationalState;
        } else if (attrName.equals("availabilityStatus")) {
            attrVal = getRsp.availabilityStatus;
        } else {
            MessageLog.traceError(this.getClass(), " Unknown RO value name, should never happen!");
        }
        return attrVal;
    }

    private void setRoValue(int paramId, String attrName, int value, int[] minValues, int[] maxValues, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setRoValue(), paramId = " + paramId);
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck(attrName, value, minValues, maxValues, this.getType());
        this.roProxy.setPodsParam(this.getTxIdTransactional(context), 0, this.getFroId(context), paramId, value);
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.roProxy, froType, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }
}

