/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.power;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSubrackProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateSubrackRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsSubrackFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.emo.mechanics.RbsSlotMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSlotMo;

public class PowerSupplySubrackMoImpl
extends BoamManagedObject
implements PowerSupplySubrackMo {
    public static final String SUBRACK_FRO_ID = "subrackFroId";
    public static final int MO_DATA_REVISION = 2040001;
    private MoData myData;
    private EqcSubrackProxy eqcSubrackProxy = EqcSubrackProxy.instance();

    public PowerSupplySubrackMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, String checkedSubrackPosition, String checkedCabinetPosition, int noOfSlots, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), " PowerSupplySubrack Normal constructor");
        this.initMoData(checkedUserLabel, checkedSubrackPosition, checkedCabinetPosition, noOfSlots, identity, context);
    }

    public PowerSupplySubrackMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), " PowerSupplySubrack recovery constructor");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "MO is Restored, version Attribute in MoData = " + this.myData.getRevision());
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(PowerSupplySubrackMoImpl.class, "create()");
        PowerSupplySubrackMoImpl.checkTransaction(context);
        PowerSupplySubrackMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "PowerSupplySubrack");
        String checkedSubrackPosition = ValidateAttributes.checkAndGetStringAttribute(attributes, "subrackPosition", "mandatory", "", Integer.MIN_VALUE, Integer.MAX_VALUE, "PowerSupplySubrack");
        String checkedCabinetPosition = ValidateAttributes.checkAndGetStringAttribute(attributes, "cabinetPosition", "optional", "", 0, 2, "PowerSupplySubrack");
        int checkedNumberOfSlots = ValidateAttributes.checkAndGetIntAttribute(attributes, "noOfSlots", "optional", 7, NO_OF_SLOTS_MIN_VALUES, NO_OF_SLOTS_MAX_VALUES, "PowerSupplySubrack");
        ValidateAttributes.checkOtherAttributes(attributes, "PowerSupplySubrack");
        PowerSupplySubrackMoImpl.checkNumberOfSlots(checkedNumberOfSlots);
        PowerSupplySubrackMoImpl createdMo = new PowerSupplySubrackMoImpl(parent, "PowerSupplySubrack", identity, context, checkedUserLabel, checkedSubrackPosition, checkedCabinetPosition, checkedNumberOfSlots, source);
        return createdMo;
    }

    public void delete(Coordinator c) throws MoAccessException, MoHasChildrenException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (super.isReserved(c)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.deleteRo(c);
        this.deleteSlots(c);
        this.myData.delete(c);
        super.delete(c);
        MessageLog.trace(1, this.getClass(), "PowerSupplySubrack Mo is Deleted ");
    }

    public int getPowerSupplySubrackFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPowerSupplySubrackFroId()");
        return this.bcmGetIntAttribute(SUBRACK_FRO_ID, context);
    }

    public String getType() {
        return "PowerSupplySubrack";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "PowerSupplySubrack", context);
        this.sendAVC("userLabel", value, context);
    }

    public String getSubrackPosition(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSubrackPosition() ");
        return this.bcmGetStringAttribute("subrackPosition", context);
    }

    public void setSubrackPosition(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSubrackPosition() ");
        this.bcmSetStringAttribute("subrackPosition", value, Integer.MIN_VALUE, Integer.MAX_VALUE, "PowerSupplySubrack", context);
        this.sendAVC("subrackPosition", value, context);
    }

    public String getCabinetPosition(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCabinetPosition() ");
        return this.bcmGetStringAttribute("cabinetPosition", context);
    }

    public void setCabinetPosition(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCabinetPosition() ");
        this.bcmSetStringAttribute("cabinetPosition", value, 0, 2, "PowerSupplySubrack", context);
        this.sendAVC("cabinetPosition", value, context);
    }

    public int getNoOfSlots(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNoOfSlots()");
        return this.bcmGetIntAttribute("noOfSlots", context);
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = parent != null ? " Illegal parent, Expecting EquipmentMo, received: " + parent.getClass().getName() : "parent is null";
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String checkedUserLabel, String checkedSubrackPosition, String checkedCabinetPosition, int nrOfSlots, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(2040001);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterStringAttribute("subrackPosition", checkedSubrackPosition);
        this.bcmStoreAndRegisterStringAttribute("cabinetPosition", checkedCabinetPosition);
        RbsSubrackFroInfoT subrackFroInfo = this.createRo(context);
        this.bcmStoreAndRegisterIntAttribute(SUBRACK_FRO_ID, (int)subrackFroInfo.subrackFroId);
        this.bcmStoreAndRegisterIntAttribute("noOfSlots", nrOfSlots);
        this.createSlots(nrOfSlots, subrackFroInfo, context);
    }

    private RbsSubrackFroInfoT createRo(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        EqcCreateSubrackRspS cfmSig;
        MessageLog.traceEnter(this.getClass(), "createRo() ");
        try {
            cfmSig = this.eqcSubrackProxy.createSubrack(this.getTxIdTransactional(context), 0L, 3);
        }
        catch (FroNotAccessibleException e) {
            super.delete(context);
            throw e;
        }
        catch (FroRequestFailedException e) {
            super.delete(context);
            throw e;
        }
        if (cfmSig.subrackFroInfo.subrackType != 3) {
            String msg = "EqcCreateSubrackRspS.subrackType differs to the sent type from BOAM to EQC ";
            MessageLog.traceError(this.getClass(), msg);
        }
        if (NO_OF_SLOTS_MAX_VALUES.length > 1) {
            String msg2 = "Valid range for the attribute noOfSlots is assumed to be a single interval, but NO_OF_SLOTS_MAX_VALUES.length is " + NO_OF_SLOTS_MAX_VALUES.length;
            MessageLog.traceError(this.getClass(), msg2);
        } else if (cfmSig.subrackFroInfo.numberOfSlots > NO_OF_SLOTS_MAX_VALUES[0]) {
            String msg3 = "EqcCreateSubrackRspS.numberOfSlots is " + Integer.toString(cfmSig.subrackFroInfo.numberOfSlots) + " This number exceeds the max number of slots which is " + Integer.toString(NO_OF_SLOTS_MAX_VALUES[0]);
            MessageLog.traceError(this.getClass(), msg3);
        }
        return cfmSig.subrackFroInfo;
    }

    private void deleteRo(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteRo() ");
        this.eqcSubrackProxy.deleteSubrack(this.getTxIdTransactional(context), 0, this.getPowerSupplySubrackFroId(context));
    }

    private void createSlots(int noOfSlots, RbsSubrackFroInfoT subrackFroInfo, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createSlots() ");
        for (int i = 0; i < noOfSlots; ++i) {
            String identity = Integer.toString(i + 1);
            int slotFroId = (int)subrackFroInfo.slotFroInfo[i].slotFroId;
            RbsSlotMoFactory.instance().createTheMo(this, null, identity, null, c, slotFroId);
        }
    }

    private void deleteSlots(Coordinator c) throws MoAccessException {
        MoIterator iter = this.getChildren();
        MessageLog.traceEnter(this.getClass(), "deleteSlots() ");
        while (iter.hasMoreElements()) {
            Object child = iter.nextElement();
            if (!(child instanceof RbsSlotMo)) continue;
            ((RbsSlotMo)child).deleteTheMo(c);
        }
    }

    private static void checkNumberOfSlots(int noOfSlots) throws ValueOutOfRangeException {
        if (noOfSlots != 1 && noOfSlots != 3 && noOfSlots != 7) {
            throw new ValueOutOfRangeException("noOfSlots", "PowerSupplySubrack");
        }
    }
}

