/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.pnp;

import enea.ose.system.InSignal;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.PlugAndPlayObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupHwMismatchCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupHwMismatchIndS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.pnp.Job;
import se.ericsson.wcdma.rbs.boam.mao.pnp.JobSchedulerListener;
import se.ericsson.wcdma.rbs.boam.mao.pnp.PnpJob;

public class PlugAndPlay
implements PlugAndPlayObserver,
JobSchedulerListener {
    public static final int NO_OF_RETRY = 50;
    private ManagedObject myMo = null;
    private FroProxy myFroProxy = null;
    private int froId = 0;

    public PlugAndPlay(ManagedObject mo, FroProxy proxy, int froId, Coordinator context) {
        this.myMo = mo;
        this.froId = froId;
        this.myFroProxy = proxy;
        this.setUp(context);
    }

    public void delete(Coordinator context) throws MoAccessException {
        this.myFroProxy.deRegisterForPlugAndPLayInd(context, this.froId);
    }

    private void setUp(Coordinator context) {
        if (this.myMo != null && this.myFroProxy != null) {
            this.myFroProxy.registerForPlugAndPLayInd(context, this, this.froId);
        } else {
            MessageLog.traceError(this.getClass(), "setUp(), Mo or the proxy object list is null!!");
        }
    }

    public void plugAndPlayInd(InSignal pnpIndSig) {
        MessageLog.traceEnter(this.getClass(), "plugAndPlayInd()Plug and play signal is received, scheduling  new job for signal:" + pnpIndSig.getClass().getName());
        new PnpJob(this, pnpIndSig);
    }

    public void execute(Job aJob) {
        if (aJob instanceof PnpJob) {
            InSignal pnpIndSig = ((PnpJob)aJob).getIndSignal();
            if (pnpIndSig instanceof EqcGroupHwMismatchIndS) {
                AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)this.myMo.getParent();
                try {
                    String hwProductNumber = ((EqcGroupHwMismatchIndS)pnpIndSig).hwProductNumber;
                    String hwProductRevision = ((EqcGroupHwMismatchIndS)pnpIndSig).hwProductRevision;
                    String hwProductName = ((EqcGroupHwMismatchIndS)pnpIndSig).hwProductName;
                    String preInstalledSwProdNum = ((EqcGroupHwMismatchIndS)pnpIndSig).preInstalledSwProdNum;
                    String preInstalledSwProdRev = ((EqcGroupHwMismatchIndS)pnpIndSig).preInstalledSwProdRev;
                    String infoStr = "\n new HW PID: hwProductNumber=" + hwProductNumber + ", hwProductRevision=" + hwProductRevision + ", hwProductName=" + hwProductName + ", preInstalledSwProdNum=" + preInstalledSwProdNum + ", preInstalledSwProdRev=" + preInstalledSwProdRev;
                    MessageLog.info(this.getClass(), "Start to execute Upgrade Task Hw Mismatch indication for: AuxPiu : " + auxPiu.getLocalDistinguishedName() + infoStr);
                    auxPiu.reconfigureProgAfterHwUpgradeRetry(hwProductNumber, hwProductRevision, hwProductName, preInstalledSwProdNum, preInstalledSwProdRev, 50);
                    MessageLog.info(this.getClass(), "Upgrade Task Hw Mismatch indication executed succesfully for: AuxPiu : " + auxPiu.getLocalDistinguishedName() + infoStr);
                }
                catch (MoAccessException e) {
                    MessageLog.traceError(this.getClass(), "Execution of Upgrade Task Hw Mismatch indication is failed due to exception:" + (Object)((Object)e));
                }
            } else if (pnpIndSig instanceof EqcGroupHwMismatchCeaseIndS) {
                AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)this.myMo.getParent();
                MessageLog.info(this.getClass(), "Start to execute Upgrade Task Hw Mismatch ceased indication for: AuxPiu : " + auxPiu.getLocalDistinguishedName());
                try {
                    auxPiu.hwMismatchCeaseReceived();
                    MessageLog.info(this.getClass(), "Upgrade Task Hw Mismatch ceased indication executed succesfully for: AuxPiu : " + auxPiu.getLocalDistinguishedName());
                }
                catch (MoAccessException mae) {
                    MessageLog.traceError(this.getClass(), "Execution of Upgrade Task  HW Mismatch cease Indication is failed due to exception:" + (Object)((Object)mae));
                }
            } else {
                MessageLog.info(this.getClass(), "Unsupported signal received:" + pnpIndSig.getClass().getName());
            }
        } else {
            MessageLog.info(this.getClass(), "Unsupported job received:" + aJob.getClass().getName());
        }
    }
}

